// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * The response from a GetSampledRequests request includes a `SampledHTTPRequests` complex type that appears as `SampledRequests` in the response syntax. `SampledHTTPRequests` contains one `SampledHTTPRequest` object for each web request that is returned by `GetSampledRequests`.
 */
public class SampledHttpRequest private constructor(builder: Builder) {
    /**
     * The action for the `Rule` that the request matched: `ALLOW`, `BLOCK`, or `COUNT`.
     */
    public val action: kotlin.String? = builder.action
    /**
     * A complex type that contains detailed information about the request.
     */
    public val request: aws.sdk.kotlin.services.waf.model.HttpRequest? = builder.request
    /**
     * This value is returned if the `GetSampledRequests` request specifies the ID of a `RuleGroup` rather than the ID of an individual rule. `RuleWithinRuleGroup` is the rule within the specified `RuleGroup` that matched the request listed in the response.
     */
    public val ruleWithinRuleGroup: kotlin.String? = builder.ruleWithinRuleGroup
    /**
     * The time at which AWS WAF received the request from your AWS resource, in Unix time format (in seconds).
     */
    public val timestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.timestamp
    /**
     * A value that indicates how one result in the response relates proportionally to other results in the response. A result that has a weight of `2` represents roughly twice as many CloudFront web requests as a result that has a weight of `1`.
     */
    public val weight: kotlin.Long = builder.weight

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.waf.model.SampledHttpRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SampledHttpRequest(")
        append("action=$action,")
        append("request=$request,")
        append("ruleWithinRuleGroup=$ruleWithinRuleGroup,")
        append("timestamp=$timestamp,")
        append("weight=$weight")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (request?.hashCode() ?: 0)
        result = 31 * result + (ruleWithinRuleGroup?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        result = 31 * result + (weight.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SampledHttpRequest

        if (action != other.action) return false
        if (request != other.request) return false
        if (ruleWithinRuleGroup != other.ruleWithinRuleGroup) return false
        if (timestamp != other.timestamp) return false
        if (weight != other.weight) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.waf.model.SampledHttpRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The action for the `Rule` that the request matched: `ALLOW`, `BLOCK`, or `COUNT`.
         */
        public var action: kotlin.String? = null
        /**
         * A complex type that contains detailed information about the request.
         */
        public var request: aws.sdk.kotlin.services.waf.model.HttpRequest? = null
        /**
         * This value is returned if the `GetSampledRequests` request specifies the ID of a `RuleGroup` rather than the ID of an individual rule. `RuleWithinRuleGroup` is the rule within the specified `RuleGroup` that matched the request listed in the response.
         */
        public var ruleWithinRuleGroup: kotlin.String? = null
        /**
         * The time at which AWS WAF received the request from your AWS resource, in Unix time format (in seconds).
         */
        public var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A value that indicates how one result in the response relates proportionally to other results in the response. A result that has a weight of `2` represents roughly twice as many CloudFront web requests as a result that has a weight of `1`.
         */
        public var weight: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.waf.model.SampledHttpRequest) : this() {
            this.action = x.action
            this.request = x.request
            this.ruleWithinRuleGroup = x.ruleWithinRuleGroup
            this.timestamp = x.timestamp
            this.weight = x.weight
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.waf.model.SampledHttpRequest = SampledHttpRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.waf.model.HttpRequest] inside the given [block]
         */
        public fun request(block: aws.sdk.kotlin.services.waf.model.HttpRequest.Builder.() -> kotlin.Unit) {
            this.request = aws.sdk.kotlin.services.waf.model.HttpRequest.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
