// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Specifies a `Predicate` (such as an `IPSet`) and indicates whether you want to add it to a `Rule` or delete it from a `Rule`.
 */
public class RuleUpdate private constructor(builder: Builder) {
    /**
     * Specify `INSERT` to add a `Predicate` to a `Rule`. Use `DELETE` to remove a `Predicate` from a `Rule`.
     */
    public val action: aws.sdk.kotlin.services.waf.model.ChangeAction = requireNotNull(builder.action) { "A non-null value must be provided for action" }
    /**
     * The ID of the `Predicate` (such as an `IPSet`) that you want to add to a `Rule`.
     */
    public val predicate: aws.sdk.kotlin.services.waf.model.Predicate? = builder.predicate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.waf.model.RuleUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RuleUpdate(")
        append("action=$action,")
        append("predicate=$predicate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action.hashCode()
        result = 31 * result + (predicate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RuleUpdate

        if (action != other.action) return false
        if (predicate != other.predicate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.waf.model.RuleUpdate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specify `INSERT` to add a `Predicate` to a `Rule`. Use `DELETE` to remove a `Predicate` from a `Rule`.
         */
        public var action: aws.sdk.kotlin.services.waf.model.ChangeAction? = null
        /**
         * The ID of the `Predicate` (such as an `IPSet`) that you want to add to a `Rule`.
         */
        public var predicate: aws.sdk.kotlin.services.waf.model.Predicate? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.waf.model.RuleUpdate) : this() {
            this.action = x.action
            this.predicate = x.predicate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.waf.model.RuleUpdate = RuleUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.waf.model.Predicate] inside the given [block]
         */
        public fun predicate(block: aws.sdk.kotlin.services.waf.model.Predicate.Builder.() -> kotlin.Unit) {
            this.predicate = aws.sdk.kotlin.services.waf.model.Predicate.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (action == null) action = ChangeAction.SdkUnknown("no value provided")
            return this
        }
    }
}
