// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returned by ListRegexPatternSets. Each `RegexPatternSetSummary` object includes the `Name` and `RegexPatternSetId` for one RegexPatternSet.
 */
public class RegexPatternSetSummary private constructor(builder: Builder) {
    /**
     * A friendly name or description of the RegexPatternSet. You can't change `Name` after you create a `RegexPatternSet`.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The `RegexPatternSetId` for a `RegexPatternSet`. You use `RegexPatternSetId` to get information about a `RegexPatternSet`, update a `RegexPatternSet`, remove a `RegexPatternSet` from a `RegexMatchSet`, and delete a `RegexPatternSet` from AWS WAF.
     *
     * `RegexPatternSetId` is returned by CreateRegexPatternSet and by ListRegexPatternSets.
     */
    public val regexPatternSetId: kotlin.String = requireNotNull(builder.regexPatternSetId) { "A non-null value must be provided for regexPatternSetId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.waf.model.RegexPatternSetSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegexPatternSetSummary(")
        append("name=$name,")
        append("regexPatternSetId=$regexPatternSetId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name.hashCode()
        result = 31 * result + (regexPatternSetId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegexPatternSetSummary

        if (name != other.name) return false
        if (regexPatternSetId != other.regexPatternSetId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.waf.model.RegexPatternSetSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A friendly name or description of the RegexPatternSet. You can't change `Name` after you create a `RegexPatternSet`.
         */
        public var name: kotlin.String? = null
        /**
         * The `RegexPatternSetId` for a `RegexPatternSet`. You use `RegexPatternSetId` to get information about a `RegexPatternSet`, update a `RegexPatternSet`, remove a `RegexPatternSet` from a `RegexMatchSet`, and delete a `RegexPatternSet` from AWS WAF.
         *
         * `RegexPatternSetId` is returned by CreateRegexPatternSet and by ListRegexPatternSets.
         */
        public var regexPatternSetId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.waf.model.RegexPatternSetSummary) : this() {
            this.name = x.name
            this.regexPatternSetId = x.regexPatternSetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.waf.model.RegexPatternSetSummary = RegexPatternSetSummary(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (regexPatternSetId == null) regexPatternSetId = ""
            return this
        }
    }
}
