// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returned by ListRegexMatchSets. Each `RegexMatchSetSummary` object includes the `Name` and `RegexMatchSetId` for one RegexMatchSet.
 */
public class RegexMatchSetSummary private constructor(builder: Builder) {
    /**
     * A friendly name or description of the RegexMatchSet. You can't change `Name` after you create a `RegexMatchSet`.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The `RegexMatchSetId` for a `RegexMatchSet`. You use `RegexMatchSetId` to get information about a `RegexMatchSet`, update a `RegexMatchSet`, remove a `RegexMatchSet` from a `Rule`, and delete a `RegexMatchSet` from AWS WAF.
     *
     * `RegexMatchSetId` is returned by CreateRegexMatchSet and by ListRegexMatchSets.
     */
    public val regexMatchSetId: kotlin.String = requireNotNull(builder.regexMatchSetId) { "A non-null value must be provided for regexMatchSetId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.waf.model.RegexMatchSetSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegexMatchSetSummary(")
        append("name=$name,")
        append("regexMatchSetId=$regexMatchSetId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name.hashCode()
        result = 31 * result + (regexMatchSetId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegexMatchSetSummary

        if (name != other.name) return false
        if (regexMatchSetId != other.regexMatchSetId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.waf.model.RegexMatchSetSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A friendly name or description of the RegexMatchSet. You can't change `Name` after you create a `RegexMatchSet`.
         */
        public var name: kotlin.String? = null
        /**
         * The `RegexMatchSetId` for a `RegexMatchSet`. You use `RegexMatchSetId` to get information about a `RegexMatchSet`, update a `RegexMatchSet`, remove a `RegexMatchSet` from a `Rule`, and delete a `RegexMatchSet` from AWS WAF.
         *
         * `RegexMatchSetId` is returned by CreateRegexMatchSet and by ListRegexMatchSets.
         */
        public var regexMatchSetId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.waf.model.RegexMatchSetSummary) : this() {
            this.name = x.name
            this.regexMatchSetId = x.regexMatchSetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.waf.model.RegexMatchSetSummary = RegexMatchSetSummary(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (regexMatchSetId == null) regexMatchSetId = ""
            return this
        }
    }
}
