// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Specifies the type of update to perform to an GeoMatchSet with UpdateGeoMatchSet.
 */
public class GeoMatchSetUpdate private constructor(builder: Builder) {
    /**
     * Specifies whether to insert or delete a country with UpdateGeoMatchSet.
     */
    public val action: aws.sdk.kotlin.services.waf.model.ChangeAction = requireNotNull(builder.action) { "A non-null value must be provided for action" }
    /**
     * The country from which web requests originate that you want AWS WAF to search for.
     */
    public val geoMatchConstraint: aws.sdk.kotlin.services.waf.model.GeoMatchConstraint? = builder.geoMatchConstraint

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.waf.model.GeoMatchSetUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GeoMatchSetUpdate(")
        append("action=$action,")
        append("geoMatchConstraint=$geoMatchConstraint")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action.hashCode()
        result = 31 * result + (geoMatchConstraint?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GeoMatchSetUpdate

        if (action != other.action) return false
        if (geoMatchConstraint != other.geoMatchConstraint) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.waf.model.GeoMatchSetUpdate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether to insert or delete a country with UpdateGeoMatchSet.
         */
        public var action: aws.sdk.kotlin.services.waf.model.ChangeAction? = null
        /**
         * The country from which web requests originate that you want AWS WAF to search for.
         */
        public var geoMatchConstraint: aws.sdk.kotlin.services.waf.model.GeoMatchConstraint? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.waf.model.GeoMatchSetUpdate) : this() {
            this.action = x.action
            this.geoMatchConstraint = x.geoMatchConstraint
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.waf.model.GeoMatchSetUpdate = GeoMatchSetUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.waf.model.GeoMatchConstraint] inside the given [block]
         */
        public fun geoMatchConstraint(block: aws.sdk.kotlin.services.waf.model.GeoMatchConstraint.Builder.() -> kotlin.Unit) {
            this.geoMatchConstraint = aws.sdk.kotlin.services.waf.model.GeoMatchConstraint.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (action == null) action = ChangeAction.SdkUnknown("no value provided")
            return this
        }
    }
}
