// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Contains the identifier and the name of the `GeoMatchSet`.
 */
public class GeoMatchSetSummary private constructor(builder: Builder) {
    /**
     * The `GeoMatchSetId` for an GeoMatchSet. You can use `GeoMatchSetId` in a GetGeoMatchSet request to get detailed information about an GeoMatchSet.
     */
    public val geoMatchSetId: kotlin.String = requireNotNull(builder.geoMatchSetId) { "A non-null value must be provided for geoMatchSetId" }
    /**
     * A friendly name or description of the GeoMatchSet. You can't change the name of an `GeoMatchSet` after you create it.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.waf.model.GeoMatchSetSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GeoMatchSetSummary(")
        append("geoMatchSetId=$geoMatchSetId,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = geoMatchSetId.hashCode()
        result = 31 * result + (name.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GeoMatchSetSummary

        if (geoMatchSetId != other.geoMatchSetId) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.waf.model.GeoMatchSetSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The `GeoMatchSetId` for an GeoMatchSet. You can use `GeoMatchSetId` in a GetGeoMatchSet request to get detailed information about an GeoMatchSet.
         */
        public var geoMatchSetId: kotlin.String? = null
        /**
         * A friendly name or description of the GeoMatchSet. You can't change the name of an `GeoMatchSet` after you create it.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.waf.model.GeoMatchSetSummary) : this() {
            this.geoMatchSetId = x.geoMatchSetId
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.waf.model.GeoMatchSetSummary = GeoMatchSetSummary(this)

        internal fun correctErrors(): Builder {
            if (geoMatchSetId == null) geoMatchSetId = ""
            if (name == null) name = ""
            return this
        }
    }
}
