// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.waf.auth.DefaultWafAuthSchemeProvider
import aws.sdk.kotlin.services.waf.auth.WafAuthSchemeProvider
import aws.sdk.kotlin.services.waf.endpoints.DefaultWafEndpointProvider
import aws.sdk.kotlin.services.waf.endpoints.WafEndpointParameters
import aws.sdk.kotlin.services.waf.endpoints.WafEndpointProvider
import aws.sdk.kotlin.services.waf.model.CreateByteMatchSetRequest
import aws.sdk.kotlin.services.waf.model.CreateByteMatchSetResponse
import aws.sdk.kotlin.services.waf.model.CreateGeoMatchSetRequest
import aws.sdk.kotlin.services.waf.model.CreateGeoMatchSetResponse
import aws.sdk.kotlin.services.waf.model.CreateIpSetRequest
import aws.sdk.kotlin.services.waf.model.CreateIpSetResponse
import aws.sdk.kotlin.services.waf.model.CreateRateBasedRuleRequest
import aws.sdk.kotlin.services.waf.model.CreateRateBasedRuleResponse
import aws.sdk.kotlin.services.waf.model.CreateRegexMatchSetRequest
import aws.sdk.kotlin.services.waf.model.CreateRegexMatchSetResponse
import aws.sdk.kotlin.services.waf.model.CreateRegexPatternSetRequest
import aws.sdk.kotlin.services.waf.model.CreateRegexPatternSetResponse
import aws.sdk.kotlin.services.waf.model.CreateRuleGroupRequest
import aws.sdk.kotlin.services.waf.model.CreateRuleGroupResponse
import aws.sdk.kotlin.services.waf.model.CreateRuleRequest
import aws.sdk.kotlin.services.waf.model.CreateRuleResponse
import aws.sdk.kotlin.services.waf.model.CreateSizeConstraintSetRequest
import aws.sdk.kotlin.services.waf.model.CreateSizeConstraintSetResponse
import aws.sdk.kotlin.services.waf.model.CreateSqlInjectionMatchSetRequest
import aws.sdk.kotlin.services.waf.model.CreateSqlInjectionMatchSetResponse
import aws.sdk.kotlin.services.waf.model.CreateWebAclMigrationStackRequest
import aws.sdk.kotlin.services.waf.model.CreateWebAclMigrationStackResponse
import aws.sdk.kotlin.services.waf.model.CreateWebAclRequest
import aws.sdk.kotlin.services.waf.model.CreateWebAclResponse
import aws.sdk.kotlin.services.waf.model.CreateXssMatchSetRequest
import aws.sdk.kotlin.services.waf.model.CreateXssMatchSetResponse
import aws.sdk.kotlin.services.waf.model.DeleteByteMatchSetRequest
import aws.sdk.kotlin.services.waf.model.DeleteByteMatchSetResponse
import aws.sdk.kotlin.services.waf.model.DeleteGeoMatchSetRequest
import aws.sdk.kotlin.services.waf.model.DeleteGeoMatchSetResponse
import aws.sdk.kotlin.services.waf.model.DeleteIpSetRequest
import aws.sdk.kotlin.services.waf.model.DeleteIpSetResponse
import aws.sdk.kotlin.services.waf.model.DeleteLoggingConfigurationRequest
import aws.sdk.kotlin.services.waf.model.DeleteLoggingConfigurationResponse
import aws.sdk.kotlin.services.waf.model.DeletePermissionPolicyRequest
import aws.sdk.kotlin.services.waf.model.DeletePermissionPolicyResponse
import aws.sdk.kotlin.services.waf.model.DeleteRateBasedRuleRequest
import aws.sdk.kotlin.services.waf.model.DeleteRateBasedRuleResponse
import aws.sdk.kotlin.services.waf.model.DeleteRegexMatchSetRequest
import aws.sdk.kotlin.services.waf.model.DeleteRegexMatchSetResponse
import aws.sdk.kotlin.services.waf.model.DeleteRegexPatternSetRequest
import aws.sdk.kotlin.services.waf.model.DeleteRegexPatternSetResponse
import aws.sdk.kotlin.services.waf.model.DeleteRuleGroupRequest
import aws.sdk.kotlin.services.waf.model.DeleteRuleGroupResponse
import aws.sdk.kotlin.services.waf.model.DeleteRuleRequest
import aws.sdk.kotlin.services.waf.model.DeleteRuleResponse
import aws.sdk.kotlin.services.waf.model.DeleteSizeConstraintSetRequest
import aws.sdk.kotlin.services.waf.model.DeleteSizeConstraintSetResponse
import aws.sdk.kotlin.services.waf.model.DeleteSqlInjectionMatchSetRequest
import aws.sdk.kotlin.services.waf.model.DeleteSqlInjectionMatchSetResponse
import aws.sdk.kotlin.services.waf.model.DeleteWebAclRequest
import aws.sdk.kotlin.services.waf.model.DeleteWebAclResponse
import aws.sdk.kotlin.services.waf.model.DeleteXssMatchSetRequest
import aws.sdk.kotlin.services.waf.model.DeleteXssMatchSetResponse
import aws.sdk.kotlin.services.waf.model.GetByteMatchSetRequest
import aws.sdk.kotlin.services.waf.model.GetByteMatchSetResponse
import aws.sdk.kotlin.services.waf.model.GetChangeTokenRequest
import aws.sdk.kotlin.services.waf.model.GetChangeTokenResponse
import aws.sdk.kotlin.services.waf.model.GetChangeTokenStatusRequest
import aws.sdk.kotlin.services.waf.model.GetChangeTokenStatusResponse
import aws.sdk.kotlin.services.waf.model.GetGeoMatchSetRequest
import aws.sdk.kotlin.services.waf.model.GetGeoMatchSetResponse
import aws.sdk.kotlin.services.waf.model.GetIpSetRequest
import aws.sdk.kotlin.services.waf.model.GetIpSetResponse
import aws.sdk.kotlin.services.waf.model.GetLoggingConfigurationRequest
import aws.sdk.kotlin.services.waf.model.GetLoggingConfigurationResponse
import aws.sdk.kotlin.services.waf.model.GetPermissionPolicyRequest
import aws.sdk.kotlin.services.waf.model.GetPermissionPolicyResponse
import aws.sdk.kotlin.services.waf.model.GetRateBasedRuleManagedKeysRequest
import aws.sdk.kotlin.services.waf.model.GetRateBasedRuleManagedKeysResponse
import aws.sdk.kotlin.services.waf.model.GetRateBasedRuleRequest
import aws.sdk.kotlin.services.waf.model.GetRateBasedRuleResponse
import aws.sdk.kotlin.services.waf.model.GetRegexMatchSetRequest
import aws.sdk.kotlin.services.waf.model.GetRegexMatchSetResponse
import aws.sdk.kotlin.services.waf.model.GetRegexPatternSetRequest
import aws.sdk.kotlin.services.waf.model.GetRegexPatternSetResponse
import aws.sdk.kotlin.services.waf.model.GetRuleGroupRequest
import aws.sdk.kotlin.services.waf.model.GetRuleGroupResponse
import aws.sdk.kotlin.services.waf.model.GetRuleRequest
import aws.sdk.kotlin.services.waf.model.GetRuleResponse
import aws.sdk.kotlin.services.waf.model.GetSampledRequestsRequest
import aws.sdk.kotlin.services.waf.model.GetSampledRequestsResponse
import aws.sdk.kotlin.services.waf.model.GetSizeConstraintSetRequest
import aws.sdk.kotlin.services.waf.model.GetSizeConstraintSetResponse
import aws.sdk.kotlin.services.waf.model.GetSqlInjectionMatchSetRequest
import aws.sdk.kotlin.services.waf.model.GetSqlInjectionMatchSetResponse
import aws.sdk.kotlin.services.waf.model.GetWebAclRequest
import aws.sdk.kotlin.services.waf.model.GetWebAclResponse
import aws.sdk.kotlin.services.waf.model.GetXssMatchSetRequest
import aws.sdk.kotlin.services.waf.model.GetXssMatchSetResponse
import aws.sdk.kotlin.services.waf.model.ListActivatedRulesInRuleGroupRequest
import aws.sdk.kotlin.services.waf.model.ListActivatedRulesInRuleGroupResponse
import aws.sdk.kotlin.services.waf.model.ListByteMatchSetsRequest
import aws.sdk.kotlin.services.waf.model.ListByteMatchSetsResponse
import aws.sdk.kotlin.services.waf.model.ListGeoMatchSetsRequest
import aws.sdk.kotlin.services.waf.model.ListGeoMatchSetsResponse
import aws.sdk.kotlin.services.waf.model.ListIpSetsRequest
import aws.sdk.kotlin.services.waf.model.ListIpSetsResponse
import aws.sdk.kotlin.services.waf.model.ListLoggingConfigurationsRequest
import aws.sdk.kotlin.services.waf.model.ListLoggingConfigurationsResponse
import aws.sdk.kotlin.services.waf.model.ListRateBasedRulesRequest
import aws.sdk.kotlin.services.waf.model.ListRateBasedRulesResponse
import aws.sdk.kotlin.services.waf.model.ListRegexMatchSetsRequest
import aws.sdk.kotlin.services.waf.model.ListRegexMatchSetsResponse
import aws.sdk.kotlin.services.waf.model.ListRegexPatternSetsRequest
import aws.sdk.kotlin.services.waf.model.ListRegexPatternSetsResponse
import aws.sdk.kotlin.services.waf.model.ListRuleGroupsRequest
import aws.sdk.kotlin.services.waf.model.ListRuleGroupsResponse
import aws.sdk.kotlin.services.waf.model.ListRulesRequest
import aws.sdk.kotlin.services.waf.model.ListRulesResponse
import aws.sdk.kotlin.services.waf.model.ListSizeConstraintSetsRequest
import aws.sdk.kotlin.services.waf.model.ListSizeConstraintSetsResponse
import aws.sdk.kotlin.services.waf.model.ListSqlInjectionMatchSetsRequest
import aws.sdk.kotlin.services.waf.model.ListSqlInjectionMatchSetsResponse
import aws.sdk.kotlin.services.waf.model.ListSubscribedRuleGroupsRequest
import aws.sdk.kotlin.services.waf.model.ListSubscribedRuleGroupsResponse
import aws.sdk.kotlin.services.waf.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.waf.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.waf.model.ListWebAclsRequest
import aws.sdk.kotlin.services.waf.model.ListWebAclsResponse
import aws.sdk.kotlin.services.waf.model.ListXssMatchSetsRequest
import aws.sdk.kotlin.services.waf.model.ListXssMatchSetsResponse
import aws.sdk.kotlin.services.waf.model.PutLoggingConfigurationRequest
import aws.sdk.kotlin.services.waf.model.PutLoggingConfigurationResponse
import aws.sdk.kotlin.services.waf.model.PutPermissionPolicyRequest
import aws.sdk.kotlin.services.waf.model.PutPermissionPolicyResponse
import aws.sdk.kotlin.services.waf.model.TagResourceRequest
import aws.sdk.kotlin.services.waf.model.TagResourceResponse
import aws.sdk.kotlin.services.waf.model.UntagResourceRequest
import aws.sdk.kotlin.services.waf.model.UntagResourceResponse
import aws.sdk.kotlin.services.waf.model.UpdateByteMatchSetRequest
import aws.sdk.kotlin.services.waf.model.UpdateByteMatchSetResponse
import aws.sdk.kotlin.services.waf.model.UpdateGeoMatchSetRequest
import aws.sdk.kotlin.services.waf.model.UpdateGeoMatchSetResponse
import aws.sdk.kotlin.services.waf.model.UpdateIpSetRequest
import aws.sdk.kotlin.services.waf.model.UpdateIpSetResponse
import aws.sdk.kotlin.services.waf.model.UpdateRateBasedRuleRequest
import aws.sdk.kotlin.services.waf.model.UpdateRateBasedRuleResponse
import aws.sdk.kotlin.services.waf.model.UpdateRegexMatchSetRequest
import aws.sdk.kotlin.services.waf.model.UpdateRegexMatchSetResponse
import aws.sdk.kotlin.services.waf.model.UpdateRegexPatternSetRequest
import aws.sdk.kotlin.services.waf.model.UpdateRegexPatternSetResponse
import aws.sdk.kotlin.services.waf.model.UpdateRuleGroupRequest
import aws.sdk.kotlin.services.waf.model.UpdateRuleGroupResponse
import aws.sdk.kotlin.services.waf.model.UpdateRuleRequest
import aws.sdk.kotlin.services.waf.model.UpdateRuleResponse
import aws.sdk.kotlin.services.waf.model.UpdateSizeConstraintSetRequest
import aws.sdk.kotlin.services.waf.model.UpdateSizeConstraintSetResponse
import aws.sdk.kotlin.services.waf.model.UpdateSqlInjectionMatchSetRequest
import aws.sdk.kotlin.services.waf.model.UpdateSqlInjectionMatchSetResponse
import aws.sdk.kotlin.services.waf.model.UpdateWebAclRequest
import aws.sdk.kotlin.services.waf.model.UpdateWebAclResponse
import aws.sdk.kotlin.services.waf.model.UpdateXssMatchSetRequest
import aws.sdk.kotlin.services.waf.model.UpdateXssMatchSetResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "WAF"
public const val SdkVersion: String = "1.2.15"
public const val ServiceApiVersion: String = "2015-08-24"

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * This is the *AWS WAF Classic API Reference* for using AWS WAF Classic with Amazon CloudFront. The AWS WAF Classic actions and data types listed in the reference are available for protecting Amazon CloudFront distributions. You can use these actions and data types via the endpoint *waf.amazonaws.com*. This guide is for developers who need detailed information about the AWS WAF Classic API actions, data types, and errors. For detailed information about AWS WAF Classic features and an overview of how to use the AWS WAF Classic API, see the [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 */
public interface WafClient : SdkClient {
    /**
     * WafClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, WafClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Waf",
                "WAF",
                "waf",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, WafClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): WafClient = DefaultWafClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: WafEndpointProvider = builder.endpointProvider ?: DefaultWafEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: WafAuthSchemeProvider = builder.authSchemeProvider ?: DefaultWafAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "WAF"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: WafEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: WafAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Creates a `ByteMatchSet`. You then use UpdateByteMatchSet to identify the part of a web request that you want AWS WAF to inspect, such as the values of the `User-Agent` header or the query string. For example, you can create a `ByteMatchSet` that matches any requests with `User-Agent` headers that contain the string `BadBot`. You can then configure AWS WAF to reject those requests.
     *
     * To create and configure a `ByteMatchSet`, perform the following steps:
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `CreateByteMatchSet` request.
     * + Submit a `CreateByteMatchSet` request.
     * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an `UpdateByteMatchSet` request.
     * + Submit an UpdateByteMatchSet request to specify the part of the request that you want AWS WAF to inspect (for example, the header or the URI) and the value that you want AWS WAF to watch for.
     *
     * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
     */
    public suspend fun createByteMatchSet(input: CreateByteMatchSetRequest): CreateByteMatchSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Creates an GeoMatchSet, which you use to specify which web requests you want to allow or block based on the country that the requests originate from. For example, if you're receiving a lot of requests from one or more countries and you want to block the requests, you can create an `GeoMatchSet` that contains those countries and then configure AWS WAF to block the requests.
     *
     * To create and configure a `GeoMatchSet`, perform the following steps:
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `CreateGeoMatchSet` request.
     * + Submit a `CreateGeoMatchSet` request.
     * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an UpdateGeoMatchSet request.
     * + Submit an `UpdateGeoMatchSetSet` request to specify the countries that you want AWS WAF to watch for.
     *
     * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
     */
    public suspend fun createGeoMatchSet(input: CreateGeoMatchSetRequest): CreateGeoMatchSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Creates an IPSet, which you use to specify which web requests that you want to allow or block based on the IP addresses that the requests originate from. For example, if you're receiving a lot of requests from one or more individual IP addresses or one or more ranges of IP addresses and you want to block the requests, you can create an `IPSet` that contains those IP addresses and then configure AWS WAF to block the requests.
     *
     * To create and configure an `IPSet`, perform the following steps:
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `CreateIPSet` request.
     * + Submit a `CreateIPSet` request.
     * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an UpdateIPSet request.
     * + Submit an `UpdateIPSet` request to specify the IP addresses that you want AWS WAF to watch for.
     *
     * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
     *
     * @sample aws.sdk.kotlin.services.waf.samples.CreateIPSet.sample
     */
    public suspend fun createIpSet(input: CreateIpSetRequest): CreateIpSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Creates a RateBasedRule. The `RateBasedRule` contains a `RateLimit`, which specifies the maximum number of requests that AWS WAF allows from a specified IP address in a five-minute period. The `RateBasedRule` also contains the `IPSet` objects, `ByteMatchSet` objects, and other predicates that identify the requests that you want to count or block if these requests exceed the `RateLimit`.
     *
     * If you add more than one predicate to a `RateBasedRule`, a request not only must exceed the `RateLimit`, but it also must match all the conditions to be counted or blocked. For example, suppose you add the following to a `RateBasedRule`:
     * + An `IPSet` that matches the IP address `192.0.2.44/32`
     * + A `ByteMatchSet` that matches `BadBot` in the `User-Agent` header
     *
     * Further, you specify a `RateLimit` of 1,000.
     *
     * You then add the `RateBasedRule` to a `WebACL` and specify that you want to block requests that meet the conditions in the rule. For a request to be blocked, it must come from the IP address 192.0.2.44 *and* the `User-Agent` header in the request must contain the value `BadBot`. Further, requests that match these two conditions must be received at a rate of more than 1,000 requests every five minutes. If both conditions are met and the rate is exceeded, AWS WAF blocks the requests. If the rate drops below 1,000 for a five-minute period, AWS WAF no longer blocks the requests.
     *
     * As a second example, suppose you want to limit requests to a particular page on your site. To do this, you could add the following to a `RateBasedRule`:
     * + A `ByteMatchSet` with `FieldToMatch` of `URI`
     * + A `PositionalConstraint` of `STARTS_WITH`
     * + A `TargetString` of `login`
     *
     * Further, you specify a `RateLimit` of 1,000.
     *
     * By adding this `RateBasedRule` to a `WebACL`, you could limit requests to your login page without affecting the rest of your site.
     *
     * To create and configure a `RateBasedRule`, perform the following steps:
     * + Create and update the predicates that you want to include in the rule. For more information, see CreateByteMatchSet, CreateIPSet, and CreateSqlInjectionMatchSet.
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `CreateRule` request.
     * + Submit a `CreateRateBasedRule` request.
     * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an UpdateRule request.
     * + Submit an `UpdateRateBasedRule` request to specify the predicates that you want to include in the rule.
     * + Create and update a `WebACL` that contains the `RateBasedRule`. For more information, see CreateWebACL.
     *
     * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
     */
    public suspend fun createRateBasedRule(input: CreateRateBasedRuleRequest): CreateRateBasedRuleResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Creates a RegexMatchSet. You then use UpdateRegexMatchSet to identify the part of a web request that you want AWS WAF to inspect, such as the values of the `User-Agent` header or the query string. For example, you can create a `RegexMatchSet` that contains a `RegexMatchTuple` that looks for any requests with `User-Agent` headers that match a `RegexPatternSet` with pattern `B[a@]dB[o0]t`. You can then configure AWS WAF to reject those requests.
     *
     * To create and configure a `RegexMatchSet`, perform the following steps:
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `CreateRegexMatchSet` request.
     * + Submit a `CreateRegexMatchSet` request.
     * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an `UpdateRegexMatchSet` request.
     * + Submit an UpdateRegexMatchSet request to specify the part of the request that you want AWS WAF to inspect (for example, the header or the URI) and the value, using a `RegexPatternSet`, that you want AWS WAF to watch for.
     *
     * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
     */
    public suspend fun createRegexMatchSet(input: CreateRegexMatchSetRequest): CreateRegexMatchSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Creates a `RegexPatternSet`. You then use UpdateRegexPatternSet to specify the regular expression (regex) pattern that you want AWS WAF to search for, such as `B[a@]dB[o0]t`. You can then configure AWS WAF to reject those requests.
     *
     * To create and configure a `RegexPatternSet`, perform the following steps:
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `CreateRegexPatternSet` request.
     * + Submit a `CreateRegexPatternSet` request.
     * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an `UpdateRegexPatternSet` request.
     * + Submit an UpdateRegexPatternSet request to specify the string that you want AWS WAF to watch for.
     *
     * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
     */
    public suspend fun createRegexPatternSet(input: CreateRegexPatternSetRequest): CreateRegexPatternSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Creates a `Rule`, which contains the `IPSet` objects, `ByteMatchSet` objects, and other predicates that identify the requests that you want to block. If you add more than one predicate to a `Rule`, a request must match all of the specifications to be allowed or blocked. For example, suppose that you add the following to a `Rule`:
     * + An `IPSet` that matches the IP address `192.0.2.44/32`
     * + A `ByteMatchSet` that matches `BadBot` in the `User-Agent` header
     *
     * You then add the `Rule` to a `WebACL` and specify that you want to blocks requests that satisfy the `Rule`. For a request to be blocked, it must come from the IP address 192.0.2.44 *and* the `User-Agent` header in the request must contain the value `BadBot`.
     *
     * To create and configure a `Rule`, perform the following steps:
     * + Create and update the predicates that you want to include in the `Rule`. For more information, see CreateByteMatchSet, CreateIPSet, and CreateSqlInjectionMatchSet.
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `CreateRule` request.
     * + Submit a `CreateRule` request.
     * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an UpdateRule request.
     * + Submit an `UpdateRule` request to specify the predicates that you want to include in the `Rule`.
     * + Create and update a `WebACL` that contains the `Rule`. For more information, see CreateWebACL.
     *
     * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
     *
     * @sample aws.sdk.kotlin.services.waf.samples.CreateRule.sample
     */
    public suspend fun createRule(input: CreateRuleRequest): CreateRuleResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Creates a `RuleGroup`. A rule group is a collection of predefined rules that you add to a web ACL. You use UpdateRuleGroup to add rules to the rule group.
     *
     * Rule groups are subject to the following limits:
     * + Three rule groups per account. You can request an increase to this limit by contacting customer support.
     * + One rule group per web ACL.
     * + Ten rules per rule group.
     *
     * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
     */
    public suspend fun createRuleGroup(input: CreateRuleGroupRequest): CreateRuleGroupResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Creates a `SizeConstraintSet`. You then use UpdateSizeConstraintSet to identify the part of a web request that you want AWS WAF to check for length, such as the length of the `User-Agent` header or the length of the query string. For example, you can create a `SizeConstraintSet` that matches any requests that have a query string that is longer than 100 bytes. You can then configure AWS WAF to reject those requests.
     *
     * To create and configure a `SizeConstraintSet`, perform the following steps:
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `CreateSizeConstraintSet` request.
     * + Submit a `CreateSizeConstraintSet` request.
     * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an `UpdateSizeConstraintSet` request.
     * + Submit an UpdateSizeConstraintSet request to specify the part of the request that you want AWS WAF to inspect (for example, the header or the URI) and the value that you want AWS WAF to watch for.
     *
     * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
     *
     * @sample aws.sdk.kotlin.services.waf.samples.CreateSizeConstraintSet.sample
     */
    public suspend fun createSizeConstraintSet(input: CreateSizeConstraintSetRequest): CreateSizeConstraintSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Creates a SqlInjectionMatchSet, which you use to allow, block, or count requests that contain snippets of SQL code in a specified part of web requests. AWS WAF searches for character sequences that are likely to be malicious strings.
     *
     * To create and configure a `SqlInjectionMatchSet`, perform the following steps:
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `CreateSqlInjectionMatchSet` request.
     * + Submit a `CreateSqlInjectionMatchSet` request.
     * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an UpdateSqlInjectionMatchSet request.
     * + Submit an UpdateSqlInjectionMatchSet request to specify the parts of web requests in which you want to allow, block, or count malicious SQL code.
     *
     * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
     *
     * @sample aws.sdk.kotlin.services.waf.samples.CreateSqlInjectionMatchSet.sample
     */
    public suspend fun createSqlInjectionMatchSet(input: CreateSqlInjectionMatchSetRequest): CreateSqlInjectionMatchSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Creates a `WebACL`, which contains the `Rules` that identify the CloudFront web requests that you want to allow, block, or count. AWS WAF evaluates `Rules` in order based on the value of `Priority` for each `Rule`.
     *
     * You also specify a default action, either `ALLOW` or `BLOCK`. If a web request doesn't match any of the `Rules` in a `WebACL`, AWS WAF responds to the request with the default action.
     *
     * To create and configure a `WebACL`, perform the following steps:
     * + Create and update the `ByteMatchSet` objects and other predicates that you want to include in `Rules`. For more information, see CreateByteMatchSet, UpdateByteMatchSet, CreateIPSet, UpdateIPSet, CreateSqlInjectionMatchSet, and UpdateSqlInjectionMatchSet.
     * + Create and update the `Rules` that you want to include in the `WebACL`. For more information, see CreateRule and UpdateRule.
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `CreateWebACL` request.
     * + Submit a `CreateWebACL` request.
     * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an UpdateWebACL request.
     * + Submit an UpdateWebACL request to specify the `Rules` that you want to include in the `WebACL`, to specify the default action, and to associate the `WebACL` with a CloudFront distribution.
     *
     * For more information about how to use the AWS WAF API, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
     *
     * @sample aws.sdk.kotlin.services.waf.samples.CreateWebACL.sample
     */
    public suspend fun createWebAcl(input: CreateWebAclRequest): CreateWebAclResponse

    /**
     * Creates an AWS CloudFormation WAFV2 template for the specified web ACL in the specified Amazon S3 bucket. Then, in CloudFormation, you create a stack from the template, to create the web ACL and its resources in AWS WAFV2. Use this to migrate your AWS WAF Classic web ACL to the latest version of AWS WAF.
     *
     * This is part of a larger migration procedure for web ACLs from AWS WAF Classic to the latest version of AWS WAF. For the full procedure, including caveats and manual steps to complete the migration and switch over to the new web ACL, see [Migrating your AWS WAF Classic resources to AWS WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-migrating-from-classic.html) in the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
     */
    public suspend fun createWebAclMigrationStack(input: CreateWebAclMigrationStackRequest): CreateWebAclMigrationStackResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Creates an XssMatchSet, which you use to allow, block, or count requests that contain cross-site scripting attacks in the specified part of web requests. AWS WAF searches for character sequences that are likely to be malicious strings.
     *
     * To create and configure an `XssMatchSet`, perform the following steps:
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `CreateXssMatchSet` request.
     * + Submit a `CreateXssMatchSet` request.
     * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an UpdateXssMatchSet request.
     * + Submit an UpdateXssMatchSet request to specify the parts of web requests in which you want to allow, block, or count cross-site scripting attacks.
     *
     * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
     *
     * @sample aws.sdk.kotlin.services.waf.samples.CreateXssMatchSet.sample
     */
    public suspend fun createXssMatchSet(input: CreateXssMatchSetRequest): CreateXssMatchSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Permanently deletes a ByteMatchSet. You can't delete a `ByteMatchSet` if it's still used in any `Rules` or if it still includes any ByteMatchTuple objects (any filters).
     *
     * If you just want to remove a `ByteMatchSet` from a `Rule`, use UpdateRule.
     *
     * To permanently delete a `ByteMatchSet`, perform the following steps:
     * + Update the `ByteMatchSet` to remove filters, if any. For more information, see UpdateByteMatchSet.
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `DeleteByteMatchSet` request.
     * + Submit a `DeleteByteMatchSet` request.
     *
     * @sample aws.sdk.kotlin.services.waf.samples.DeleteByteMatchSet.sample
     */
    public suspend fun deleteByteMatchSet(input: DeleteByteMatchSetRequest): DeleteByteMatchSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Permanently deletes a GeoMatchSet. You can't delete a `GeoMatchSet` if it's still used in any `Rules` or if it still includes any countries.
     *
     * If you just want to remove a `GeoMatchSet` from a `Rule`, use UpdateRule.
     *
     * To permanently delete a `GeoMatchSet` from AWS WAF, perform the following steps:
     * + Update the `GeoMatchSet` to remove any countries. For more information, see UpdateGeoMatchSet.
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `DeleteGeoMatchSet` request.
     * + Submit a `DeleteGeoMatchSet` request.
     */
    public suspend fun deleteGeoMatchSet(input: DeleteGeoMatchSetRequest): DeleteGeoMatchSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Permanently deletes an IPSet. You can't delete an `IPSet` if it's still used in any `Rules` or if it still includes any IP addresses.
     *
     * If you just want to remove an `IPSet` from a `Rule`, use UpdateRule.
     *
     * To permanently delete an `IPSet` from AWS WAF, perform the following steps:
     * + Update the `IPSet` to remove IP address ranges, if any. For more information, see UpdateIPSet.
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `DeleteIPSet` request.
     * + Submit a `DeleteIPSet` request.
     *
     * @sample aws.sdk.kotlin.services.waf.samples.DeleteIPSet.sample
     */
    public suspend fun deleteIpSet(input: DeleteIpSetRequest): DeleteIpSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Permanently deletes the LoggingConfiguration from the specified web ACL.
     */
    public suspend fun deleteLoggingConfiguration(input: DeleteLoggingConfigurationRequest): DeleteLoggingConfigurationResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Permanently deletes an IAM policy from the specified RuleGroup.
     *
     * The user making the request must be the owner of the RuleGroup.
     */
    public suspend fun deletePermissionPolicy(input: DeletePermissionPolicyRequest): DeletePermissionPolicyResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Permanently deletes a RateBasedRule. You can't delete a rule if it's still used in any `WebACL` objects or if it still includes any predicates, such as `ByteMatchSet` objects.
     *
     * If you just want to remove a rule from a `WebACL`, use UpdateWebACL.
     *
     * To permanently delete a `RateBasedRule` from AWS WAF, perform the following steps:
     * + Update the `RateBasedRule` to remove predicates, if any. For more information, see UpdateRateBasedRule.
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `DeleteRateBasedRule` request.
     * + Submit a `DeleteRateBasedRule` request.
     */
    public suspend fun deleteRateBasedRule(input: DeleteRateBasedRuleRequest): DeleteRateBasedRuleResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Permanently deletes a RegexMatchSet. You can't delete a `RegexMatchSet` if it's still used in any `Rules` or if it still includes any `RegexMatchTuples` objects (any filters).
     *
     * If you just want to remove a `RegexMatchSet` from a `Rule`, use UpdateRule.
     *
     * To permanently delete a `RegexMatchSet`, perform the following steps:
     * + Update the `RegexMatchSet` to remove filters, if any. For more information, see UpdateRegexMatchSet.
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `DeleteRegexMatchSet` request.
     * + Submit a `DeleteRegexMatchSet` request.
     */
    public suspend fun deleteRegexMatchSet(input: DeleteRegexMatchSetRequest): DeleteRegexMatchSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Permanently deletes a RegexPatternSet. You can't delete a `RegexPatternSet` if it's still used in any `RegexMatchSet` or if the `RegexPatternSet` is not empty.
     */
    public suspend fun deleteRegexPatternSet(input: DeleteRegexPatternSetRequest): DeleteRegexPatternSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Permanently deletes a Rule. You can't delete a `Rule` if it's still used in any `WebACL` objects or if it still includes any predicates, such as `ByteMatchSet` objects.
     *
     * If you just want to remove a `Rule` from a `WebACL`, use UpdateWebACL.
     *
     * To permanently delete a `Rule` from AWS WAF, perform the following steps:
     * + Update the `Rule` to remove predicates, if any. For more information, see UpdateRule.
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `DeleteRule` request.
     * + Submit a `DeleteRule` request.
     *
     * @sample aws.sdk.kotlin.services.waf.samples.DeleteRule.sample
     */
    public suspend fun deleteRule(input: DeleteRuleRequest): DeleteRuleResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Permanently deletes a RuleGroup. You can't delete a `RuleGroup` if it's still used in any `WebACL` objects or if it still includes any rules.
     *
     * If you just want to remove a `RuleGroup` from a `WebACL`, use UpdateWebACL.
     *
     * To permanently delete a `RuleGroup` from AWS WAF, perform the following steps:
     * + Update the `RuleGroup` to remove rules, if any. For more information, see UpdateRuleGroup.
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `DeleteRuleGroup` request.
     * + Submit a `DeleteRuleGroup` request.
     */
    public suspend fun deleteRuleGroup(input: DeleteRuleGroupRequest): DeleteRuleGroupResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Permanently deletes a SizeConstraintSet. You can't delete a `SizeConstraintSet` if it's still used in any `Rules` or if it still includes any SizeConstraint objects (any filters).
     *
     * If you just want to remove a `SizeConstraintSet` from a `Rule`, use UpdateRule.
     *
     * To permanently delete a `SizeConstraintSet`, perform the following steps:
     * + Update the `SizeConstraintSet` to remove filters, if any. For more information, see UpdateSizeConstraintSet.
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `DeleteSizeConstraintSet` request.
     * + Submit a `DeleteSizeConstraintSet` request.
     *
     * @sample aws.sdk.kotlin.services.waf.samples.DeleteSizeConstraintSet.sample
     */
    public suspend fun deleteSizeConstraintSet(input: DeleteSizeConstraintSetRequest): DeleteSizeConstraintSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Permanently deletes a SqlInjectionMatchSet. You can't delete a `SqlInjectionMatchSet` if it's still used in any `Rules` or if it still contains any SqlInjectionMatchTuple objects.
     *
     * If you just want to remove a `SqlInjectionMatchSet` from a `Rule`, use UpdateRule.
     *
     * To permanently delete a `SqlInjectionMatchSet` from AWS WAF, perform the following steps:
     * + Update the `SqlInjectionMatchSet` to remove filters, if any. For more information, see UpdateSqlInjectionMatchSet.
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `DeleteSqlInjectionMatchSet` request.
     * + Submit a `DeleteSqlInjectionMatchSet` request.
     *
     * @sample aws.sdk.kotlin.services.waf.samples.DeleteSqlInjectionMatchSet.sample
     */
    public suspend fun deleteSqlInjectionMatchSet(input: DeleteSqlInjectionMatchSetRequest): DeleteSqlInjectionMatchSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Permanently deletes a WebACL. You can't delete a `WebACL` if it still contains any `Rules`.
     *
     * To delete a `WebACL`, perform the following steps:
     * + Update the `WebACL` to remove `Rules`, if any. For more information, see UpdateWebACL.
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `DeleteWebACL` request.
     * + Submit a `DeleteWebACL` request.
     *
     * @sample aws.sdk.kotlin.services.waf.samples.DeleteWebACL.sample
     */
    public suspend fun deleteWebAcl(input: DeleteWebAclRequest): DeleteWebAclResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Permanently deletes an XssMatchSet. You can't delete an `XssMatchSet` if it's still used in any `Rules` or if it still contains any XssMatchTuple objects.
     *
     * If you just want to remove an `XssMatchSet` from a `Rule`, use UpdateRule.
     *
     * To permanently delete an `XssMatchSet` from AWS WAF, perform the following steps:
     * + Update the `XssMatchSet` to remove filters, if any. For more information, see UpdateXssMatchSet.
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `DeleteXssMatchSet` request.
     * + Submit a `DeleteXssMatchSet` request.
     *
     * @sample aws.sdk.kotlin.services.waf.samples.DeleteXssMatchSet.sample
     */
    public suspend fun deleteXssMatchSet(input: DeleteXssMatchSetRequest): DeleteXssMatchSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns the ByteMatchSet specified by `ByteMatchSetId`.
     *
     * @sample aws.sdk.kotlin.services.waf.samples.GetByteMatchSet.sample
     */
    public suspend fun getByteMatchSet(input: GetByteMatchSetRequest): GetByteMatchSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * When you want to create, update, or delete AWS WAF objects, get a change token and include the change token in the create, update, or delete request. Change tokens ensure that your application doesn't submit conflicting requests to AWS WAF.
     *
     * Each create, update, or delete request must use a unique change token. If your application submits a `GetChangeToken` request and then submits a second `GetChangeToken` request before submitting a create, update, or delete request, the second `GetChangeToken` request returns the same value as the first `GetChangeToken` request.
     *
     * When you use a change token in a create, update, or delete request, the status of the change token changes to `PENDING`, which indicates that AWS WAF is propagating the change to all AWS WAF servers. Use `GetChangeTokenStatus` to determine the status of your change token.
     *
     * @sample aws.sdk.kotlin.services.waf.samples.GetChangeToken.sample
     */
    public suspend fun getChangeToken(input: GetChangeTokenRequest = GetChangeTokenRequest { }): GetChangeTokenResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns the status of a `ChangeToken` that you got by calling GetChangeToken. `ChangeTokenStatus` is one of the following values:
     * + `PROVISIONED`: You requested the change token by calling `GetChangeToken`, but you haven't used it yet in a call to create, update, or delete an AWS WAF object.
     * + `PENDING`: AWS WAF is propagating the create, update, or delete request to all AWS WAF servers.
     * + `INSYNC`: Propagation is complete.
     *
     * @sample aws.sdk.kotlin.services.waf.samples.GetChangeTokenStatus.sample
     */
    public suspend fun getChangeTokenStatus(input: GetChangeTokenStatusRequest): GetChangeTokenStatusResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns the GeoMatchSet that is specified by `GeoMatchSetId`.
     */
    public suspend fun getGeoMatchSet(input: GetGeoMatchSetRequest): GetGeoMatchSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns the IPSet that is specified by `IPSetId`.
     *
     * @sample aws.sdk.kotlin.services.waf.samples.GetIPSet.sample
     */
    public suspend fun getIpSet(input: GetIpSetRequest): GetIpSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns the LoggingConfiguration for the specified web ACL.
     */
    public suspend fun getLoggingConfiguration(input: GetLoggingConfigurationRequest): GetLoggingConfigurationResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns the IAM policy attached to the RuleGroup.
     */
    public suspend fun getPermissionPolicy(input: GetPermissionPolicyRequest): GetPermissionPolicyResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns the RateBasedRule that is specified by the `RuleId` that you included in the `GetRateBasedRule` request.
     */
    public suspend fun getRateBasedRule(input: GetRateBasedRuleRequest): GetRateBasedRuleResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns an array of IP addresses currently being blocked by the RateBasedRule that is specified by the `RuleId`. The maximum number of managed keys that will be blocked is 10,000. If more than 10,000 addresses exceed the rate limit, the 10,000 addresses with the highest rates will be blocked.
     */
    public suspend fun getRateBasedRuleManagedKeys(input: GetRateBasedRuleManagedKeysRequest): GetRateBasedRuleManagedKeysResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns the RegexMatchSet specified by `RegexMatchSetId`.
     */
    public suspend fun getRegexMatchSet(input: GetRegexMatchSetRequest): GetRegexMatchSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns the RegexPatternSet specified by `RegexPatternSetId`.
     */
    public suspend fun getRegexPatternSet(input: GetRegexPatternSetRequest): GetRegexPatternSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns the Rule that is specified by the `RuleId` that you included in the `GetRule` request.
     *
     * @sample aws.sdk.kotlin.services.waf.samples.GetRule.sample
     */
    public suspend fun getRule(input: GetRuleRequest): GetRuleResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns the RuleGroup that is specified by the `RuleGroupId` that you included in the `GetRuleGroup` request.
     *
     * To view the rules in a rule group, use ListActivatedRulesInRuleGroup.
     */
    public suspend fun getRuleGroup(input: GetRuleGroupRequest): GetRuleGroupResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Gets detailed information about a specified number of requests--a sample--that AWS WAF randomly selects from among the first 5,000 requests that your AWS resource received during a time range that you choose. You can specify a sample size of up to 500 requests, and you can specify any time range in the previous three hours.
     *
     * `GetSampledRequests` returns a time range, which is usually the time range that you specified. However, if your resource (such as a CloudFront distribution) received 5,000 requests before the specified time range elapsed, `GetSampledRequests` returns an updated time range. This new time range indicates the actual period during which AWS WAF selected the requests in the sample.
     */
    public suspend fun getSampledRequests(input: GetSampledRequestsRequest): GetSampledRequestsResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns the SizeConstraintSet specified by `SizeConstraintSetId`.
     *
     * @sample aws.sdk.kotlin.services.waf.samples.GetSizeConstraintSet.sample
     */
    public suspend fun getSizeConstraintSet(input: GetSizeConstraintSetRequest): GetSizeConstraintSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns the SqlInjectionMatchSet that is specified by `SqlInjectionMatchSetId`.
     *
     * @sample aws.sdk.kotlin.services.waf.samples.GetSqlInjectionMatchSet.sample
     */
    public suspend fun getSqlInjectionMatchSet(input: GetSqlInjectionMatchSetRequest): GetSqlInjectionMatchSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns the WebACL that is specified by `WebACLId`.
     *
     * @sample aws.sdk.kotlin.services.waf.samples.GetWebACL.sample
     */
    public suspend fun getWebAcl(input: GetWebAclRequest): GetWebAclResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns the XssMatchSet that is specified by `XssMatchSetId`.
     *
     * @sample aws.sdk.kotlin.services.waf.samples.GetXssMatchSet.sample
     */
    public suspend fun getXssMatchSet(input: GetXssMatchSetRequest): GetXssMatchSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns an array of ActivatedRule objects.
     */
    public suspend fun listActivatedRulesInRuleGroup(input: ListActivatedRulesInRuleGroupRequest = ListActivatedRulesInRuleGroupRequest { }): ListActivatedRulesInRuleGroupResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns an array of ByteMatchSetSummary objects.
     */
    public suspend fun listByteMatchSets(input: ListByteMatchSetsRequest = ListByteMatchSetsRequest { }): ListByteMatchSetsResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns an array of GeoMatchSetSummary objects in the response.
     */
    public suspend fun listGeoMatchSets(input: ListGeoMatchSetsRequest = ListGeoMatchSetsRequest { }): ListGeoMatchSetsResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns an array of IPSetSummary objects in the response.
     *
     * @sample aws.sdk.kotlin.services.waf.samples.ListIPSets.sample
     */
    public suspend fun listIpSets(input: ListIpSetsRequest = ListIpSetsRequest { }): ListIpSetsResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns an array of LoggingConfiguration objects.
     */
    public suspend fun listLoggingConfigurations(input: ListLoggingConfigurationsRequest = ListLoggingConfigurationsRequest { }): ListLoggingConfigurationsResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns an array of RuleSummary objects.
     */
    public suspend fun listRateBasedRules(input: ListRateBasedRulesRequest = ListRateBasedRulesRequest { }): ListRateBasedRulesResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns an array of RegexMatchSetSummary objects.
     */
    public suspend fun listRegexMatchSets(input: ListRegexMatchSetsRequest = ListRegexMatchSetsRequest { }): ListRegexMatchSetsResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns an array of RegexPatternSetSummary objects.
     */
    public suspend fun listRegexPatternSets(input: ListRegexPatternSetsRequest = ListRegexPatternSetsRequest { }): ListRegexPatternSetsResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns an array of RuleGroup objects.
     */
    public suspend fun listRuleGroups(input: ListRuleGroupsRequest = ListRuleGroupsRequest { }): ListRuleGroupsResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns an array of RuleSummary objects.
     *
     * @sample aws.sdk.kotlin.services.waf.samples.ListRules.sample
     */
    public suspend fun listRules(input: ListRulesRequest = ListRulesRequest { }): ListRulesResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns an array of SizeConstraintSetSummary objects.
     *
     * @sample aws.sdk.kotlin.services.waf.samples.ListSizeConstraintSets.sample
     */
    public suspend fun listSizeConstraintSets(input: ListSizeConstraintSetsRequest = ListSizeConstraintSetsRequest { }): ListSizeConstraintSetsResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns an array of SqlInjectionMatchSet objects.
     *
     * @sample aws.sdk.kotlin.services.waf.samples.ListSqlInjectionMatchSets.sample
     */
    public suspend fun listSqlInjectionMatchSets(input: ListSqlInjectionMatchSetsRequest = ListSqlInjectionMatchSetsRequest { }): ListSqlInjectionMatchSetsResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns an array of RuleGroup objects that you are subscribed to.
     */
    public suspend fun listSubscribedRuleGroups(input: ListSubscribedRuleGroupsRequest = ListSubscribedRuleGroupsRequest { }): ListSubscribedRuleGroupsResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Retrieves the tags associated with the specified AWS resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each AWS resource, up to 50 tags for a resource.
     *
     * Tagging is only available through the API, SDKs, and CLI. You can't manage or view tags through the AWS WAF Classic console. You can tag the AWS resources that you manage through AWS WAF Classic: web ACLs, rule groups, and rules.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns an array of WebACLSummary objects in the response.
     *
     * @sample aws.sdk.kotlin.services.waf.samples.ListWebACLs.sample
     */
    public suspend fun listWebAcls(input: ListWebAclsRequest = ListWebAclsRequest { }): ListWebAclsResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Returns an array of XssMatchSet objects.
     *
     * @sample aws.sdk.kotlin.services.waf.samples.ListXssMatchSets.sample
     */
    public suspend fun listXssMatchSets(input: ListXssMatchSetsRequest = ListXssMatchSetsRequest { }): ListXssMatchSetsResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Associates a LoggingConfiguration with a specified web ACL.
     *
     * You can access information about all traffic that AWS WAF inspects using the following steps:
     * + Create an Amazon Kinesis Data Firehose. Create the data firehose with a PUT source and in the region that you are operating. However, if you are capturing logs for Amazon CloudFront, always create the firehose in US East (N. Virginia). Do not create the data firehose using a `Kinesis stream` as your source.
     * + Associate that firehose to your web ACL using a `PutLoggingConfiguration` request.
     *
     * When you successfully enable logging using a `PutLoggingConfiguration` request, AWS WAF will create a service linked role with the necessary permissions to write logs to the Amazon Kinesis Data Firehose. For more information, see [Logging Web ACL Traffic Information](https://docs.aws.amazon.com/waf/latest/developerguide/logging.html) in the *AWS WAF Developer Guide*.
     */
    public suspend fun putLoggingConfiguration(input: PutLoggingConfigurationRequest): PutLoggingConfigurationResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Attaches an IAM policy to the specified resource. The only supported use for this action is to share a RuleGroup across accounts.
     *
     * The `PutPermissionPolicy` is subject to the following restrictions:
     * + You can attach only one policy with each `PutPermissionPolicy` request.
     * + The policy must include an `Effect`, `Action` and `Principal`.
     * + `Effect` must specify `Allow`.
     * + The `Action` in the policy must be `waf:UpdateWebACL`, `waf-regional:UpdateWebACL`, `waf:GetRuleGroup` and `waf-regional:GetRuleGroup` . Any extra or wildcard actions in the policy will be rejected.
     * + The policy cannot include a `Resource` parameter.
     * + The ARN in the request must be a valid WAF RuleGroup ARN and the RuleGroup must exist in the same region.
     * + The user making the request must be the owner of the RuleGroup.
     * + Your policy must be composed using IAM Policy version 2012-10-17.
     *
     * For more information, see [IAM Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html).
     *
     * An example of a valid policy parameter is shown in the Examples section below.
     */
    public suspend fun putPermissionPolicy(input: PutPermissionPolicyRequest): PutPermissionPolicyResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Associates tags with the specified AWS resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each AWS resource, up to 50 tags for a resource.
     *
     * Tagging is only available through the API, SDKs, and CLI. You can't manage or view tags through the AWS WAF Classic console. You can use this action to tag the AWS resources that you manage through AWS WAF Classic: web ACLs, rule groups, and rules.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Inserts or deletes ByteMatchTuple objects (filters) in a ByteMatchSet. For each `ByteMatchTuple` object, you specify the following values:
     * + Whether to insert or delete the object from the array. If you want to change a `ByteMatchSetUpdate` object, you delete the existing object and add a new one.
     * + The part of a web request that you want AWS WAF to inspect, such as a query string or the value of the `User-Agent` header.
     * + The bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to look for. For more information, including how you specify the values for the AWS WAF API and the AWS CLI or SDKs, see `TargetString` in the ByteMatchTuple data type.
     * + Where to look, such as at the beginning or the end of a query string.
     * + Whether to perform any conversions on the request, such as converting it to lowercase, before inspecting it for the specified string.
     *
     * For example, you can add a `ByteMatchSetUpdate` object that matches web requests in which `User-Agent` headers contain the string `BadBot`. You can then configure AWS WAF to block those requests.
     *
     * To create and configure a `ByteMatchSet`, perform the following steps:
     * + Create a `ByteMatchSet.` For more information, see CreateByteMatchSet.
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of an `UpdateByteMatchSet` request.
     * + Submit an `UpdateByteMatchSet` request to specify the part of the request that you want AWS WAF to inspect (for example, the header or the URI) and the value that you want AWS WAF to watch for.
     *
     * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
     *
     * @sample aws.sdk.kotlin.services.waf.samples.UpdateByteMatchSet.sample
     */
    public suspend fun updateByteMatchSet(input: UpdateByteMatchSetRequest): UpdateByteMatchSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Inserts or deletes GeoMatchConstraint objects in an `GeoMatchSet`. For each `GeoMatchConstraint` object, you specify the following values:
     * + Whether to insert or delete the object from the array. If you want to change an `GeoMatchConstraint` object, you delete the existing object and add a new one.
     * + The `Type`. The only valid value for `Type` is `Country`.
     * + The `Value`, which is a two character code for the country to add to the `GeoMatchConstraint` object. Valid codes are listed in GeoMatchConstraint$Value.
     *
     * To create and configure an `GeoMatchSet`, perform the following steps:
     * + Submit a CreateGeoMatchSet request.
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of an UpdateGeoMatchSet request.
     * + Submit an `UpdateGeoMatchSet` request to specify the country that you want AWS WAF to watch for.
     *
     * When you update an `GeoMatchSet`, you specify the country that you want to add and/or the country that you want to delete. If you want to change a country, you delete the existing country and add the new one.
     *
     * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
     */
    public suspend fun updateGeoMatchSet(input: UpdateGeoMatchSetRequest): UpdateGeoMatchSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Inserts or deletes IPSetDescriptor objects in an `IPSet`. For each `IPSetDescriptor` object, you specify the following values:
     * + Whether to insert or delete the object from the array. If you want to change an `IPSetDescriptor` object, you delete the existing object and add a new one.
     * + The IP address version, `IPv4` or `IPv6`.
     * + The IP address in CIDR notation, for example, `192.0.2.0/24` (for the range of IP addresses from `192.0.2.0` to `192.0.2.255`) or `192.0.2.44/32` (for the individual IP address `192.0.2.44`).
     *
     * AWS WAF supports IPv4 address ranges: /8 and any range between /16 through /32. AWS WAF supports IPv6 address ranges: /24, /32, /48, /56, /64, and /128. For more information about CIDR notation, see the Wikipedia entry [Classless Inter-Domain Routing](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
     *
     * IPv6 addresses can be represented using any of the following formats:
     * + 1111:0000:0000:0000:0000:0000:0000:0111/128
     * + 1111:0:0:0:0:0:0:0111/128
     * + 1111::0111/128
     * + 1111::111/128
     *
     * You use an `IPSet` to specify which web requests you want to allow or block based on the IP addresses that the requests originated from. For example, if you're receiving a lot of requests from one or a small number of IP addresses and you want to block the requests, you can create an `IPSet` that specifies those IP addresses, and then configure AWS WAF to block the requests.
     *
     * To create and configure an `IPSet`, perform the following steps:
     * + Submit a CreateIPSet request.
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of an UpdateIPSet request.
     * + Submit an `UpdateIPSet` request to specify the IP addresses that you want AWS WAF to watch for.
     *
     * When you update an `IPSet`, you specify the IP addresses that you want to add and/or the IP addresses that you want to delete. If you want to change an IP address, you delete the existing IP address and add the new one.
     *
     * You can insert a maximum of 1000 addresses in a single request.
     *
     * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
     *
     * @sample aws.sdk.kotlin.services.waf.samples.UpdateIPSet.sample
     */
    public suspend fun updateIpSet(input: UpdateIpSetRequest): UpdateIpSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Inserts or deletes Predicate objects in a rule and updates the `RateLimit` in the rule.
     *
     * Each `Predicate` object identifies a predicate, such as a ByteMatchSet or an IPSet, that specifies the web requests that you want to block or count. The `RateLimit` specifies the number of requests every five minutes that triggers the rule.
     *
     * If you add more than one predicate to a `RateBasedRule`, a request must match all the predicates and exceed the `RateLimit` to be counted or blocked. For example, suppose you add the following to a `RateBasedRule`:
     * + An `IPSet` that matches the IP address `192.0.2.44/32`
     * + A `ByteMatchSet` that matches `BadBot` in the `User-Agent` header
     *
     * Further, you specify a `RateLimit` of 1,000.
     *
     * You then add the `RateBasedRule` to a `WebACL` and specify that you want to block requests that satisfy the rule. For a request to be blocked, it must come from the IP address 192.0.2.44 *and* the `User-Agent` header in the request must contain the value `BadBot`. Further, requests that match these two conditions much be received at a rate of more than 1,000 every five minutes. If the rate drops below this limit, AWS WAF no longer blocks the requests.
     *
     * As a second example, suppose you want to limit requests to a particular page on your site. To do this, you could add the following to a `RateBasedRule`:
     * + A `ByteMatchSet` with `FieldToMatch` of `URI`
     * + A `PositionalConstraint` of `STARTS_WITH`
     * + A `TargetString` of `login`
     *
     * Further, you specify a `RateLimit` of 1,000.
     *
     * By adding this `RateBasedRule` to a `WebACL`, you could limit requests to your login page without affecting the rest of your site.
     */
    public suspend fun updateRateBasedRule(input: UpdateRateBasedRuleRequest): UpdateRateBasedRuleResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Inserts or deletes RegexMatchTuple objects (filters) in a RegexMatchSet. For each `RegexMatchSetUpdate` object, you specify the following values:
     * + Whether to insert or delete the object from the array. If you want to change a `RegexMatchSetUpdate` object, you delete the existing object and add a new one.
     * + The part of a web request that you want AWS WAF to inspectupdate, such as a query string or the value of the `User-Agent` header.
     * + The identifier of the pattern (a regular expression) that you want AWS WAF to look for. For more information, see RegexPatternSet.
     * + Whether to perform any conversions on the request, such as converting it to lowercase, before inspecting it for the specified string.
     *
     *  For example, you can create a `RegexPatternSet` that matches any requests with `User-Agent` headers that contain the string `B[a@]dB[o0]t`. You can then configure AWS WAF to reject those requests.
     *
     * To create and configure a `RegexMatchSet`, perform the following steps:
     * + Create a `RegexMatchSet.` For more information, see CreateRegexMatchSet.
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of an `UpdateRegexMatchSet` request.
     * + Submit an `UpdateRegexMatchSet` request to specify the part of the request that you want AWS WAF to inspect (for example, the header or the URI) and the identifier of the `RegexPatternSet` that contain the regular expression patters you want AWS WAF to watch for.
     *
     * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
     */
    public suspend fun updateRegexMatchSet(input: UpdateRegexMatchSetRequest): UpdateRegexMatchSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Inserts or deletes `RegexPatternString` objects in a RegexPatternSet. For each `RegexPatternString` object, you specify the following values:
     * + Whether to insert or delete the `RegexPatternString`.
     * + The regular expression pattern that you want to insert or delete. For more information, see RegexPatternSet.
     *
     *  For example, you can create a `RegexPatternString` such as `B[a@]dB[o0]t`. AWS WAF will match this `RegexPatternString` to:
     * + BadBot
     * + BadB0t
     * + B@dBot
     * + B@dB0t
     *
     * To create and configure a `RegexPatternSet`, perform the following steps:
     * + Create a `RegexPatternSet.` For more information, see CreateRegexPatternSet.
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of an `UpdateRegexPatternSet` request.
     * + Submit an `UpdateRegexPatternSet` request to specify the regular expression pattern that you want AWS WAF to watch for.
     *
     * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
     */
    public suspend fun updateRegexPatternSet(input: UpdateRegexPatternSetRequest): UpdateRegexPatternSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Inserts or deletes Predicate objects in a `Rule`. Each `Predicate` object identifies a predicate, such as a ByteMatchSet or an IPSet, that specifies the web requests that you want to allow, block, or count. If you add more than one predicate to a `Rule`, a request must match all of the specifications to be allowed, blocked, or counted. For example, suppose that you add the following to a `Rule`:
     * + A `ByteMatchSet` that matches the value `BadBot` in the `User-Agent` header
     * + An `IPSet` that matches the IP address `192.0.2.44`
     *
     * You then add the `Rule` to a `WebACL` and specify that you want to block requests that satisfy the `Rule`. For a request to be blocked, the `User-Agent` header in the request must contain the value `BadBot`*and* the request must originate from the IP address 192.0.2.44.
     *
     * To create and configure a `Rule`, perform the following steps:
     * + Create and update the predicates that you want to include in the `Rule`.
     * + Create the `Rule`. See CreateRule.
     * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an UpdateRule request.
     * + Submit an `UpdateRule` request to add predicates to the `Rule`.
     * + Create and update a `WebACL` that contains the `Rule`. See CreateWebACL.
     *
     * If you want to replace one `ByteMatchSet` or `IPSet` with another, you delete the existing one and add the new one.
     *
     * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
     *
     * @sample aws.sdk.kotlin.services.waf.samples.UpdateRule.sample
     */
    public suspend fun updateRule(input: UpdateRuleRequest): UpdateRuleResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Inserts or deletes ActivatedRule objects in a `RuleGroup`.
     *
     * You can only insert `REGULAR` rules into a rule group.
     *
     * You can have a maximum of ten rules per rule group.
     *
     * To create and configure a `RuleGroup`, perform the following steps:
     * + Create and update the `Rules` that you want to include in the `RuleGroup`. See CreateRule.
     * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an UpdateRuleGroup request.
     * + Submit an `UpdateRuleGroup` request to add `Rules` to the `RuleGroup`.
     * + Create and update a `WebACL` that contains the `RuleGroup`. See CreateWebACL.
     *
     * If you want to replace one `Rule` with another, you delete the existing one and add the new one.
     *
     * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
     */
    public suspend fun updateRuleGroup(input: UpdateRuleGroupRequest): UpdateRuleGroupResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Inserts or deletes SizeConstraint objects (filters) in a SizeConstraintSet. For each `SizeConstraint` object, you specify the following values:
     * + Whether to insert or delete the object from the array. If you want to change a `SizeConstraintSetUpdate` object, you delete the existing object and add a new one.
     * + The part of a web request that you want AWS WAF to evaluate, such as the length of a query string or the length of the `User-Agent` header.
     * + Whether to perform any transformations on the request, such as converting it to lowercase, before checking its length. Note that transformations of the request body are not supported because the AWS resource forwards only the first `8192` bytes of your request to AWS WAF.You can only specify a single type of TextTransformation.
     * + A `ComparisonOperator` used for evaluating the selected part of the request against the specified `Size`, such as equals, greater than, less than, and so on.
     * + The length, in bytes, that you want AWS WAF to watch for in selected part of the request. The length is computed after applying the transformation.
     *
     * For example, you can add a `SizeConstraintSetUpdate` object that matches web requests in which the length of the `User-Agent` header is greater than 100 bytes. You can then configure AWS WAF to block those requests.
     *
     * To create and configure a `SizeConstraintSet`, perform the following steps:
     * + Create a `SizeConstraintSet.` For more information, see CreateSizeConstraintSet.
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of an `UpdateSizeConstraintSet` request.
     * + Submit an `UpdateSizeConstraintSet` request to specify the part of the request that you want AWS WAF to inspect (for example, the header or the URI) and the value that you want AWS WAF to watch for.
     *
     * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
     *
     * @sample aws.sdk.kotlin.services.waf.samples.UpdateSizeConstraintSet.sample
     */
    public suspend fun updateSizeConstraintSet(input: UpdateSizeConstraintSetRequest): UpdateSizeConstraintSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Inserts or deletes SqlInjectionMatchTuple objects (filters) in a SqlInjectionMatchSet. For each `SqlInjectionMatchTuple` object, you specify the following values:
     * + `Action`: Whether to insert the object into or delete the object from the array. To change a `SqlInjectionMatchTuple`, you delete the existing object and add a new one.
     * + `FieldToMatch`: The part of web requests that you want AWS WAF to inspect and, if you want AWS WAF to inspect a header or custom query parameter, the name of the header or parameter.
     * + `TextTransformation`: Which text transformation, if any, to perform on the web request before inspecting the request for snippets of malicious SQL code.You can only specify a single type of TextTransformation.
     *
     * You use `SqlInjectionMatchSet` objects to specify which CloudFront requests that you want to allow, block, or count. For example, if you're receiving requests that contain snippets of SQL code in the query string and you want to block the requests, you can create a `SqlInjectionMatchSet` with the applicable settings, and then configure AWS WAF to block the requests.
     *
     * To create and configure a `SqlInjectionMatchSet`, perform the following steps:
     * + Submit a CreateSqlInjectionMatchSet request.
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of an UpdateIPSet request.
     * + Submit an `UpdateSqlInjectionMatchSet` request to specify the parts of web requests that you want AWS WAF to inspect for snippets of SQL code.
     *
     * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
     *
     * @sample aws.sdk.kotlin.services.waf.samples.UpdateSqlInjectionMatchSet.sample
     */
    public suspend fun updateSqlInjectionMatchSet(input: UpdateSqlInjectionMatchSetRequest): UpdateSqlInjectionMatchSetResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Inserts or deletes ActivatedRule objects in a `WebACL`. Each `Rule` identifies web requests that you want to allow, block, or count. When you update a `WebACL`, you specify the following values:
     * + A default action for the `WebACL`, either `ALLOW` or `BLOCK`. AWS WAF performs the default action if a request doesn't match the criteria in any of the `Rules` in a `WebACL`.
     * + The `Rules` that you want to add or delete. If you want to replace one `Rule` with another, you delete the existing `Rule` and add the new one.
     * + For each `Rule`, whether you want AWS WAF to allow requests, block requests, or count requests that match the conditions in the `Rule`.
     * + The order in which you want AWS WAF to evaluate the `Rules` in a `WebACL`. If you add more than one `Rule` to a `WebACL`, AWS WAF evaluates each request against the `Rules` in order based on the value of `Priority`. (The `Rule` that has the lowest value for `Priority` is evaluated first.) When a web request matches all the predicates (such as `ByteMatchSets` and `IPSets`) in a `Rule`, AWS WAF immediately takes the corresponding action, allow or block, and doesn't evaluate the request against the remaining `Rules` in the `WebACL`, if any.
     *
     * To create and configure a `WebACL`, perform the following steps:
     * + Create and update the predicates that you want to include in `Rules`. For more information, see CreateByteMatchSet, UpdateByteMatchSet, CreateIPSet, UpdateIPSet, CreateSqlInjectionMatchSet, and UpdateSqlInjectionMatchSet.
     * + Create and update the `Rules` that you want to include in the `WebACL`. For more information, see CreateRule and UpdateRule.
     * + Create a `WebACL`. See CreateWebACL.
     * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an UpdateWebACL request.
     * + Submit an `UpdateWebACL` request to specify the `Rules` that you want to include in the `WebACL`, to specify the default action, and to associate the `WebACL` with a CloudFront distribution. The `ActivatedRule` can be a rule group. If you specify a rule group as your `ActivatedRule` , you can exclude specific rules from that rule group.If you already have a rule group associated with a web ACL and want to submit an `UpdateWebACL` request to exclude certain rules from that rule group, you must first remove the rule group from the web ACL, the re-insert it again, specifying the excluded rules. For details, see ActivatedRule$ExcludedRules .
     *
     * Be aware that if you try to add a RATE_BASED rule to a web ACL without setting the rule type when first creating the rule, the UpdateWebACL request will fail because the request tries to add a REGULAR rule (the default rule type) with the specified ID, which does not exist.
     *
     * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
     *
     * @sample aws.sdk.kotlin.services.waf.samples.UpdateWebACL.sample
     */
    public suspend fun updateWebAcl(input: UpdateWebAclRequest): UpdateWebAclResponse

    /**
     * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
     *
     * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
     *
     * Inserts or deletes XssMatchTuple objects (filters) in an XssMatchSet. For each `XssMatchTuple` object, you specify the following values:
     * + `Action`: Whether to insert the object into or delete the object from the array. To change an `XssMatchTuple`, you delete the existing object and add a new one.
     * + `FieldToMatch`: The part of web requests that you want AWS WAF to inspect and, if you want AWS WAF to inspect a header or custom query parameter, the name of the header or parameter.
     * + `TextTransformation`: Which text transformation, if any, to perform on the web request before inspecting the request for cross-site scripting attacks.You can only specify a single type of TextTransformation.
     *
     * You use `XssMatchSet` objects to specify which CloudFront requests that you want to allow, block, or count. For example, if you're receiving requests that contain cross-site scripting attacks in the request body and you want to block the requests, you can create an `XssMatchSet` with the applicable settings, and then configure AWS WAF to block the requests.
     *
     * To create and configure an `XssMatchSet`, perform the following steps:
     * + Submit a CreateXssMatchSet request.
     * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of an UpdateIPSet request.
     * + Submit an `UpdateXssMatchSet` request to specify the parts of web requests that you want AWS WAF to inspect for cross-site scripting attacks.
     *
     * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
     *
     * @sample aws.sdk.kotlin.services.waf.samples.UpdateXssMatchSet.sample
     */
    public suspend fun updateXssMatchSet(input: UpdateXssMatchSetRequest): UpdateXssMatchSetResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun WafClient.withConfig(block: WafClient.Config.Builder.() -> Unit): WafClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultWafClient(newConfig)
}

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Creates a `ByteMatchSet`. You then use UpdateByteMatchSet to identify the part of a web request that you want AWS WAF to inspect, such as the values of the `User-Agent` header or the query string. For example, you can create a `ByteMatchSet` that matches any requests with `User-Agent` headers that contain the string `BadBot`. You can then configure AWS WAF to reject those requests.
 *
 * To create and configure a `ByteMatchSet`, perform the following steps:
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `CreateByteMatchSet` request.
 * + Submit a `CreateByteMatchSet` request.
 * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an `UpdateByteMatchSet` request.
 * + Submit an UpdateByteMatchSet request to specify the part of the request that you want AWS WAF to inspect (for example, the header or the URI) and the value that you want AWS WAF to watch for.
 *
 * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
 */
public suspend inline fun WafClient.createByteMatchSet(crossinline block: CreateByteMatchSetRequest.Builder.() -> Unit): CreateByteMatchSetResponse = createByteMatchSet(CreateByteMatchSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Creates an GeoMatchSet, which you use to specify which web requests you want to allow or block based on the country that the requests originate from. For example, if you're receiving a lot of requests from one or more countries and you want to block the requests, you can create an `GeoMatchSet` that contains those countries and then configure AWS WAF to block the requests.
 *
 * To create and configure a `GeoMatchSet`, perform the following steps:
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `CreateGeoMatchSet` request.
 * + Submit a `CreateGeoMatchSet` request.
 * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an UpdateGeoMatchSet request.
 * + Submit an `UpdateGeoMatchSetSet` request to specify the countries that you want AWS WAF to watch for.
 *
 * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
 */
public suspend inline fun WafClient.createGeoMatchSet(crossinline block: CreateGeoMatchSetRequest.Builder.() -> Unit): CreateGeoMatchSetResponse = createGeoMatchSet(CreateGeoMatchSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Creates an IPSet, which you use to specify which web requests that you want to allow or block based on the IP addresses that the requests originate from. For example, if you're receiving a lot of requests from one or more individual IP addresses or one or more ranges of IP addresses and you want to block the requests, you can create an `IPSet` that contains those IP addresses and then configure AWS WAF to block the requests.
 *
 * To create and configure an `IPSet`, perform the following steps:
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `CreateIPSet` request.
 * + Submit a `CreateIPSet` request.
 * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an UpdateIPSet request.
 * + Submit an `UpdateIPSet` request to specify the IP addresses that you want AWS WAF to watch for.
 *
 * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
 *
 * @sample aws.sdk.kotlin.services.waf.samples.CreateIPSet.sample
 */
public suspend inline fun WafClient.createIpSet(crossinline block: CreateIpSetRequest.Builder.() -> Unit): CreateIpSetResponse = createIpSet(CreateIpSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Creates a RateBasedRule. The `RateBasedRule` contains a `RateLimit`, which specifies the maximum number of requests that AWS WAF allows from a specified IP address in a five-minute period. The `RateBasedRule` also contains the `IPSet` objects, `ByteMatchSet` objects, and other predicates that identify the requests that you want to count or block if these requests exceed the `RateLimit`.
 *
 * If you add more than one predicate to a `RateBasedRule`, a request not only must exceed the `RateLimit`, but it also must match all the conditions to be counted or blocked. For example, suppose you add the following to a `RateBasedRule`:
 * + An `IPSet` that matches the IP address `192.0.2.44/32`
 * + A `ByteMatchSet` that matches `BadBot` in the `User-Agent` header
 *
 * Further, you specify a `RateLimit` of 1,000.
 *
 * You then add the `RateBasedRule` to a `WebACL` and specify that you want to block requests that meet the conditions in the rule. For a request to be blocked, it must come from the IP address 192.0.2.44 *and* the `User-Agent` header in the request must contain the value `BadBot`. Further, requests that match these two conditions must be received at a rate of more than 1,000 requests every five minutes. If both conditions are met and the rate is exceeded, AWS WAF blocks the requests. If the rate drops below 1,000 for a five-minute period, AWS WAF no longer blocks the requests.
 *
 * As a second example, suppose you want to limit requests to a particular page on your site. To do this, you could add the following to a `RateBasedRule`:
 * + A `ByteMatchSet` with `FieldToMatch` of `URI`
 * + A `PositionalConstraint` of `STARTS_WITH`
 * + A `TargetString` of `login`
 *
 * Further, you specify a `RateLimit` of 1,000.
 *
 * By adding this `RateBasedRule` to a `WebACL`, you could limit requests to your login page without affecting the rest of your site.
 *
 * To create and configure a `RateBasedRule`, perform the following steps:
 * + Create and update the predicates that you want to include in the rule. For more information, see CreateByteMatchSet, CreateIPSet, and CreateSqlInjectionMatchSet.
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `CreateRule` request.
 * + Submit a `CreateRateBasedRule` request.
 * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an UpdateRule request.
 * + Submit an `UpdateRateBasedRule` request to specify the predicates that you want to include in the rule.
 * + Create and update a `WebACL` that contains the `RateBasedRule`. For more information, see CreateWebACL.
 *
 * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
 */
public suspend inline fun WafClient.createRateBasedRule(crossinline block: CreateRateBasedRuleRequest.Builder.() -> Unit): CreateRateBasedRuleResponse = createRateBasedRule(CreateRateBasedRuleRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Creates a RegexMatchSet. You then use UpdateRegexMatchSet to identify the part of a web request that you want AWS WAF to inspect, such as the values of the `User-Agent` header or the query string. For example, you can create a `RegexMatchSet` that contains a `RegexMatchTuple` that looks for any requests with `User-Agent` headers that match a `RegexPatternSet` with pattern `B[a@]dB[o0]t`. You can then configure AWS WAF to reject those requests.
 *
 * To create and configure a `RegexMatchSet`, perform the following steps:
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `CreateRegexMatchSet` request.
 * + Submit a `CreateRegexMatchSet` request.
 * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an `UpdateRegexMatchSet` request.
 * + Submit an UpdateRegexMatchSet request to specify the part of the request that you want AWS WAF to inspect (for example, the header or the URI) and the value, using a `RegexPatternSet`, that you want AWS WAF to watch for.
 *
 * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
 */
public suspend inline fun WafClient.createRegexMatchSet(crossinline block: CreateRegexMatchSetRequest.Builder.() -> Unit): CreateRegexMatchSetResponse = createRegexMatchSet(CreateRegexMatchSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Creates a `RegexPatternSet`. You then use UpdateRegexPatternSet to specify the regular expression (regex) pattern that you want AWS WAF to search for, such as `B[a@]dB[o0]t`. You can then configure AWS WAF to reject those requests.
 *
 * To create and configure a `RegexPatternSet`, perform the following steps:
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `CreateRegexPatternSet` request.
 * + Submit a `CreateRegexPatternSet` request.
 * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an `UpdateRegexPatternSet` request.
 * + Submit an UpdateRegexPatternSet request to specify the string that you want AWS WAF to watch for.
 *
 * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
 */
public suspend inline fun WafClient.createRegexPatternSet(crossinline block: CreateRegexPatternSetRequest.Builder.() -> Unit): CreateRegexPatternSetResponse = createRegexPatternSet(CreateRegexPatternSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Creates a `Rule`, which contains the `IPSet` objects, `ByteMatchSet` objects, and other predicates that identify the requests that you want to block. If you add more than one predicate to a `Rule`, a request must match all of the specifications to be allowed or blocked. For example, suppose that you add the following to a `Rule`:
 * + An `IPSet` that matches the IP address `192.0.2.44/32`
 * + A `ByteMatchSet` that matches `BadBot` in the `User-Agent` header
 *
 * You then add the `Rule` to a `WebACL` and specify that you want to blocks requests that satisfy the `Rule`. For a request to be blocked, it must come from the IP address 192.0.2.44 *and* the `User-Agent` header in the request must contain the value `BadBot`.
 *
 * To create and configure a `Rule`, perform the following steps:
 * + Create and update the predicates that you want to include in the `Rule`. For more information, see CreateByteMatchSet, CreateIPSet, and CreateSqlInjectionMatchSet.
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `CreateRule` request.
 * + Submit a `CreateRule` request.
 * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an UpdateRule request.
 * + Submit an `UpdateRule` request to specify the predicates that you want to include in the `Rule`.
 * + Create and update a `WebACL` that contains the `Rule`. For more information, see CreateWebACL.
 *
 * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
 *
 * @sample aws.sdk.kotlin.services.waf.samples.CreateRule.sample
 */
public suspend inline fun WafClient.createRule(crossinline block: CreateRuleRequest.Builder.() -> Unit): CreateRuleResponse = createRule(CreateRuleRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Creates a `RuleGroup`. A rule group is a collection of predefined rules that you add to a web ACL. You use UpdateRuleGroup to add rules to the rule group.
 *
 * Rule groups are subject to the following limits:
 * + Three rule groups per account. You can request an increase to this limit by contacting customer support.
 * + One rule group per web ACL.
 * + Ten rules per rule group.
 *
 * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
 */
public suspend inline fun WafClient.createRuleGroup(crossinline block: CreateRuleGroupRequest.Builder.() -> Unit): CreateRuleGroupResponse = createRuleGroup(CreateRuleGroupRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Creates a `SizeConstraintSet`. You then use UpdateSizeConstraintSet to identify the part of a web request that you want AWS WAF to check for length, such as the length of the `User-Agent` header or the length of the query string. For example, you can create a `SizeConstraintSet` that matches any requests that have a query string that is longer than 100 bytes. You can then configure AWS WAF to reject those requests.
 *
 * To create and configure a `SizeConstraintSet`, perform the following steps:
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `CreateSizeConstraintSet` request.
 * + Submit a `CreateSizeConstraintSet` request.
 * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an `UpdateSizeConstraintSet` request.
 * + Submit an UpdateSizeConstraintSet request to specify the part of the request that you want AWS WAF to inspect (for example, the header or the URI) and the value that you want AWS WAF to watch for.
 *
 * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
 *
 * @sample aws.sdk.kotlin.services.waf.samples.CreateSizeConstraintSet.sample
 */
public suspend inline fun WafClient.createSizeConstraintSet(crossinline block: CreateSizeConstraintSetRequest.Builder.() -> Unit): CreateSizeConstraintSetResponse = createSizeConstraintSet(CreateSizeConstraintSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Creates a SqlInjectionMatchSet, which you use to allow, block, or count requests that contain snippets of SQL code in a specified part of web requests. AWS WAF searches for character sequences that are likely to be malicious strings.
 *
 * To create and configure a `SqlInjectionMatchSet`, perform the following steps:
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `CreateSqlInjectionMatchSet` request.
 * + Submit a `CreateSqlInjectionMatchSet` request.
 * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an UpdateSqlInjectionMatchSet request.
 * + Submit an UpdateSqlInjectionMatchSet request to specify the parts of web requests in which you want to allow, block, or count malicious SQL code.
 *
 * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
 *
 * @sample aws.sdk.kotlin.services.waf.samples.CreateSqlInjectionMatchSet.sample
 */
public suspend inline fun WafClient.createSqlInjectionMatchSet(crossinline block: CreateSqlInjectionMatchSetRequest.Builder.() -> Unit): CreateSqlInjectionMatchSetResponse = createSqlInjectionMatchSet(CreateSqlInjectionMatchSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Creates a `WebACL`, which contains the `Rules` that identify the CloudFront web requests that you want to allow, block, or count. AWS WAF evaluates `Rules` in order based on the value of `Priority` for each `Rule`.
 *
 * You also specify a default action, either `ALLOW` or `BLOCK`. If a web request doesn't match any of the `Rules` in a `WebACL`, AWS WAF responds to the request with the default action.
 *
 * To create and configure a `WebACL`, perform the following steps:
 * + Create and update the `ByteMatchSet` objects and other predicates that you want to include in `Rules`. For more information, see CreateByteMatchSet, UpdateByteMatchSet, CreateIPSet, UpdateIPSet, CreateSqlInjectionMatchSet, and UpdateSqlInjectionMatchSet.
 * + Create and update the `Rules` that you want to include in the `WebACL`. For more information, see CreateRule and UpdateRule.
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `CreateWebACL` request.
 * + Submit a `CreateWebACL` request.
 * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an UpdateWebACL request.
 * + Submit an UpdateWebACL request to specify the `Rules` that you want to include in the `WebACL`, to specify the default action, and to associate the `WebACL` with a CloudFront distribution.
 *
 * For more information about how to use the AWS WAF API, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
 *
 * @sample aws.sdk.kotlin.services.waf.samples.CreateWebACL.sample
 */
public suspend inline fun WafClient.createWebAcl(crossinline block: CreateWebAclRequest.Builder.() -> Unit): CreateWebAclResponse = createWebAcl(CreateWebAclRequest.Builder().apply(block).build())

/**
 * Creates an AWS CloudFormation WAFV2 template for the specified web ACL in the specified Amazon S3 bucket. Then, in CloudFormation, you create a stack from the template, to create the web ACL and its resources in AWS WAFV2. Use this to migrate your AWS WAF Classic web ACL to the latest version of AWS WAF.
 *
 * This is part of a larger migration procedure for web ACLs from AWS WAF Classic to the latest version of AWS WAF. For the full procedure, including caveats and manual steps to complete the migration and switch over to the new web ACL, see [Migrating your AWS WAF Classic resources to AWS WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-migrating-from-classic.html) in the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
 */
public suspend inline fun WafClient.createWebAclMigrationStack(crossinline block: CreateWebAclMigrationStackRequest.Builder.() -> Unit): CreateWebAclMigrationStackResponse = createWebAclMigrationStack(CreateWebAclMigrationStackRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Creates an XssMatchSet, which you use to allow, block, or count requests that contain cross-site scripting attacks in the specified part of web requests. AWS WAF searches for character sequences that are likely to be malicious strings.
 *
 * To create and configure an `XssMatchSet`, perform the following steps:
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `CreateXssMatchSet` request.
 * + Submit a `CreateXssMatchSet` request.
 * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an UpdateXssMatchSet request.
 * + Submit an UpdateXssMatchSet request to specify the parts of web requests in which you want to allow, block, or count cross-site scripting attacks.
 *
 * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
 *
 * @sample aws.sdk.kotlin.services.waf.samples.CreateXssMatchSet.sample
 */
public suspend inline fun WafClient.createXssMatchSet(crossinline block: CreateXssMatchSetRequest.Builder.() -> Unit): CreateXssMatchSetResponse = createXssMatchSet(CreateXssMatchSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Permanently deletes a ByteMatchSet. You can't delete a `ByteMatchSet` if it's still used in any `Rules` or if it still includes any ByteMatchTuple objects (any filters).
 *
 * If you just want to remove a `ByteMatchSet` from a `Rule`, use UpdateRule.
 *
 * To permanently delete a `ByteMatchSet`, perform the following steps:
 * + Update the `ByteMatchSet` to remove filters, if any. For more information, see UpdateByteMatchSet.
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `DeleteByteMatchSet` request.
 * + Submit a `DeleteByteMatchSet` request.
 *
 * @sample aws.sdk.kotlin.services.waf.samples.DeleteByteMatchSet.sample
 */
public suspend inline fun WafClient.deleteByteMatchSet(crossinline block: DeleteByteMatchSetRequest.Builder.() -> Unit): DeleteByteMatchSetResponse = deleteByteMatchSet(DeleteByteMatchSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Permanently deletes a GeoMatchSet. You can't delete a `GeoMatchSet` if it's still used in any `Rules` or if it still includes any countries.
 *
 * If you just want to remove a `GeoMatchSet` from a `Rule`, use UpdateRule.
 *
 * To permanently delete a `GeoMatchSet` from AWS WAF, perform the following steps:
 * + Update the `GeoMatchSet` to remove any countries. For more information, see UpdateGeoMatchSet.
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `DeleteGeoMatchSet` request.
 * + Submit a `DeleteGeoMatchSet` request.
 */
public suspend inline fun WafClient.deleteGeoMatchSet(crossinline block: DeleteGeoMatchSetRequest.Builder.() -> Unit): DeleteGeoMatchSetResponse = deleteGeoMatchSet(DeleteGeoMatchSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Permanently deletes an IPSet. You can't delete an `IPSet` if it's still used in any `Rules` or if it still includes any IP addresses.
 *
 * If you just want to remove an `IPSet` from a `Rule`, use UpdateRule.
 *
 * To permanently delete an `IPSet` from AWS WAF, perform the following steps:
 * + Update the `IPSet` to remove IP address ranges, if any. For more information, see UpdateIPSet.
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `DeleteIPSet` request.
 * + Submit a `DeleteIPSet` request.
 *
 * @sample aws.sdk.kotlin.services.waf.samples.DeleteIPSet.sample
 */
public suspend inline fun WafClient.deleteIpSet(crossinline block: DeleteIpSetRequest.Builder.() -> Unit): DeleteIpSetResponse = deleteIpSet(DeleteIpSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Permanently deletes the LoggingConfiguration from the specified web ACL.
 */
public suspend inline fun WafClient.deleteLoggingConfiguration(crossinline block: DeleteLoggingConfigurationRequest.Builder.() -> Unit): DeleteLoggingConfigurationResponse = deleteLoggingConfiguration(DeleteLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Permanently deletes an IAM policy from the specified RuleGroup.
 *
 * The user making the request must be the owner of the RuleGroup.
 */
public suspend inline fun WafClient.deletePermissionPolicy(crossinline block: DeletePermissionPolicyRequest.Builder.() -> Unit): DeletePermissionPolicyResponse = deletePermissionPolicy(DeletePermissionPolicyRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Permanently deletes a RateBasedRule. You can't delete a rule if it's still used in any `WebACL` objects or if it still includes any predicates, such as `ByteMatchSet` objects.
 *
 * If you just want to remove a rule from a `WebACL`, use UpdateWebACL.
 *
 * To permanently delete a `RateBasedRule` from AWS WAF, perform the following steps:
 * + Update the `RateBasedRule` to remove predicates, if any. For more information, see UpdateRateBasedRule.
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `DeleteRateBasedRule` request.
 * + Submit a `DeleteRateBasedRule` request.
 */
public suspend inline fun WafClient.deleteRateBasedRule(crossinline block: DeleteRateBasedRuleRequest.Builder.() -> Unit): DeleteRateBasedRuleResponse = deleteRateBasedRule(DeleteRateBasedRuleRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Permanently deletes a RegexMatchSet. You can't delete a `RegexMatchSet` if it's still used in any `Rules` or if it still includes any `RegexMatchTuples` objects (any filters).
 *
 * If you just want to remove a `RegexMatchSet` from a `Rule`, use UpdateRule.
 *
 * To permanently delete a `RegexMatchSet`, perform the following steps:
 * + Update the `RegexMatchSet` to remove filters, if any. For more information, see UpdateRegexMatchSet.
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `DeleteRegexMatchSet` request.
 * + Submit a `DeleteRegexMatchSet` request.
 */
public suspend inline fun WafClient.deleteRegexMatchSet(crossinline block: DeleteRegexMatchSetRequest.Builder.() -> Unit): DeleteRegexMatchSetResponse = deleteRegexMatchSet(DeleteRegexMatchSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Permanently deletes a RegexPatternSet. You can't delete a `RegexPatternSet` if it's still used in any `RegexMatchSet` or if the `RegexPatternSet` is not empty.
 */
public suspend inline fun WafClient.deleteRegexPatternSet(crossinline block: DeleteRegexPatternSetRequest.Builder.() -> Unit): DeleteRegexPatternSetResponse = deleteRegexPatternSet(DeleteRegexPatternSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Permanently deletes a Rule. You can't delete a `Rule` if it's still used in any `WebACL` objects or if it still includes any predicates, such as `ByteMatchSet` objects.
 *
 * If you just want to remove a `Rule` from a `WebACL`, use UpdateWebACL.
 *
 * To permanently delete a `Rule` from AWS WAF, perform the following steps:
 * + Update the `Rule` to remove predicates, if any. For more information, see UpdateRule.
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `DeleteRule` request.
 * + Submit a `DeleteRule` request.
 *
 * @sample aws.sdk.kotlin.services.waf.samples.DeleteRule.sample
 */
public suspend inline fun WafClient.deleteRule(crossinline block: DeleteRuleRequest.Builder.() -> Unit): DeleteRuleResponse = deleteRule(DeleteRuleRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Permanently deletes a RuleGroup. You can't delete a `RuleGroup` if it's still used in any `WebACL` objects or if it still includes any rules.
 *
 * If you just want to remove a `RuleGroup` from a `WebACL`, use UpdateWebACL.
 *
 * To permanently delete a `RuleGroup` from AWS WAF, perform the following steps:
 * + Update the `RuleGroup` to remove rules, if any. For more information, see UpdateRuleGroup.
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `DeleteRuleGroup` request.
 * + Submit a `DeleteRuleGroup` request.
 */
public suspend inline fun WafClient.deleteRuleGroup(crossinline block: DeleteRuleGroupRequest.Builder.() -> Unit): DeleteRuleGroupResponse = deleteRuleGroup(DeleteRuleGroupRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Permanently deletes a SizeConstraintSet. You can't delete a `SizeConstraintSet` if it's still used in any `Rules` or if it still includes any SizeConstraint objects (any filters).
 *
 * If you just want to remove a `SizeConstraintSet` from a `Rule`, use UpdateRule.
 *
 * To permanently delete a `SizeConstraintSet`, perform the following steps:
 * + Update the `SizeConstraintSet` to remove filters, if any. For more information, see UpdateSizeConstraintSet.
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `DeleteSizeConstraintSet` request.
 * + Submit a `DeleteSizeConstraintSet` request.
 *
 * @sample aws.sdk.kotlin.services.waf.samples.DeleteSizeConstraintSet.sample
 */
public suspend inline fun WafClient.deleteSizeConstraintSet(crossinline block: DeleteSizeConstraintSetRequest.Builder.() -> Unit): DeleteSizeConstraintSetResponse = deleteSizeConstraintSet(DeleteSizeConstraintSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Permanently deletes a SqlInjectionMatchSet. You can't delete a `SqlInjectionMatchSet` if it's still used in any `Rules` or if it still contains any SqlInjectionMatchTuple objects.
 *
 * If you just want to remove a `SqlInjectionMatchSet` from a `Rule`, use UpdateRule.
 *
 * To permanently delete a `SqlInjectionMatchSet` from AWS WAF, perform the following steps:
 * + Update the `SqlInjectionMatchSet` to remove filters, if any. For more information, see UpdateSqlInjectionMatchSet.
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `DeleteSqlInjectionMatchSet` request.
 * + Submit a `DeleteSqlInjectionMatchSet` request.
 *
 * @sample aws.sdk.kotlin.services.waf.samples.DeleteSqlInjectionMatchSet.sample
 */
public suspend inline fun WafClient.deleteSqlInjectionMatchSet(crossinline block: DeleteSqlInjectionMatchSetRequest.Builder.() -> Unit): DeleteSqlInjectionMatchSetResponse = deleteSqlInjectionMatchSet(DeleteSqlInjectionMatchSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Permanently deletes a WebACL. You can't delete a `WebACL` if it still contains any `Rules`.
 *
 * To delete a `WebACL`, perform the following steps:
 * + Update the `WebACL` to remove `Rules`, if any. For more information, see UpdateWebACL.
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `DeleteWebACL` request.
 * + Submit a `DeleteWebACL` request.
 *
 * @sample aws.sdk.kotlin.services.waf.samples.DeleteWebACL.sample
 */
public suspend inline fun WafClient.deleteWebAcl(crossinline block: DeleteWebAclRequest.Builder.() -> Unit): DeleteWebAclResponse = deleteWebAcl(DeleteWebAclRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Permanently deletes an XssMatchSet. You can't delete an `XssMatchSet` if it's still used in any `Rules` or if it still contains any XssMatchTuple objects.
 *
 * If you just want to remove an `XssMatchSet` from a `Rule`, use UpdateRule.
 *
 * To permanently delete an `XssMatchSet` from AWS WAF, perform the following steps:
 * + Update the `XssMatchSet` to remove filters, if any. For more information, see UpdateXssMatchSet.
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of a `DeleteXssMatchSet` request.
 * + Submit a `DeleteXssMatchSet` request.
 *
 * @sample aws.sdk.kotlin.services.waf.samples.DeleteXssMatchSet.sample
 */
public suspend inline fun WafClient.deleteXssMatchSet(crossinline block: DeleteXssMatchSetRequest.Builder.() -> Unit): DeleteXssMatchSetResponse = deleteXssMatchSet(DeleteXssMatchSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns the ByteMatchSet specified by `ByteMatchSetId`.
 *
 * @sample aws.sdk.kotlin.services.waf.samples.GetByteMatchSet.sample
 */
public suspend inline fun WafClient.getByteMatchSet(crossinline block: GetByteMatchSetRequest.Builder.() -> Unit): GetByteMatchSetResponse = getByteMatchSet(GetByteMatchSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * When you want to create, update, or delete AWS WAF objects, get a change token and include the change token in the create, update, or delete request. Change tokens ensure that your application doesn't submit conflicting requests to AWS WAF.
 *
 * Each create, update, or delete request must use a unique change token. If your application submits a `GetChangeToken` request and then submits a second `GetChangeToken` request before submitting a create, update, or delete request, the second `GetChangeToken` request returns the same value as the first `GetChangeToken` request.
 *
 * When you use a change token in a create, update, or delete request, the status of the change token changes to `PENDING`, which indicates that AWS WAF is propagating the change to all AWS WAF servers. Use `GetChangeTokenStatus` to determine the status of your change token.
 *
 * @sample aws.sdk.kotlin.services.waf.samples.GetChangeToken.sample
 */
public suspend inline fun WafClient.getChangeToken(crossinline block: GetChangeTokenRequest.Builder.() -> Unit): GetChangeTokenResponse = getChangeToken(GetChangeTokenRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns the status of a `ChangeToken` that you got by calling GetChangeToken. `ChangeTokenStatus` is one of the following values:
 * + `PROVISIONED`: You requested the change token by calling `GetChangeToken`, but you haven't used it yet in a call to create, update, or delete an AWS WAF object.
 * + `PENDING`: AWS WAF is propagating the create, update, or delete request to all AWS WAF servers.
 * + `INSYNC`: Propagation is complete.
 *
 * @sample aws.sdk.kotlin.services.waf.samples.GetChangeTokenStatus.sample
 */
public suspend inline fun WafClient.getChangeTokenStatus(crossinline block: GetChangeTokenStatusRequest.Builder.() -> Unit): GetChangeTokenStatusResponse = getChangeTokenStatus(GetChangeTokenStatusRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns the GeoMatchSet that is specified by `GeoMatchSetId`.
 */
public suspend inline fun WafClient.getGeoMatchSet(crossinline block: GetGeoMatchSetRequest.Builder.() -> Unit): GetGeoMatchSetResponse = getGeoMatchSet(GetGeoMatchSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns the IPSet that is specified by `IPSetId`.
 *
 * @sample aws.sdk.kotlin.services.waf.samples.GetIPSet.sample
 */
public suspend inline fun WafClient.getIpSet(crossinline block: GetIpSetRequest.Builder.() -> Unit): GetIpSetResponse = getIpSet(GetIpSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns the LoggingConfiguration for the specified web ACL.
 */
public suspend inline fun WafClient.getLoggingConfiguration(crossinline block: GetLoggingConfigurationRequest.Builder.() -> Unit): GetLoggingConfigurationResponse = getLoggingConfiguration(GetLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns the IAM policy attached to the RuleGroup.
 */
public suspend inline fun WafClient.getPermissionPolicy(crossinline block: GetPermissionPolicyRequest.Builder.() -> Unit): GetPermissionPolicyResponse = getPermissionPolicy(GetPermissionPolicyRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns the RateBasedRule that is specified by the `RuleId` that you included in the `GetRateBasedRule` request.
 */
public suspend inline fun WafClient.getRateBasedRule(crossinline block: GetRateBasedRuleRequest.Builder.() -> Unit): GetRateBasedRuleResponse = getRateBasedRule(GetRateBasedRuleRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns an array of IP addresses currently being blocked by the RateBasedRule that is specified by the `RuleId`. The maximum number of managed keys that will be blocked is 10,000. If more than 10,000 addresses exceed the rate limit, the 10,000 addresses with the highest rates will be blocked.
 */
public suspend inline fun WafClient.getRateBasedRuleManagedKeys(crossinline block: GetRateBasedRuleManagedKeysRequest.Builder.() -> Unit): GetRateBasedRuleManagedKeysResponse = getRateBasedRuleManagedKeys(GetRateBasedRuleManagedKeysRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns the RegexMatchSet specified by `RegexMatchSetId`.
 */
public suspend inline fun WafClient.getRegexMatchSet(crossinline block: GetRegexMatchSetRequest.Builder.() -> Unit): GetRegexMatchSetResponse = getRegexMatchSet(GetRegexMatchSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns the RegexPatternSet specified by `RegexPatternSetId`.
 */
public suspend inline fun WafClient.getRegexPatternSet(crossinline block: GetRegexPatternSetRequest.Builder.() -> Unit): GetRegexPatternSetResponse = getRegexPatternSet(GetRegexPatternSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns the Rule that is specified by the `RuleId` that you included in the `GetRule` request.
 *
 * @sample aws.sdk.kotlin.services.waf.samples.GetRule.sample
 */
public suspend inline fun WafClient.getRule(crossinline block: GetRuleRequest.Builder.() -> Unit): GetRuleResponse = getRule(GetRuleRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns the RuleGroup that is specified by the `RuleGroupId` that you included in the `GetRuleGroup` request.
 *
 * To view the rules in a rule group, use ListActivatedRulesInRuleGroup.
 */
public suspend inline fun WafClient.getRuleGroup(crossinline block: GetRuleGroupRequest.Builder.() -> Unit): GetRuleGroupResponse = getRuleGroup(GetRuleGroupRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Gets detailed information about a specified number of requests--a sample--that AWS WAF randomly selects from among the first 5,000 requests that your AWS resource received during a time range that you choose. You can specify a sample size of up to 500 requests, and you can specify any time range in the previous three hours.
 *
 * `GetSampledRequests` returns a time range, which is usually the time range that you specified. However, if your resource (such as a CloudFront distribution) received 5,000 requests before the specified time range elapsed, `GetSampledRequests` returns an updated time range. This new time range indicates the actual period during which AWS WAF selected the requests in the sample.
 */
public suspend inline fun WafClient.getSampledRequests(crossinline block: GetSampledRequestsRequest.Builder.() -> Unit): GetSampledRequestsResponse = getSampledRequests(GetSampledRequestsRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns the SizeConstraintSet specified by `SizeConstraintSetId`.
 *
 * @sample aws.sdk.kotlin.services.waf.samples.GetSizeConstraintSet.sample
 */
public suspend inline fun WafClient.getSizeConstraintSet(crossinline block: GetSizeConstraintSetRequest.Builder.() -> Unit): GetSizeConstraintSetResponse = getSizeConstraintSet(GetSizeConstraintSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns the SqlInjectionMatchSet that is specified by `SqlInjectionMatchSetId`.
 *
 * @sample aws.sdk.kotlin.services.waf.samples.GetSqlInjectionMatchSet.sample
 */
public suspend inline fun WafClient.getSqlInjectionMatchSet(crossinline block: GetSqlInjectionMatchSetRequest.Builder.() -> Unit): GetSqlInjectionMatchSetResponse = getSqlInjectionMatchSet(GetSqlInjectionMatchSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns the WebACL that is specified by `WebACLId`.
 *
 * @sample aws.sdk.kotlin.services.waf.samples.GetWebACL.sample
 */
public suspend inline fun WafClient.getWebAcl(crossinline block: GetWebAclRequest.Builder.() -> Unit): GetWebAclResponse = getWebAcl(GetWebAclRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns the XssMatchSet that is specified by `XssMatchSetId`.
 *
 * @sample aws.sdk.kotlin.services.waf.samples.GetXssMatchSet.sample
 */
public suspend inline fun WafClient.getXssMatchSet(crossinline block: GetXssMatchSetRequest.Builder.() -> Unit): GetXssMatchSetResponse = getXssMatchSet(GetXssMatchSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns an array of ActivatedRule objects.
 */
public suspend inline fun WafClient.listActivatedRulesInRuleGroup(crossinline block: ListActivatedRulesInRuleGroupRequest.Builder.() -> Unit): ListActivatedRulesInRuleGroupResponse = listActivatedRulesInRuleGroup(ListActivatedRulesInRuleGroupRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns an array of ByteMatchSetSummary objects.
 */
public suspend inline fun WafClient.listByteMatchSets(crossinline block: ListByteMatchSetsRequest.Builder.() -> Unit): ListByteMatchSetsResponse = listByteMatchSets(ListByteMatchSetsRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns an array of GeoMatchSetSummary objects in the response.
 */
public suspend inline fun WafClient.listGeoMatchSets(crossinline block: ListGeoMatchSetsRequest.Builder.() -> Unit): ListGeoMatchSetsResponse = listGeoMatchSets(ListGeoMatchSetsRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns an array of IPSetSummary objects in the response.
 *
 * @sample aws.sdk.kotlin.services.waf.samples.ListIPSets.sample
 */
public suspend inline fun WafClient.listIpSets(crossinline block: ListIpSetsRequest.Builder.() -> Unit): ListIpSetsResponse = listIpSets(ListIpSetsRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns an array of LoggingConfiguration objects.
 */
public suspend inline fun WafClient.listLoggingConfigurations(crossinline block: ListLoggingConfigurationsRequest.Builder.() -> Unit): ListLoggingConfigurationsResponse = listLoggingConfigurations(ListLoggingConfigurationsRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns an array of RuleSummary objects.
 */
public suspend inline fun WafClient.listRateBasedRules(crossinline block: ListRateBasedRulesRequest.Builder.() -> Unit): ListRateBasedRulesResponse = listRateBasedRules(ListRateBasedRulesRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns an array of RegexMatchSetSummary objects.
 */
public suspend inline fun WafClient.listRegexMatchSets(crossinline block: ListRegexMatchSetsRequest.Builder.() -> Unit): ListRegexMatchSetsResponse = listRegexMatchSets(ListRegexMatchSetsRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns an array of RegexPatternSetSummary objects.
 */
public suspend inline fun WafClient.listRegexPatternSets(crossinline block: ListRegexPatternSetsRequest.Builder.() -> Unit): ListRegexPatternSetsResponse = listRegexPatternSets(ListRegexPatternSetsRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns an array of RuleGroup objects.
 */
public suspend inline fun WafClient.listRuleGroups(crossinline block: ListRuleGroupsRequest.Builder.() -> Unit): ListRuleGroupsResponse = listRuleGroups(ListRuleGroupsRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns an array of RuleSummary objects.
 *
 * @sample aws.sdk.kotlin.services.waf.samples.ListRules.sample
 */
public suspend inline fun WafClient.listRules(crossinline block: ListRulesRequest.Builder.() -> Unit): ListRulesResponse = listRules(ListRulesRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns an array of SizeConstraintSetSummary objects.
 *
 * @sample aws.sdk.kotlin.services.waf.samples.ListSizeConstraintSets.sample
 */
public suspend inline fun WafClient.listSizeConstraintSets(crossinline block: ListSizeConstraintSetsRequest.Builder.() -> Unit): ListSizeConstraintSetsResponse = listSizeConstraintSets(ListSizeConstraintSetsRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns an array of SqlInjectionMatchSet objects.
 *
 * @sample aws.sdk.kotlin.services.waf.samples.ListSqlInjectionMatchSets.sample
 */
public suspend inline fun WafClient.listSqlInjectionMatchSets(crossinline block: ListSqlInjectionMatchSetsRequest.Builder.() -> Unit): ListSqlInjectionMatchSetsResponse = listSqlInjectionMatchSets(ListSqlInjectionMatchSetsRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns an array of RuleGroup objects that you are subscribed to.
 */
public suspend inline fun WafClient.listSubscribedRuleGroups(crossinline block: ListSubscribedRuleGroupsRequest.Builder.() -> Unit): ListSubscribedRuleGroupsResponse = listSubscribedRuleGroups(ListSubscribedRuleGroupsRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Retrieves the tags associated with the specified AWS resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each AWS resource, up to 50 tags for a resource.
 *
 * Tagging is only available through the API, SDKs, and CLI. You can't manage or view tags through the AWS WAF Classic console. You can tag the AWS resources that you manage through AWS WAF Classic: web ACLs, rule groups, and rules.
 */
public suspend inline fun WafClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns an array of WebACLSummary objects in the response.
 *
 * @sample aws.sdk.kotlin.services.waf.samples.ListWebACLs.sample
 */
public suspend inline fun WafClient.listWebAcls(crossinline block: ListWebAclsRequest.Builder.() -> Unit): ListWebAclsResponse = listWebAcls(ListWebAclsRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returns an array of XssMatchSet objects.
 *
 * @sample aws.sdk.kotlin.services.waf.samples.ListXssMatchSets.sample
 */
public suspend inline fun WafClient.listXssMatchSets(crossinline block: ListXssMatchSetsRequest.Builder.() -> Unit): ListXssMatchSetsResponse = listXssMatchSets(ListXssMatchSetsRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Associates a LoggingConfiguration with a specified web ACL.
 *
 * You can access information about all traffic that AWS WAF inspects using the following steps:
 * + Create an Amazon Kinesis Data Firehose. Create the data firehose with a PUT source and in the region that you are operating. However, if you are capturing logs for Amazon CloudFront, always create the firehose in US East (N. Virginia). Do not create the data firehose using a `Kinesis stream` as your source.
 * + Associate that firehose to your web ACL using a `PutLoggingConfiguration` request.
 *
 * When you successfully enable logging using a `PutLoggingConfiguration` request, AWS WAF will create a service linked role with the necessary permissions to write logs to the Amazon Kinesis Data Firehose. For more information, see [Logging Web ACL Traffic Information](https://docs.aws.amazon.com/waf/latest/developerguide/logging.html) in the *AWS WAF Developer Guide*.
 */
public suspend inline fun WafClient.putLoggingConfiguration(crossinline block: PutLoggingConfigurationRequest.Builder.() -> Unit): PutLoggingConfigurationResponse = putLoggingConfiguration(PutLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Attaches an IAM policy to the specified resource. The only supported use for this action is to share a RuleGroup across accounts.
 *
 * The `PutPermissionPolicy` is subject to the following restrictions:
 * + You can attach only one policy with each `PutPermissionPolicy` request.
 * + The policy must include an `Effect`, `Action` and `Principal`.
 * + `Effect` must specify `Allow`.
 * + The `Action` in the policy must be `waf:UpdateWebACL`, `waf-regional:UpdateWebACL`, `waf:GetRuleGroup` and `waf-regional:GetRuleGroup` . Any extra or wildcard actions in the policy will be rejected.
 * + The policy cannot include a `Resource` parameter.
 * + The ARN in the request must be a valid WAF RuleGroup ARN and the RuleGroup must exist in the same region.
 * + The user making the request must be the owner of the RuleGroup.
 * + Your policy must be composed using IAM Policy version 2012-10-17.
 *
 * For more information, see [IAM Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html).
 *
 * An example of a valid policy parameter is shown in the Examples section below.
 */
public suspend inline fun WafClient.putPermissionPolicy(crossinline block: PutPermissionPolicyRequest.Builder.() -> Unit): PutPermissionPolicyResponse = putPermissionPolicy(PutPermissionPolicyRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Associates tags with the specified AWS resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each AWS resource, up to 50 tags for a resource.
 *
 * Tagging is only available through the API, SDKs, and CLI. You can't manage or view tags through the AWS WAF Classic console. You can use this action to tag the AWS resources that you manage through AWS WAF Classic: web ACLs, rule groups, and rules.
 */
public suspend inline fun WafClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 */
public suspend inline fun WafClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Inserts or deletes ByteMatchTuple objects (filters) in a ByteMatchSet. For each `ByteMatchTuple` object, you specify the following values:
 * + Whether to insert or delete the object from the array. If you want to change a `ByteMatchSetUpdate` object, you delete the existing object and add a new one.
 * + The part of a web request that you want AWS WAF to inspect, such as a query string or the value of the `User-Agent` header.
 * + The bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to look for. For more information, including how you specify the values for the AWS WAF API and the AWS CLI or SDKs, see `TargetString` in the ByteMatchTuple data type.
 * + Where to look, such as at the beginning or the end of a query string.
 * + Whether to perform any conversions on the request, such as converting it to lowercase, before inspecting it for the specified string.
 *
 * For example, you can add a `ByteMatchSetUpdate` object that matches web requests in which `User-Agent` headers contain the string `BadBot`. You can then configure AWS WAF to block those requests.
 *
 * To create and configure a `ByteMatchSet`, perform the following steps:
 * + Create a `ByteMatchSet.` For more information, see CreateByteMatchSet.
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of an `UpdateByteMatchSet` request.
 * + Submit an `UpdateByteMatchSet` request to specify the part of the request that you want AWS WAF to inspect (for example, the header or the URI) and the value that you want AWS WAF to watch for.
 *
 * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
 *
 * @sample aws.sdk.kotlin.services.waf.samples.UpdateByteMatchSet.sample
 */
public suspend inline fun WafClient.updateByteMatchSet(crossinline block: UpdateByteMatchSetRequest.Builder.() -> Unit): UpdateByteMatchSetResponse = updateByteMatchSet(UpdateByteMatchSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Inserts or deletes GeoMatchConstraint objects in an `GeoMatchSet`. For each `GeoMatchConstraint` object, you specify the following values:
 * + Whether to insert or delete the object from the array. If you want to change an `GeoMatchConstraint` object, you delete the existing object and add a new one.
 * + The `Type`. The only valid value for `Type` is `Country`.
 * + The `Value`, which is a two character code for the country to add to the `GeoMatchConstraint` object. Valid codes are listed in GeoMatchConstraint$Value.
 *
 * To create and configure an `GeoMatchSet`, perform the following steps:
 * + Submit a CreateGeoMatchSet request.
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of an UpdateGeoMatchSet request.
 * + Submit an `UpdateGeoMatchSet` request to specify the country that you want AWS WAF to watch for.
 *
 * When you update an `GeoMatchSet`, you specify the country that you want to add and/or the country that you want to delete. If you want to change a country, you delete the existing country and add the new one.
 *
 * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
 */
public suspend inline fun WafClient.updateGeoMatchSet(crossinline block: UpdateGeoMatchSetRequest.Builder.() -> Unit): UpdateGeoMatchSetResponse = updateGeoMatchSet(UpdateGeoMatchSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Inserts or deletes IPSetDescriptor objects in an `IPSet`. For each `IPSetDescriptor` object, you specify the following values:
 * + Whether to insert or delete the object from the array. If you want to change an `IPSetDescriptor` object, you delete the existing object and add a new one.
 * + The IP address version, `IPv4` or `IPv6`.
 * + The IP address in CIDR notation, for example, `192.0.2.0/24` (for the range of IP addresses from `192.0.2.0` to `192.0.2.255`) or `192.0.2.44/32` (for the individual IP address `192.0.2.44`).
 *
 * AWS WAF supports IPv4 address ranges: /8 and any range between /16 through /32. AWS WAF supports IPv6 address ranges: /24, /32, /48, /56, /64, and /128. For more information about CIDR notation, see the Wikipedia entry [Classless Inter-Domain Routing](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
 *
 * IPv6 addresses can be represented using any of the following formats:
 * + 1111:0000:0000:0000:0000:0000:0000:0111/128
 * + 1111:0:0:0:0:0:0:0111/128
 * + 1111::0111/128
 * + 1111::111/128
 *
 * You use an `IPSet` to specify which web requests you want to allow or block based on the IP addresses that the requests originated from. For example, if you're receiving a lot of requests from one or a small number of IP addresses and you want to block the requests, you can create an `IPSet` that specifies those IP addresses, and then configure AWS WAF to block the requests.
 *
 * To create and configure an `IPSet`, perform the following steps:
 * + Submit a CreateIPSet request.
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of an UpdateIPSet request.
 * + Submit an `UpdateIPSet` request to specify the IP addresses that you want AWS WAF to watch for.
 *
 * When you update an `IPSet`, you specify the IP addresses that you want to add and/or the IP addresses that you want to delete. If you want to change an IP address, you delete the existing IP address and add the new one.
 *
 * You can insert a maximum of 1000 addresses in a single request.
 *
 * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
 *
 * @sample aws.sdk.kotlin.services.waf.samples.UpdateIPSet.sample
 */
public suspend inline fun WafClient.updateIpSet(crossinline block: UpdateIpSetRequest.Builder.() -> Unit): UpdateIpSetResponse = updateIpSet(UpdateIpSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Inserts or deletes Predicate objects in a rule and updates the `RateLimit` in the rule.
 *
 * Each `Predicate` object identifies a predicate, such as a ByteMatchSet or an IPSet, that specifies the web requests that you want to block or count. The `RateLimit` specifies the number of requests every five minutes that triggers the rule.
 *
 * If you add more than one predicate to a `RateBasedRule`, a request must match all the predicates and exceed the `RateLimit` to be counted or blocked. For example, suppose you add the following to a `RateBasedRule`:
 * + An `IPSet` that matches the IP address `192.0.2.44/32`
 * + A `ByteMatchSet` that matches `BadBot` in the `User-Agent` header
 *
 * Further, you specify a `RateLimit` of 1,000.
 *
 * You then add the `RateBasedRule` to a `WebACL` and specify that you want to block requests that satisfy the rule. For a request to be blocked, it must come from the IP address 192.0.2.44 *and* the `User-Agent` header in the request must contain the value `BadBot`. Further, requests that match these two conditions much be received at a rate of more than 1,000 every five minutes. If the rate drops below this limit, AWS WAF no longer blocks the requests.
 *
 * As a second example, suppose you want to limit requests to a particular page on your site. To do this, you could add the following to a `RateBasedRule`:
 * + A `ByteMatchSet` with `FieldToMatch` of `URI`
 * + A `PositionalConstraint` of `STARTS_WITH`
 * + A `TargetString` of `login`
 *
 * Further, you specify a `RateLimit` of 1,000.
 *
 * By adding this `RateBasedRule` to a `WebACL`, you could limit requests to your login page without affecting the rest of your site.
 */
public suspend inline fun WafClient.updateRateBasedRule(crossinline block: UpdateRateBasedRuleRequest.Builder.() -> Unit): UpdateRateBasedRuleResponse = updateRateBasedRule(UpdateRateBasedRuleRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Inserts or deletes RegexMatchTuple objects (filters) in a RegexMatchSet. For each `RegexMatchSetUpdate` object, you specify the following values:
 * + Whether to insert or delete the object from the array. If you want to change a `RegexMatchSetUpdate` object, you delete the existing object and add a new one.
 * + The part of a web request that you want AWS WAF to inspectupdate, such as a query string or the value of the `User-Agent` header.
 * + The identifier of the pattern (a regular expression) that you want AWS WAF to look for. For more information, see RegexPatternSet.
 * + Whether to perform any conversions on the request, such as converting it to lowercase, before inspecting it for the specified string.
 *
 *  For example, you can create a `RegexPatternSet` that matches any requests with `User-Agent` headers that contain the string `B[a@]dB[o0]t`. You can then configure AWS WAF to reject those requests.
 *
 * To create and configure a `RegexMatchSet`, perform the following steps:
 * + Create a `RegexMatchSet.` For more information, see CreateRegexMatchSet.
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of an `UpdateRegexMatchSet` request.
 * + Submit an `UpdateRegexMatchSet` request to specify the part of the request that you want AWS WAF to inspect (for example, the header or the URI) and the identifier of the `RegexPatternSet` that contain the regular expression patters you want AWS WAF to watch for.
 *
 * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
 */
public suspend inline fun WafClient.updateRegexMatchSet(crossinline block: UpdateRegexMatchSetRequest.Builder.() -> Unit): UpdateRegexMatchSetResponse = updateRegexMatchSet(UpdateRegexMatchSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Inserts or deletes `RegexPatternString` objects in a RegexPatternSet. For each `RegexPatternString` object, you specify the following values:
 * + Whether to insert or delete the `RegexPatternString`.
 * + The regular expression pattern that you want to insert or delete. For more information, see RegexPatternSet.
 *
 *  For example, you can create a `RegexPatternString` such as `B[a@]dB[o0]t`. AWS WAF will match this `RegexPatternString` to:
 * + BadBot
 * + BadB0t
 * + B@dBot
 * + B@dB0t
 *
 * To create and configure a `RegexPatternSet`, perform the following steps:
 * + Create a `RegexPatternSet.` For more information, see CreateRegexPatternSet.
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of an `UpdateRegexPatternSet` request.
 * + Submit an `UpdateRegexPatternSet` request to specify the regular expression pattern that you want AWS WAF to watch for.
 *
 * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
 */
public suspend inline fun WafClient.updateRegexPatternSet(crossinline block: UpdateRegexPatternSetRequest.Builder.() -> Unit): UpdateRegexPatternSetResponse = updateRegexPatternSet(UpdateRegexPatternSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Inserts or deletes Predicate objects in a `Rule`. Each `Predicate` object identifies a predicate, such as a ByteMatchSet or an IPSet, that specifies the web requests that you want to allow, block, or count. If you add more than one predicate to a `Rule`, a request must match all of the specifications to be allowed, blocked, or counted. For example, suppose that you add the following to a `Rule`:
 * + A `ByteMatchSet` that matches the value `BadBot` in the `User-Agent` header
 * + An `IPSet` that matches the IP address `192.0.2.44`
 *
 * You then add the `Rule` to a `WebACL` and specify that you want to block requests that satisfy the `Rule`. For a request to be blocked, the `User-Agent` header in the request must contain the value `BadBot`*and* the request must originate from the IP address 192.0.2.44.
 *
 * To create and configure a `Rule`, perform the following steps:
 * + Create and update the predicates that you want to include in the `Rule`.
 * + Create the `Rule`. See CreateRule.
 * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an UpdateRule request.
 * + Submit an `UpdateRule` request to add predicates to the `Rule`.
 * + Create and update a `WebACL` that contains the `Rule`. See CreateWebACL.
 *
 * If you want to replace one `ByteMatchSet` or `IPSet` with another, you delete the existing one and add the new one.
 *
 * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
 *
 * @sample aws.sdk.kotlin.services.waf.samples.UpdateRule.sample
 */
public suspend inline fun WafClient.updateRule(crossinline block: UpdateRuleRequest.Builder.() -> Unit): UpdateRuleResponse = updateRule(UpdateRuleRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Inserts or deletes ActivatedRule objects in a `RuleGroup`.
 *
 * You can only insert `REGULAR` rules into a rule group.
 *
 * You can have a maximum of ten rules per rule group.
 *
 * To create and configure a `RuleGroup`, perform the following steps:
 * + Create and update the `Rules` that you want to include in the `RuleGroup`. See CreateRule.
 * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an UpdateRuleGroup request.
 * + Submit an `UpdateRuleGroup` request to add `Rules` to the `RuleGroup`.
 * + Create and update a `WebACL` that contains the `RuleGroup`. See CreateWebACL.
 *
 * If you want to replace one `Rule` with another, you delete the existing one and add the new one.
 *
 * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
 */
public suspend inline fun WafClient.updateRuleGroup(crossinline block: UpdateRuleGroupRequest.Builder.() -> Unit): UpdateRuleGroupResponse = updateRuleGroup(UpdateRuleGroupRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Inserts or deletes SizeConstraint objects (filters) in a SizeConstraintSet. For each `SizeConstraint` object, you specify the following values:
 * + Whether to insert or delete the object from the array. If you want to change a `SizeConstraintSetUpdate` object, you delete the existing object and add a new one.
 * + The part of a web request that you want AWS WAF to evaluate, such as the length of a query string or the length of the `User-Agent` header.
 * + Whether to perform any transformations on the request, such as converting it to lowercase, before checking its length. Note that transformations of the request body are not supported because the AWS resource forwards only the first `8192` bytes of your request to AWS WAF.You can only specify a single type of TextTransformation.
 * + A `ComparisonOperator` used for evaluating the selected part of the request against the specified `Size`, such as equals, greater than, less than, and so on.
 * + The length, in bytes, that you want AWS WAF to watch for in selected part of the request. The length is computed after applying the transformation.
 *
 * For example, you can add a `SizeConstraintSetUpdate` object that matches web requests in which the length of the `User-Agent` header is greater than 100 bytes. You can then configure AWS WAF to block those requests.
 *
 * To create and configure a `SizeConstraintSet`, perform the following steps:
 * + Create a `SizeConstraintSet.` For more information, see CreateSizeConstraintSet.
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of an `UpdateSizeConstraintSet` request.
 * + Submit an `UpdateSizeConstraintSet` request to specify the part of the request that you want AWS WAF to inspect (for example, the header or the URI) and the value that you want AWS WAF to watch for.
 *
 * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
 *
 * @sample aws.sdk.kotlin.services.waf.samples.UpdateSizeConstraintSet.sample
 */
public suspend inline fun WafClient.updateSizeConstraintSet(crossinline block: UpdateSizeConstraintSetRequest.Builder.() -> Unit): UpdateSizeConstraintSetResponse = updateSizeConstraintSet(UpdateSizeConstraintSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Inserts or deletes SqlInjectionMatchTuple objects (filters) in a SqlInjectionMatchSet. For each `SqlInjectionMatchTuple` object, you specify the following values:
 * + `Action`: Whether to insert the object into or delete the object from the array. To change a `SqlInjectionMatchTuple`, you delete the existing object and add a new one.
 * + `FieldToMatch`: The part of web requests that you want AWS WAF to inspect and, if you want AWS WAF to inspect a header or custom query parameter, the name of the header or parameter.
 * + `TextTransformation`: Which text transformation, if any, to perform on the web request before inspecting the request for snippets of malicious SQL code.You can only specify a single type of TextTransformation.
 *
 * You use `SqlInjectionMatchSet` objects to specify which CloudFront requests that you want to allow, block, or count. For example, if you're receiving requests that contain snippets of SQL code in the query string and you want to block the requests, you can create a `SqlInjectionMatchSet` with the applicable settings, and then configure AWS WAF to block the requests.
 *
 * To create and configure a `SqlInjectionMatchSet`, perform the following steps:
 * + Submit a CreateSqlInjectionMatchSet request.
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of an UpdateIPSet request.
 * + Submit an `UpdateSqlInjectionMatchSet` request to specify the parts of web requests that you want AWS WAF to inspect for snippets of SQL code.
 *
 * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
 *
 * @sample aws.sdk.kotlin.services.waf.samples.UpdateSqlInjectionMatchSet.sample
 */
public suspend inline fun WafClient.updateSqlInjectionMatchSet(crossinline block: UpdateSqlInjectionMatchSetRequest.Builder.() -> Unit): UpdateSqlInjectionMatchSetResponse = updateSqlInjectionMatchSet(UpdateSqlInjectionMatchSetRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Inserts or deletes ActivatedRule objects in a `WebACL`. Each `Rule` identifies web requests that you want to allow, block, or count. When you update a `WebACL`, you specify the following values:
 * + A default action for the `WebACL`, either `ALLOW` or `BLOCK`. AWS WAF performs the default action if a request doesn't match the criteria in any of the `Rules` in a `WebACL`.
 * + The `Rules` that you want to add or delete. If you want to replace one `Rule` with another, you delete the existing `Rule` and add the new one.
 * + For each `Rule`, whether you want AWS WAF to allow requests, block requests, or count requests that match the conditions in the `Rule`.
 * + The order in which you want AWS WAF to evaluate the `Rules` in a `WebACL`. If you add more than one `Rule` to a `WebACL`, AWS WAF evaluates each request against the `Rules` in order based on the value of `Priority`. (The `Rule` that has the lowest value for `Priority` is evaluated first.) When a web request matches all the predicates (such as `ByteMatchSets` and `IPSets`) in a `Rule`, AWS WAF immediately takes the corresponding action, allow or block, and doesn't evaluate the request against the remaining `Rules` in the `WebACL`, if any.
 *
 * To create and configure a `WebACL`, perform the following steps:
 * + Create and update the predicates that you want to include in `Rules`. For more information, see CreateByteMatchSet, UpdateByteMatchSet, CreateIPSet, UpdateIPSet, CreateSqlInjectionMatchSet, and UpdateSqlInjectionMatchSet.
 * + Create and update the `Rules` that you want to include in the `WebACL`. For more information, see CreateRule and UpdateRule.
 * + Create a `WebACL`. See CreateWebACL.
 * + Use `GetChangeToken` to get the change token that you provide in the `ChangeToken` parameter of an UpdateWebACL request.
 * + Submit an `UpdateWebACL` request to specify the `Rules` that you want to include in the `WebACL`, to specify the default action, and to associate the `WebACL` with a CloudFront distribution. The `ActivatedRule` can be a rule group. If you specify a rule group as your `ActivatedRule` , you can exclude specific rules from that rule group.If you already have a rule group associated with a web ACL and want to submit an `UpdateWebACL` request to exclude certain rules from that rule group, you must first remove the rule group from the web ACL, the re-insert it again, specifying the excluded rules. For details, see ActivatedRule$ExcludedRules .
 *
 * Be aware that if you try to add a RATE_BASED rule to a web ACL without setting the rule type when first creating the rule, the UpdateWebACL request will fail because the request tries to add a REGULAR rule (the default rule type) with the specified ID, which does not exist.
 *
 * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
 *
 * @sample aws.sdk.kotlin.services.waf.samples.UpdateWebACL.sample
 */
public suspend inline fun WafClient.updateWebAcl(crossinline block: UpdateWebAclRequest.Builder.() -> Unit): UpdateWebAclResponse = updateWebAcl(UpdateWebAclRequest.Builder().apply(block).build())

/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Inserts or deletes XssMatchTuple objects (filters) in an XssMatchSet. For each `XssMatchTuple` object, you specify the following values:
 * + `Action`: Whether to insert the object into or delete the object from the array. To change an `XssMatchTuple`, you delete the existing object and add a new one.
 * + `FieldToMatch`: The part of web requests that you want AWS WAF to inspect and, if you want AWS WAF to inspect a header or custom query parameter, the name of the header or parameter.
 * + `TextTransformation`: Which text transformation, if any, to perform on the web request before inspecting the request for cross-site scripting attacks.You can only specify a single type of TextTransformation.
 *
 * You use `XssMatchSet` objects to specify which CloudFront requests that you want to allow, block, or count. For example, if you're receiving requests that contain cross-site scripting attacks in the request body and you want to block the requests, you can create an `XssMatchSet` with the applicable settings, and then configure AWS WAF to block the requests.
 *
 * To create and configure an `XssMatchSet`, perform the following steps:
 * + Submit a CreateXssMatchSet request.
 * + Use GetChangeToken to get the change token that you provide in the `ChangeToken` parameter of an UpdateIPSet request.
 * + Submit an `UpdateXssMatchSet` request to specify the parts of web requests that you want AWS WAF to inspect for cross-site scripting attacks.
 *
 * For more information about how to use the AWS WAF API to allow or block HTTP requests, see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
 *
 * @sample aws.sdk.kotlin.services.waf.samples.UpdateXssMatchSet.sample
 */
public suspend inline fun WafClient.updateXssMatchSet(crossinline block: UpdateXssMatchSetRequest.Builder.() -> Unit): UpdateXssMatchSetResponse = updateXssMatchSet(UpdateXssMatchSetRequest.Builder().apply(block).build())
