// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.waf.model.DeleteRateBasedRuleResponse
import aws.sdk.kotlin.services.waf.model.WafException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteRateBasedRuleOperationDeserializer: HttpDeserialize<DeleteRateBasedRuleResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteRateBasedRuleResponse {
        if (!response.status.isSuccess()) {
            throwDeleteRateBasedRuleError(context, response)
        }
        val builder = DeleteRateBasedRuleResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteRateBasedRuleOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeleteRateBasedRuleError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WafException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "WAFInternalErrorException" -> WafInternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFInvalidAccountException" -> WafInvalidAccountExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFNonEmptyEntityException" -> WafNonEmptyEntityExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFNonexistentItemException" -> WafNonexistentItemExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFReferencedItemException" -> WafReferencedItemExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFStaleDataException" -> WafStaleDataExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFTagOperationException" -> WafTagOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFTagOperationInternalErrorException" -> WafTagOperationInternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WafException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteRateBasedRuleOperationBody(builder: DeleteRateBasedRuleResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CHANGETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChangeToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHANGETOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHANGETOKEN_DESCRIPTOR.index -> builder.changeToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
