// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.waf.model.CreateSqlInjectionMatchSetResponse
import aws.sdk.kotlin.services.waf.model.SqlInjectionMatchSet
import aws.sdk.kotlin.services.waf.model.WafException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateSqlInjectionMatchSetOperationDeserializer: HttpDeserialize<CreateSqlInjectionMatchSetResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateSqlInjectionMatchSetResponse {
        if (!response.status.isSuccess()) {
            throwCreateSqlInjectionMatchSetError(context, response)
        }
        val builder = CreateSqlInjectionMatchSetResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateSqlInjectionMatchSetOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateSqlInjectionMatchSetError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WafException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "WAFDisallowedNameException" -> WafDisallowedNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFInternalErrorException" -> WafInternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFInvalidAccountException" -> WafInvalidAccountExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFInvalidParameterException" -> WafInvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFLimitsExceededException" -> WafLimitsExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFStaleDataException" -> WafStaleDataExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WafException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateSqlInjectionMatchSetOperationBody(builder: CreateSqlInjectionMatchSetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CHANGETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChangeToken"))
    val SQLINJECTIONMATCHSET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SqlInjectionMatchSet"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHANGETOKEN_DESCRIPTOR)
        field(SQLINJECTIONMATCHSET_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHANGETOKEN_DESCRIPTOR.index -> builder.changeToken = deserializeString()
                SQLINJECTIONMATCHSET_DESCRIPTOR.index -> builder.sqlInjectionMatchSet = deserializeSqlInjectionMatchSetDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
