// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.model

import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * The operation failed because AWS WAF didn't recognize a parameter in the request. For example:
 * + You specified an invalid parameter name.
 * + You specified an invalid value.
 * + You tried to update an object (`ByteMatchSet`, `IPSet`, `Rule`, or `WebACL`) using an action other than `INSERT` or `DELETE`.
 * + You tried to create a `WebACL` with a `DefaultAction``Type` other than `ALLOW`, `BLOCK`, or `COUNT`.
 * + You tried to create a `RateBasedRule` with a `RateKey` value other than `IP`.
 * + You tried to update a `WebACL` with a `WafAction``Type` other than `ALLOW`, `BLOCK`, or `COUNT`.
 * + You tried to update a `ByteMatchSet` with a `FieldToMatch``Type` other than HEADER, METHOD, QUERY_STRING, URI, or BODY.
 * + You tried to update a `ByteMatchSet` with a `Field` of `HEADER` but no value for `Data`.
 * + Your request references an ARN that is malformed, or corresponds to a resource with which a web ACL cannot be associated.
 */
public class WafInvalidParameterException private constructor(builder: Builder) : WafException() {

    public val field: aws.sdk.kotlin.services.waf.model.ParameterExceptionField? = builder.field
    public val parameter: kotlin.String? = builder.parameter
    public val reason: aws.sdk.kotlin.services.waf.model.ParameterExceptionReason? = builder.reason

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.waf.model.WafInvalidParameterException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WafInvalidParameterException(")
        append("field=$field,")
        append("parameter=$parameter,")
        append("reason=$reason)")
    }

    override fun hashCode(): kotlin.Int {
        var result = field?.hashCode() ?: 0
        result = 31 * result + (parameter?.hashCode() ?: 0)
        result = 31 * result + (reason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WafInvalidParameterException

        if (field != other.field) return false
        if (parameter != other.parameter) return false
        if (reason != other.reason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.waf.model.WafInvalidParameterException = Builder(this).apply(block).build()

    public class Builder {
        public var field: aws.sdk.kotlin.services.waf.model.ParameterExceptionField? = null
        public var parameter: kotlin.String? = null
        public var reason: aws.sdk.kotlin.services.waf.model.ParameterExceptionReason? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.waf.model.WafInvalidParameterException) : this() {
            this.field = x.field
            this.parameter = x.parameter
            this.reason = x.reason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.waf.model.WafInvalidParameterException = WafInvalidParameterException(this)
    }
}
