// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.model



/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * In an UpdateRegexPatternSet request, `RegexPatternSetUpdate` specifies whether to insert or delete a `RegexPatternString` and includes the settings for the `RegexPatternString`.
 */
public class RegexPatternSetUpdate private constructor(builder: Builder) {
    /**
     * Specifies whether to insert or delete a `RegexPatternString`.
     */
    public val action: aws.sdk.kotlin.services.waf.model.ChangeAction? = builder.action
    /**
     * Specifies the regular expression (regex) pattern that you want AWS WAF to search for, such as `B[a@]dB[o0]t`.
     */
    public val regexPatternString: kotlin.String? = builder.regexPatternString

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.waf.model.RegexPatternSetUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegexPatternSetUpdate(")
        append("action=$action,")
        append("regexPatternString=$regexPatternString)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (regexPatternString?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegexPatternSetUpdate

        if (action != other.action) return false
        if (regexPatternString != other.regexPatternString) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.waf.model.RegexPatternSetUpdate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether to insert or delete a `RegexPatternString`.
         */
        public var action: aws.sdk.kotlin.services.waf.model.ChangeAction? = null
        /**
         * Specifies the regular expression (regex) pattern that you want AWS WAF to search for, such as `B[a@]dB[o0]t`.
         */
        public var regexPatternString: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.waf.model.RegexPatternSetUpdate) : this() {
            this.action = x.action
            this.regexPatternString = x.regexPatternString
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.waf.model.RegexPatternSetUpdate = RegexPatternSetUpdate(this)
    }
}
