// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.model



/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * The `RegexPatternSet` specifies the regular expression (regex) pattern that you want AWS WAF to search for, such as `B[a@]dB[o0]t`. You can then configure AWS WAF to reject those requests.
 */
public class RegexPatternSet private constructor(builder: Builder) {
    /**
     * A friendly name or description of the RegexPatternSet. You can't change `Name` after you create a `RegexPatternSet`.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The identifier for the `RegexPatternSet`. You use `RegexPatternSetId` to get information about a `RegexPatternSet`, update a `RegexPatternSet`, remove a `RegexPatternSet` from a `RegexMatchSet`, and delete a `RegexPatternSet` from AWS WAF.
     *
     * `RegexMatchSetId` is returned by CreateRegexPatternSet and by ListRegexPatternSets.
     */
    public val regexPatternSetId: kotlin.String? = builder.regexPatternSetId
    /**
     * Specifies the regular expression (regex) patterns that you want AWS WAF to search for, such as `B[a@]dB[o0]t`.
     */
    public val regexPatternStrings: List<String>? = builder.regexPatternStrings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.waf.model.RegexPatternSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegexPatternSet(")
        append("name=$name,")
        append("regexPatternSetId=$regexPatternSetId,")
        append("regexPatternStrings=$regexPatternStrings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (regexPatternSetId?.hashCode() ?: 0)
        result = 31 * result + (regexPatternStrings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegexPatternSet

        if (name != other.name) return false
        if (regexPatternSetId != other.regexPatternSetId) return false
        if (regexPatternStrings != other.regexPatternStrings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.waf.model.RegexPatternSet = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A friendly name or description of the RegexPatternSet. You can't change `Name` after you create a `RegexPatternSet`.
         */
        public var name: kotlin.String? = null
        /**
         * The identifier for the `RegexPatternSet`. You use `RegexPatternSetId` to get information about a `RegexPatternSet`, update a `RegexPatternSet`, remove a `RegexPatternSet` from a `RegexMatchSet`, and delete a `RegexPatternSet` from AWS WAF.
         *
         * `RegexMatchSetId` is returned by CreateRegexPatternSet and by ListRegexPatternSets.
         */
        public var regexPatternSetId: kotlin.String? = null
        /**
         * Specifies the regular expression (regex) patterns that you want AWS WAF to search for, such as `B[a@]dB[o0]t`.
         */
        public var regexPatternStrings: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.waf.model.RegexPatternSet) : this() {
            this.name = x.name
            this.regexPatternSetId = x.regexPatternSetId
            this.regexPatternStrings = x.regexPatternStrings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.waf.model.RegexPatternSet = RegexPatternSet(this)
    }
}
