// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.model



/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Specifies the type of update to perform to an IPSet with UpdateIPSet.
 */
public class IpSetUpdate private constructor(builder: Builder) {
    /**
     * Specifies whether to insert or delete an IP address with UpdateIPSet.
     */
    public val action: aws.sdk.kotlin.services.waf.model.ChangeAction? = builder.action
    /**
     * The IP address type (`IPV4` or `IPV6`) and the IP address range (in CIDR notation) that web requests originate from.
     */
    public val ipSetDescriptor: aws.sdk.kotlin.services.waf.model.IpSetDescriptor? = builder.ipSetDescriptor

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.waf.model.IpSetUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IpSetUpdate(")
        append("action=$action,")
        append("ipSetDescriptor=$ipSetDescriptor)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (ipSetDescriptor?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IpSetUpdate

        if (action != other.action) return false
        if (ipSetDescriptor != other.ipSetDescriptor) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.waf.model.IpSetUpdate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether to insert or delete an IP address with UpdateIPSet.
         */
        public var action: aws.sdk.kotlin.services.waf.model.ChangeAction? = null
        /**
         * The IP address type (`IPV4` or `IPV6`) and the IP address range (in CIDR notation) that web requests originate from.
         */
        public var ipSetDescriptor: aws.sdk.kotlin.services.waf.model.IpSetDescriptor? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.waf.model.IpSetUpdate) : this() {
            this.action = x.action
            this.ipSetDescriptor = x.ipSetDescriptor
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.waf.model.IpSetUpdate = IpSetUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.waf.model.IpSetDescriptor] inside the given [block]
         */
        public fun ipSetDescriptor(block: aws.sdk.kotlin.services.waf.model.IpSetDescriptor.Builder.() -> kotlin.Unit) {
            this.ipSetDescriptor = aws.sdk.kotlin.services.waf.model.IpSetDescriptor.invoke(block)
        }
    }
}
