// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.model



/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Contains one or more IP addresses or blocks of IP addresses specified in Classless Inter-Domain Routing (CIDR) notation. AWS WAF supports IPv4 address ranges: /8 and any range between /16 through /32. AWS WAF supports IPv6 address ranges: /24, /32, /48, /56, /64, and /128.
 *
 * To specify an individual IP address, you specify the four-part IP address followed by a `/32`, for example, 192.0.2.0/32. To block a range of IP addresses, you can specify /8 or any range between /16 through /32 (for IPv4) or /24, /32, /48, /56, /64, or /128 (for IPv6). For more information about CIDR notation, see the Wikipedia entry [Classless Inter-Domain Routing](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
 */
public class IpSet private constructor(builder: Builder) {
    /**
     * The IP address type (`IPV4` or `IPV6`) and the IP address range (in CIDR notation) that web requests originate from. If the `WebACL` is associated with a CloudFront distribution and the viewer did not use an HTTP proxy or a load balancer to send the request, this is the value of the c-ip field in the CloudFront access logs.
     */
    public val ipSetDescriptors: List<IpSetDescriptor>? = builder.ipSetDescriptors
    /**
     * The `IPSetId` for an `IPSet`. You use `IPSetId` to get information about an `IPSet` (see GetIPSet), update an `IPSet` (see UpdateIPSet), insert an `IPSet` into a `Rule` or delete one from a `Rule` (see UpdateRule), and delete an `IPSet` from AWS WAF (see DeleteIPSet).
     *
     * `IPSetId` is returned by CreateIPSet and by ListIPSets.
     */
    public val ipSetId: kotlin.String? = builder.ipSetId
    /**
     * A friendly name or description of the IPSet. You can't change the name of an `IPSet` after you create it.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.waf.model.IpSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IpSet(")
        append("ipSetDescriptors=$ipSetDescriptors,")
        append("ipSetId=$ipSetId,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = ipSetDescriptors?.hashCode() ?: 0
        result = 31 * result + (ipSetId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IpSet

        if (ipSetDescriptors != other.ipSetDescriptors) return false
        if (ipSetId != other.ipSetId) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.waf.model.IpSet = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The IP address type (`IPV4` or `IPV6`) and the IP address range (in CIDR notation) that web requests originate from. If the `WebACL` is associated with a CloudFront distribution and the viewer did not use an HTTP proxy or a load balancer to send the request, this is the value of the c-ip field in the CloudFront access logs.
         */
        public var ipSetDescriptors: List<IpSetDescriptor>? = null
        /**
         * The `IPSetId` for an `IPSet`. You use `IPSetId` to get information about an `IPSet` (see GetIPSet), update an `IPSet` (see UpdateIPSet), insert an `IPSet` into a `Rule` or delete one from a `Rule` (see UpdateRule), and delete an `IPSet` from AWS WAF (see DeleteIPSet).
         *
         * `IPSetId` is returned by CreateIPSet and by ListIPSets.
         */
        public var ipSetId: kotlin.String? = null
        /**
         * A friendly name or description of the IPSet. You can't change the name of an `IPSet` after you create it.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.waf.model.IpSet) : this() {
            this.ipSetDescriptors = x.ipSetDescriptors
            this.ipSetId = x.ipSetId
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.waf.model.IpSet = IpSet(this)
    }
}
