// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.model



/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Returned by ListByteMatchSets. Each `ByteMatchSetSummary` object includes the `Name` and `ByteMatchSetId` for one ByteMatchSet.
 */
public class ByteMatchSetSummary private constructor(builder: Builder) {
    /**
     * The `ByteMatchSetId` for a `ByteMatchSet`. You use `ByteMatchSetId` to get information about a `ByteMatchSet`, update a `ByteMatchSet`, remove a `ByteMatchSet` from a `Rule`, and delete a `ByteMatchSet` from AWS WAF.
     *
     * `ByteMatchSetId` is returned by CreateByteMatchSet and by ListByteMatchSets.
     */
    public val byteMatchSetId: kotlin.String? = builder.byteMatchSetId
    /**
     * A friendly name or description of the ByteMatchSet. You can't change `Name` after you create a `ByteMatchSet`.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.waf.model.ByteMatchSetSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ByteMatchSetSummary(")
        append("byteMatchSetId=$byteMatchSetId,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = byteMatchSetId?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ByteMatchSetSummary

        if (byteMatchSetId != other.byteMatchSetId) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.waf.model.ByteMatchSetSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The `ByteMatchSetId` for a `ByteMatchSet`. You use `ByteMatchSetId` to get information about a `ByteMatchSet`, update a `ByteMatchSet`, remove a `ByteMatchSet` from a `Rule`, and delete a `ByteMatchSet` from AWS WAF.
         *
         * `ByteMatchSetId` is returned by CreateByteMatchSet and by ListByteMatchSets.
         */
        public var byteMatchSetId: kotlin.String? = null
        /**
         * A friendly name or description of the ByteMatchSet. You can't change `Name` after you create a `ByteMatchSet`.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.waf.model.ByteMatchSetSummary) : this() {
            this.byteMatchSetId = x.byteMatchSetId
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.waf.model.ByteMatchSetSummary = ByteMatchSetSummary(this)
    }
}
