// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.vpclattice.serde

import aws.sdk.kotlin.services.vpclattice.model.DnsEntry
import aws.sdk.kotlin.services.vpclattice.model.GetServiceNetworkServiceAssociationResponse
import aws.sdk.kotlin.services.vpclattice.model.ServiceNetworkServiceAssociationStatus
import aws.sdk.kotlin.services.vpclattice.model.VpcLatticeException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetServiceNetworkServiceAssociationOperationDeserializer: HttpDeserializer.NonStreaming<GetServiceNetworkServiceAssociationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetServiceNetworkServiceAssociationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetServiceNetworkServiceAssociationError(context, call, payload)
        }
        val builder = GetServiceNetworkServiceAssociationResponse.Builder()

        if (payload != null) {
            deserializeGetServiceNetworkServiceAssociationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetServiceNetworkServiceAssociationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw VpcLatticeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> VpcLatticeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetServiceNetworkServiceAssociationOperationBody(builder: GetServiceNetworkServiceAssociationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("createdBy"))
    val CUSTOMDOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("customDomainName"))
    val DNSENTRY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("dnsEntry"))
    val FAILURECODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("failureCode"))
    val FAILUREMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("failureMessage"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val SERVICEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("serviceArn"))
    val SERVICEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("serviceId"))
    val SERVICENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("serviceName"))
    val SERVICENETWORKARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("serviceNetworkArn"))
    val SERVICENETWORKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("serviceNetworkId"))
    val SERVICENETWORKNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("serviceNetworkName"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(CREATEDBY_DESCRIPTOR)
        field(CUSTOMDOMAINNAME_DESCRIPTOR)
        field(DNSENTRY_DESCRIPTOR)
        field(FAILURECODE_DESCRIPTOR)
        field(FAILUREMESSAGE_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(SERVICEARN_DESCRIPTOR)
        field(SERVICEID_DESCRIPTOR)
        field(SERVICENAME_DESCRIPTOR)
        field(SERVICENETWORKARN_DESCRIPTOR)
        field(SERVICENETWORKID_DESCRIPTOR)
        field(SERVICENETWORKNAME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeInstant(TimestampFormat.ISO_8601)
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeString()
                CUSTOMDOMAINNAME_DESCRIPTOR.index -> builder.customDomainName = deserializeString()
                DNSENTRY_DESCRIPTOR.index -> builder.dnsEntry = deserializeDnsEntryDocument(deserializer)
                FAILURECODE_DESCRIPTOR.index -> builder.failureCode = deserializeString()
                FAILUREMESSAGE_DESCRIPTOR.index -> builder.failureMessage = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                SERVICEARN_DESCRIPTOR.index -> builder.serviceArn = deserializeString()
                SERVICEID_DESCRIPTOR.index -> builder.serviceId = deserializeString()
                SERVICENAME_DESCRIPTOR.index -> builder.serviceName = deserializeString()
                SERVICENETWORKARN_DESCRIPTOR.index -> builder.serviceNetworkArn = deserializeString()
                SERVICENETWORKID_DESCRIPTOR.index -> builder.serviceNetworkId = deserializeString()
                SERVICENETWORKNAME_DESCRIPTOR.index -> builder.serviceNetworkName = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ServiceNetworkServiceAssociationStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
