// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.vpclattice.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information about an association between a service network and a resource configuration.
 */
public class ServiceNetworkResourceAssociationSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the association.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date and time that the association was created, in ISO-8601 format.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The account that created the association.
     */
    public val createdBy: kotlin.String? = builder.createdBy
    /**
     * The DNS entry for the service.
     */
    public val dnsEntry: aws.sdk.kotlin.services.vpclattice.model.DnsEntry? = builder.dnsEntry
    /**
     * The failure code.
     */
    public val failureCode: kotlin.String? = builder.failureCode
    /**
     * The ID of the association between the service network and resource configuration.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Specifies whether the association is managed by Amazon.
     */
    public val isManagedAssociation: kotlin.Boolean? = builder.isManagedAssociation
    /**
     * The private DNS entry for the service.
     */
    public val privateDnsEntry: aws.sdk.kotlin.services.vpclattice.model.DnsEntry? = builder.privateDnsEntry
    /**
     * The Amazon Resource Name (ARN) of the association.
     */
    public val resourceConfigurationArn: kotlin.String? = builder.resourceConfigurationArn
    /**
     * The ID of the resource configuration associated with the service network.
     */
    public val resourceConfigurationId: kotlin.String? = builder.resourceConfigurationId
    /**
     * The name of the resource configuration associated with the service network.
     */
    public val resourceConfigurationName: kotlin.String? = builder.resourceConfigurationName
    /**
     * The Amazon Resource Name (ARN) of the service network associated with the resource configuration.
     */
    public val serviceNetworkArn: kotlin.String? = builder.serviceNetworkArn
    /**
     * The ID of the service network associated with the resource configuration.
     */
    public val serviceNetworkId: kotlin.String? = builder.serviceNetworkId
    /**
     * The name of the service network associated with the resource configuration.
     */
    public val serviceNetworkName: kotlin.String? = builder.serviceNetworkName
    /**
     * The status of the service network associated with the resource configuration.
     */
    public val status: aws.sdk.kotlin.services.vpclattice.model.ServiceNetworkResourceAssociationStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.vpclattice.model.ServiceNetworkResourceAssociationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceNetworkResourceAssociationSummary(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("dnsEntry=$dnsEntry,")
        append("failureCode=$failureCode,")
        append("id=$id,")
        append("isManagedAssociation=$isManagedAssociation,")
        append("privateDnsEntry=$privateDnsEntry,")
        append("resourceConfigurationArn=$resourceConfigurationArn,")
        append("resourceConfigurationId=$resourceConfigurationId,")
        append("resourceConfigurationName=$resourceConfigurationName,")
        append("serviceNetworkArn=$serviceNetworkArn,")
        append("serviceNetworkId=$serviceNetworkId,")
        append("serviceNetworkName=$serviceNetworkName,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (dnsEntry?.hashCode() ?: 0)
        result = 31 * result + (failureCode?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (isManagedAssociation?.hashCode() ?: 0)
        result = 31 * result + (privateDnsEntry?.hashCode() ?: 0)
        result = 31 * result + (resourceConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (resourceConfigurationId?.hashCode() ?: 0)
        result = 31 * result + (resourceConfigurationName?.hashCode() ?: 0)
        result = 31 * result + (serviceNetworkArn?.hashCode() ?: 0)
        result = 31 * result + (serviceNetworkId?.hashCode() ?: 0)
        result = 31 * result + (serviceNetworkName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceNetworkResourceAssociationSummary

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (dnsEntry != other.dnsEntry) return false
        if (failureCode != other.failureCode) return false
        if (id != other.id) return false
        if (isManagedAssociation != other.isManagedAssociation) return false
        if (privateDnsEntry != other.privateDnsEntry) return false
        if (resourceConfigurationArn != other.resourceConfigurationArn) return false
        if (resourceConfigurationId != other.resourceConfigurationId) return false
        if (resourceConfigurationName != other.resourceConfigurationName) return false
        if (serviceNetworkArn != other.serviceNetworkArn) return false
        if (serviceNetworkId != other.serviceNetworkId) return false
        if (serviceNetworkName != other.serviceNetworkName) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.vpclattice.model.ServiceNetworkResourceAssociationSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the association.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time that the association was created, in ISO-8601 format.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The account that created the association.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The DNS entry for the service.
         */
        public var dnsEntry: aws.sdk.kotlin.services.vpclattice.model.DnsEntry? = null
        /**
         * The failure code.
         */
        public var failureCode: kotlin.String? = null
        /**
         * The ID of the association between the service network and resource configuration.
         */
        public var id: kotlin.String? = null
        /**
         * Specifies whether the association is managed by Amazon.
         */
        public var isManagedAssociation: kotlin.Boolean? = null
        /**
         * The private DNS entry for the service.
         */
        public var privateDnsEntry: aws.sdk.kotlin.services.vpclattice.model.DnsEntry? = null
        /**
         * The Amazon Resource Name (ARN) of the association.
         */
        public var resourceConfigurationArn: kotlin.String? = null
        /**
         * The ID of the resource configuration associated with the service network.
         */
        public var resourceConfigurationId: kotlin.String? = null
        /**
         * The name of the resource configuration associated with the service network.
         */
        public var resourceConfigurationName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the service network associated with the resource configuration.
         */
        public var serviceNetworkArn: kotlin.String? = null
        /**
         * The ID of the service network associated with the resource configuration.
         */
        public var serviceNetworkId: kotlin.String? = null
        /**
         * The name of the service network associated with the resource configuration.
         */
        public var serviceNetworkName: kotlin.String? = null
        /**
         * The status of the service network associated with the resource configuration.
         */
        public var status: aws.sdk.kotlin.services.vpclattice.model.ServiceNetworkResourceAssociationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.vpclattice.model.ServiceNetworkResourceAssociationSummary) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.dnsEntry = x.dnsEntry
            this.failureCode = x.failureCode
            this.id = x.id
            this.isManagedAssociation = x.isManagedAssociation
            this.privateDnsEntry = x.privateDnsEntry
            this.resourceConfigurationArn = x.resourceConfigurationArn
            this.resourceConfigurationId = x.resourceConfigurationId
            this.resourceConfigurationName = x.resourceConfigurationName
            this.serviceNetworkArn = x.serviceNetworkArn
            this.serviceNetworkId = x.serviceNetworkId
            this.serviceNetworkName = x.serviceNetworkName
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.vpclattice.model.ServiceNetworkResourceAssociationSummary = ServiceNetworkResourceAssociationSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.vpclattice.model.DnsEntry] inside the given [block]
         */
        public fun dnsEntry(block: aws.sdk.kotlin.services.vpclattice.model.DnsEntry.Builder.() -> kotlin.Unit) {
            this.dnsEntry = aws.sdk.kotlin.services.vpclattice.model.DnsEntry.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.vpclattice.model.DnsEntry] inside the given [block]
         */
        public fun privateDnsEntry(block: aws.sdk.kotlin.services.vpclattice.model.DnsEntry.Builder.() -> kotlin.Unit) {
            this.privateDnsEntry = aws.sdk.kotlin.services.vpclattice.model.DnsEntry.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
