// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.vpclattice.serde

import aws.sdk.kotlin.services.vpclattice.model.CreateResourceConfigurationResponse
import aws.sdk.kotlin.services.vpclattice.model.ProtocolType
import aws.sdk.kotlin.services.vpclattice.model.ResourceConfigurationDefinition
import aws.sdk.kotlin.services.vpclattice.model.ResourceConfigurationStatus
import aws.sdk.kotlin.services.vpclattice.model.ResourceConfigurationType
import aws.sdk.kotlin.services.vpclattice.model.VpcLatticeException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class CreateResourceConfigurationOperationDeserializer: HttpDeserializer.NonStreaming<CreateResourceConfigurationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateResourceConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateResourceConfigurationError(context, call, payload)
        }
        val builder = CreateResourceConfigurationResponse.Builder()

        if (payload != null) {
            deserializeCreateResourceConfigurationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateResourceConfigurationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw VpcLatticeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> VpcLatticeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateResourceConfigurationOperationBody(builder: CreateResourceConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALLOWASSOCIATIONTOSHAREABLESERVICENETWORK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("allowAssociationToShareableServiceNetwork"))
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("failureReason"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val PORTRANGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("portRanges"))
    val PROTOCOL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("protocol"))
    val RESOURCECONFIGURATIONDEFINITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("resourceConfigurationDefinition"))
    val RESOURCECONFIGURATIONGROUPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("resourceConfigurationGroupId"))
    val RESOURCEGATEWAYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("resourceGatewayId"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALLOWASSOCIATIONTOSHAREABLESERVICENETWORK_DESCRIPTOR)
        field(ARN_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PORTRANGES_DESCRIPTOR)
        field(PROTOCOL_DESCRIPTOR)
        field(RESOURCECONFIGURATIONDEFINITION_DESCRIPTOR)
        field(RESOURCECONFIGURATIONGROUPID_DESCRIPTOR)
        field(RESOURCEGATEWAYID_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALLOWASSOCIATIONTOSHAREABLESERVICENETWORK_DESCRIPTOR.index -> builder.allowAssociationToShareableServiceNetwork = deserializeBoolean()
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeInstant(TimestampFormat.ISO_8601)
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PORTRANGES_DESCRIPTOR.index -> builder.portRanges =
                    deserializer.deserializeList(PORTRANGES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PROTOCOL_DESCRIPTOR.index -> builder.protocol = deserializeString().let { ProtocolType.fromValue(it) }
                RESOURCECONFIGURATIONDEFINITION_DESCRIPTOR.index -> builder.resourceConfigurationDefinition = deserializeResourceConfigurationDefinitionDocument(deserializer)
                RESOURCECONFIGURATIONGROUPID_DESCRIPTOR.index -> builder.resourceConfigurationGroupId = deserializeString()
                RESOURCEGATEWAYID_DESCRIPTOR.index -> builder.resourceGatewayId = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ResourceConfigurationStatus.fromValue(it) }
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { ResourceConfigurationType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
