// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.vpclattice.paginators

import aws.sdk.kotlin.services.vpclattice.VpcLatticeClient
import aws.sdk.kotlin.services.vpclattice.model.AccessLogSubscriptionSummary
import aws.sdk.kotlin.services.vpclattice.model.ListAccessLogSubscriptionsRequest
import aws.sdk.kotlin.services.vpclattice.model.ListAccessLogSubscriptionsResponse
import aws.sdk.kotlin.services.vpclattice.model.ListListenersRequest
import aws.sdk.kotlin.services.vpclattice.model.ListListenersResponse
import aws.sdk.kotlin.services.vpclattice.model.ListResourceConfigurationsRequest
import aws.sdk.kotlin.services.vpclattice.model.ListResourceConfigurationsResponse
import aws.sdk.kotlin.services.vpclattice.model.ListResourceEndpointAssociationsRequest
import aws.sdk.kotlin.services.vpclattice.model.ListResourceEndpointAssociationsResponse
import aws.sdk.kotlin.services.vpclattice.model.ListResourceGatewaysRequest
import aws.sdk.kotlin.services.vpclattice.model.ListResourceGatewaysResponse
import aws.sdk.kotlin.services.vpclattice.model.ListRulesRequest
import aws.sdk.kotlin.services.vpclattice.model.ListRulesResponse
import aws.sdk.kotlin.services.vpclattice.model.ListServiceNetworkResourceAssociationsRequest
import aws.sdk.kotlin.services.vpclattice.model.ListServiceNetworkResourceAssociationsResponse
import aws.sdk.kotlin.services.vpclattice.model.ListServiceNetworkServiceAssociationsRequest
import aws.sdk.kotlin.services.vpclattice.model.ListServiceNetworkServiceAssociationsResponse
import aws.sdk.kotlin.services.vpclattice.model.ListServiceNetworkVpcAssociationsRequest
import aws.sdk.kotlin.services.vpclattice.model.ListServiceNetworkVpcAssociationsResponse
import aws.sdk.kotlin.services.vpclattice.model.ListServiceNetworkVpcEndpointAssociationsRequest
import aws.sdk.kotlin.services.vpclattice.model.ListServiceNetworkVpcEndpointAssociationsResponse
import aws.sdk.kotlin.services.vpclattice.model.ListServiceNetworksRequest
import aws.sdk.kotlin.services.vpclattice.model.ListServiceNetworksResponse
import aws.sdk.kotlin.services.vpclattice.model.ListServicesRequest
import aws.sdk.kotlin.services.vpclattice.model.ListServicesResponse
import aws.sdk.kotlin.services.vpclattice.model.ListTargetGroupsRequest
import aws.sdk.kotlin.services.vpclattice.model.ListTargetGroupsResponse
import aws.sdk.kotlin.services.vpclattice.model.ListTargetsRequest
import aws.sdk.kotlin.services.vpclattice.model.ListTargetsResponse
import aws.sdk.kotlin.services.vpclattice.model.ListenerSummary
import aws.sdk.kotlin.services.vpclattice.model.ResourceConfigurationSummary
import aws.sdk.kotlin.services.vpclattice.model.ResourceEndpointAssociationSummary
import aws.sdk.kotlin.services.vpclattice.model.ResourceGatewaySummary
import aws.sdk.kotlin.services.vpclattice.model.RuleSummary
import aws.sdk.kotlin.services.vpclattice.model.ServiceNetworkEndpointAssociation
import aws.sdk.kotlin.services.vpclattice.model.ServiceNetworkResourceAssociationSummary
import aws.sdk.kotlin.services.vpclattice.model.ServiceNetworkServiceAssociationSummary
import aws.sdk.kotlin.services.vpclattice.model.ServiceNetworkSummary
import aws.sdk.kotlin.services.vpclattice.model.ServiceNetworkVpcAssociationSummary
import aws.sdk.kotlin.services.vpclattice.model.ServiceSummary
import aws.sdk.kotlin.services.vpclattice.model.TargetGroupSummary
import aws.sdk.kotlin.services.vpclattice.model.TargetSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAccessLogSubscriptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccessLogSubscriptionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessLogSubscriptionsResponse]
 */
public fun VpcLatticeClient.listAccessLogSubscriptionsPaginated(initialRequest: ListAccessLogSubscriptionsRequest): Flow<ListAccessLogSubscriptionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccessLogSubscriptionsPaginated.listAccessLogSubscriptions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAccessLogSubscriptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessLogSubscriptionsResponse]
 */
public fun VpcLatticeClient.listAccessLogSubscriptionsPaginated(block: ListAccessLogSubscriptionsRequest.Builder.() -> Unit): Flow<ListAccessLogSubscriptionsResponse> =
    listAccessLogSubscriptionsPaginated(ListAccessLogSubscriptionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAccessLogSubscriptionsPaginated]
 * to access the nested member [AccessLogSubscriptionSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AccessLogSubscriptionSummary]
 */
@JvmName("listAccessLogSubscriptionsResponseAccessLogSubscriptionSummary")
public fun Flow<ListAccessLogSubscriptionsResponse>.items(): Flow<AccessLogSubscriptionSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListListenersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListListenersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListListenersResponse]
 */
public fun VpcLatticeClient.listListenersPaginated(initialRequest: ListListenersRequest): Flow<ListListenersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listListenersPaginated.listListeners(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListListenersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListListenersResponse]
 */
public fun VpcLatticeClient.listListenersPaginated(block: ListListenersRequest.Builder.() -> Unit): Flow<ListListenersResponse> =
    listListenersPaginated(ListListenersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listListenersPaginated]
 * to access the nested member [ListenerSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListenerSummary]
 */
@JvmName("listListenersResponseListenerSummary")
public fun Flow<ListListenersResponse>.items(): Flow<ListenerSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListResourceConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResourceConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourceConfigurationsResponse]
 */
public fun VpcLatticeClient.listResourceConfigurationsPaginated(initialRequest: ListResourceConfigurationsRequest = ListResourceConfigurationsRequest { }): Flow<ListResourceConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResourceConfigurationsPaginated.listResourceConfigurations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListResourceConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourceConfigurationsResponse]
 */
public fun VpcLatticeClient.listResourceConfigurationsPaginated(block: ListResourceConfigurationsRequest.Builder.() -> Unit): Flow<ListResourceConfigurationsResponse> =
    listResourceConfigurationsPaginated(ListResourceConfigurationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listResourceConfigurationsPaginated]
 * to access the nested member [ResourceConfigurationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ResourceConfigurationSummary]
 */
@JvmName("listResourceConfigurationsResponseResourceConfigurationSummary")
public fun Flow<ListResourceConfigurationsResponse>.items(): Flow<ResourceConfigurationSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListResourceEndpointAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResourceEndpointAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourceEndpointAssociationsResponse]
 */
public fun VpcLatticeClient.listResourceEndpointAssociationsPaginated(initialRequest: ListResourceEndpointAssociationsRequest): Flow<ListResourceEndpointAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResourceEndpointAssociationsPaginated.listResourceEndpointAssociations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListResourceEndpointAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourceEndpointAssociationsResponse]
 */
public fun VpcLatticeClient.listResourceEndpointAssociationsPaginated(block: ListResourceEndpointAssociationsRequest.Builder.() -> Unit): Flow<ListResourceEndpointAssociationsResponse> =
    listResourceEndpointAssociationsPaginated(ListResourceEndpointAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listResourceEndpointAssociationsPaginated]
 * to access the nested member [ResourceEndpointAssociationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ResourceEndpointAssociationSummary]
 */
@JvmName("listResourceEndpointAssociationsResponseResourceEndpointAssociationSummary")
public fun Flow<ListResourceEndpointAssociationsResponse>.items(): Flow<ResourceEndpointAssociationSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListResourceGatewaysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResourceGatewaysRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourceGatewaysResponse]
 */
public fun VpcLatticeClient.listResourceGatewaysPaginated(initialRequest: ListResourceGatewaysRequest = ListResourceGatewaysRequest { }): Flow<ListResourceGatewaysResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResourceGatewaysPaginated.listResourceGateways(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListResourceGatewaysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourceGatewaysResponse]
 */
public fun VpcLatticeClient.listResourceGatewaysPaginated(block: ListResourceGatewaysRequest.Builder.() -> Unit): Flow<ListResourceGatewaysResponse> =
    listResourceGatewaysPaginated(ListResourceGatewaysRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listResourceGatewaysPaginated]
 * to access the nested member [ResourceGatewaySummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ResourceGatewaySummary]
 */
@JvmName("listResourceGatewaysResponseResourceGatewaySummary")
public fun Flow<ListResourceGatewaysResponse>.items(): Flow<ResourceGatewaySummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRulesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRulesResponse]
 */
public fun VpcLatticeClient.listRulesPaginated(initialRequest: ListRulesRequest): Flow<ListRulesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRulesPaginated.listRules(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRulesResponse]
 */
public fun VpcLatticeClient.listRulesPaginated(block: ListRulesRequest.Builder.() -> Unit): Flow<ListRulesResponse> =
    listRulesPaginated(ListRulesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRulesPaginated]
 * to access the nested member [RuleSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RuleSummary]
 */
@JvmName("listRulesResponseRuleSummary")
public fun Flow<ListRulesResponse>.items(): Flow<RuleSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListServiceNetworkResourceAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListServiceNetworkResourceAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServiceNetworkResourceAssociationsResponse]
 */
public fun VpcLatticeClient.listServiceNetworkResourceAssociationsPaginated(initialRequest: ListServiceNetworkResourceAssociationsRequest = ListServiceNetworkResourceAssociationsRequest { }): Flow<ListServiceNetworkResourceAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listServiceNetworkResourceAssociationsPaginated.listServiceNetworkResourceAssociations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListServiceNetworkResourceAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServiceNetworkResourceAssociationsResponse]
 */
public fun VpcLatticeClient.listServiceNetworkResourceAssociationsPaginated(block: ListServiceNetworkResourceAssociationsRequest.Builder.() -> Unit): Flow<ListServiceNetworkResourceAssociationsResponse> =
    listServiceNetworkResourceAssociationsPaginated(ListServiceNetworkResourceAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listServiceNetworkResourceAssociationsPaginated]
 * to access the nested member [ServiceNetworkResourceAssociationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ServiceNetworkResourceAssociationSummary]
 */
@JvmName("listServiceNetworkResourceAssociationsResponseServiceNetworkResourceAssociationSummary")
public fun Flow<ListServiceNetworkResourceAssociationsResponse>.items(): Flow<ServiceNetworkResourceAssociationSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListServiceNetworksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListServiceNetworksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServiceNetworksResponse]
 */
public fun VpcLatticeClient.listServiceNetworksPaginated(initialRequest: ListServiceNetworksRequest = ListServiceNetworksRequest { }): Flow<ListServiceNetworksResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listServiceNetworksPaginated.listServiceNetworks(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListServiceNetworksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServiceNetworksResponse]
 */
public fun VpcLatticeClient.listServiceNetworksPaginated(block: ListServiceNetworksRequest.Builder.() -> Unit): Flow<ListServiceNetworksResponse> =
    listServiceNetworksPaginated(ListServiceNetworksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listServiceNetworksPaginated]
 * to access the nested member [ServiceNetworkSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ServiceNetworkSummary]
 */
@JvmName("listServiceNetworksResponseServiceNetworkSummary")
public fun Flow<ListServiceNetworksResponse>.items(): Flow<ServiceNetworkSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListServiceNetworkServiceAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListServiceNetworkServiceAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServiceNetworkServiceAssociationsResponse]
 */
public fun VpcLatticeClient.listServiceNetworkServiceAssociationsPaginated(initialRequest: ListServiceNetworkServiceAssociationsRequest = ListServiceNetworkServiceAssociationsRequest { }): Flow<ListServiceNetworkServiceAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listServiceNetworkServiceAssociationsPaginated.listServiceNetworkServiceAssociations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListServiceNetworkServiceAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServiceNetworkServiceAssociationsResponse]
 */
public fun VpcLatticeClient.listServiceNetworkServiceAssociationsPaginated(block: ListServiceNetworkServiceAssociationsRequest.Builder.() -> Unit): Flow<ListServiceNetworkServiceAssociationsResponse> =
    listServiceNetworkServiceAssociationsPaginated(ListServiceNetworkServiceAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listServiceNetworkServiceAssociationsPaginated]
 * to access the nested member [ServiceNetworkServiceAssociationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ServiceNetworkServiceAssociationSummary]
 */
@JvmName("listServiceNetworkServiceAssociationsResponseServiceNetworkServiceAssociationSummary")
public fun Flow<ListServiceNetworkServiceAssociationsResponse>.items(): Flow<ServiceNetworkServiceAssociationSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListServiceNetworkVpcAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListServiceNetworkVpcAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServiceNetworkVpcAssociationsResponse]
 */
public fun VpcLatticeClient.listServiceNetworkVpcAssociationsPaginated(initialRequest: ListServiceNetworkVpcAssociationsRequest = ListServiceNetworkVpcAssociationsRequest { }): Flow<ListServiceNetworkVpcAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listServiceNetworkVpcAssociationsPaginated.listServiceNetworkVpcAssociations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListServiceNetworkVpcAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServiceNetworkVpcAssociationsResponse]
 */
public fun VpcLatticeClient.listServiceNetworkVpcAssociationsPaginated(block: ListServiceNetworkVpcAssociationsRequest.Builder.() -> Unit): Flow<ListServiceNetworkVpcAssociationsResponse> =
    listServiceNetworkVpcAssociationsPaginated(ListServiceNetworkVpcAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listServiceNetworkVpcAssociationsPaginated]
 * to access the nested member [ServiceNetworkVpcAssociationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ServiceNetworkVpcAssociationSummary]
 */
@JvmName("listServiceNetworkVpcAssociationsResponseServiceNetworkVpcAssociationSummary")
public fun Flow<ListServiceNetworkVpcAssociationsResponse>.items(): Flow<ServiceNetworkVpcAssociationSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListServiceNetworkVpcEndpointAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListServiceNetworkVpcEndpointAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServiceNetworkVpcEndpointAssociationsResponse]
 */
public fun VpcLatticeClient.listServiceNetworkVpcEndpointAssociationsPaginated(initialRequest: ListServiceNetworkVpcEndpointAssociationsRequest): Flow<ListServiceNetworkVpcEndpointAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listServiceNetworkVpcEndpointAssociationsPaginated.listServiceNetworkVpcEndpointAssociations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListServiceNetworkVpcEndpointAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServiceNetworkVpcEndpointAssociationsResponse]
 */
public fun VpcLatticeClient.listServiceNetworkVpcEndpointAssociationsPaginated(block: ListServiceNetworkVpcEndpointAssociationsRequest.Builder.() -> Unit): Flow<ListServiceNetworkVpcEndpointAssociationsResponse> =
    listServiceNetworkVpcEndpointAssociationsPaginated(ListServiceNetworkVpcEndpointAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listServiceNetworkVpcEndpointAssociationsPaginated]
 * to access the nested member [ServiceNetworkEndpointAssociation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ServiceNetworkEndpointAssociation]
 */
@JvmName("listServiceNetworkVpcEndpointAssociationsResponseServiceNetworkEndpointAssociation")
public fun Flow<ListServiceNetworkVpcEndpointAssociationsResponse>.items(): Flow<ServiceNetworkEndpointAssociation> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListServicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListServicesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServicesResponse]
 */
public fun VpcLatticeClient.listServicesPaginated(initialRequest: ListServicesRequest = ListServicesRequest { }): Flow<ListServicesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listServicesPaginated.listServices(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListServicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServicesResponse]
 */
public fun VpcLatticeClient.listServicesPaginated(block: ListServicesRequest.Builder.() -> Unit): Flow<ListServicesResponse> =
    listServicesPaginated(ListServicesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listServicesPaginated]
 * to access the nested member [ServiceSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ServiceSummary]
 */
@JvmName("listServicesResponseServiceSummary")
public fun Flow<ListServicesResponse>.items(): Flow<ServiceSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTargetGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTargetGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTargetGroupsResponse]
 */
public fun VpcLatticeClient.listTargetGroupsPaginated(initialRequest: ListTargetGroupsRequest = ListTargetGroupsRequest { }): Flow<ListTargetGroupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTargetGroupsPaginated.listTargetGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTargetGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTargetGroupsResponse]
 */
public fun VpcLatticeClient.listTargetGroupsPaginated(block: ListTargetGroupsRequest.Builder.() -> Unit): Flow<ListTargetGroupsResponse> =
    listTargetGroupsPaginated(ListTargetGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTargetGroupsPaginated]
 * to access the nested member [TargetGroupSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TargetGroupSummary]
 */
@JvmName("listTargetGroupsResponseTargetGroupSummary")
public fun Flow<ListTargetGroupsResponse>.items(): Flow<TargetGroupSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTargetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTargetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTargetsResponse]
 */
public fun VpcLatticeClient.listTargetsPaginated(initialRequest: ListTargetsRequest): Flow<ListTargetsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTargetsPaginated.listTargets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTargetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTargetsResponse]
 */
public fun VpcLatticeClient.listTargetsPaginated(block: ListTargetsRequest.Builder.() -> Unit): Flow<ListTargetsResponse> =
    listTargetsPaginated(ListTargetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTargetsPaginated]
 * to access the nested member [TargetSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TargetSummary]
 */
@JvmName("listTargetsResponseTargetSummary")
public fun Flow<ListTargetsResponse>.items(): Flow<TargetSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }
