// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.vpclattice.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information about a resource configuration.
 */
public class ResourceConfigurationSummary private constructor(builder: Builder) {
    /**
     * Indicates whether the resource configuration was created and is managed by Amazon.
     */
    public val amazonManaged: kotlin.Boolean? = builder.amazonManaged
    /**
     * The Amazon Resource Name (ARN) of the resource configuration.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date and time that the resource configuration was created, in ISO-8601 format.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The ID of the resource configuration.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The most recent date and time that the resource configuration was updated, in ISO-8601 format.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The name of the resource configuration.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ID of the group resource configuration.
     */
    public val resourceConfigurationGroupId: kotlin.String? = builder.resourceConfigurationGroupId
    /**
     * The ID of the resource gateway.
     */
    public val resourceGatewayId: kotlin.String? = builder.resourceGatewayId
    /**
     * The status of the resource configuration.
     */
    public val status: aws.sdk.kotlin.services.vpclattice.model.ResourceConfigurationStatus? = builder.status
    /**
     * The type of resource configuration.
     * + `SINGLE` - A single resource.
     * + `GROUP` - A group of resources.
     * + `CHILD` - A single resource that is part of a group resource configuration.
     * + `ARN` - An Amazon Web Services resource.
     */
    public val type: aws.sdk.kotlin.services.vpclattice.model.ResourceConfigurationType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.vpclattice.model.ResourceConfigurationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceConfigurationSummary(")
        append("amazonManaged=$amazonManaged,")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("id=$id,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("name=$name,")
        append("resourceConfigurationGroupId=$resourceConfigurationGroupId,")
        append("resourceGatewayId=$resourceGatewayId,")
        append("status=$status,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = amazonManaged?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceConfigurationGroupId?.hashCode() ?: 0)
        result = 31 * result + (resourceGatewayId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceConfigurationSummary

        if (amazonManaged != other.amazonManaged) return false
        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (id != other.id) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (name != other.name) return false
        if (resourceConfigurationGroupId != other.resourceConfigurationGroupId) return false
        if (resourceGatewayId != other.resourceGatewayId) return false
        if (status != other.status) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.vpclattice.model.ResourceConfigurationSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether the resource configuration was created and is managed by Amazon.
         */
        public var amazonManaged: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the resource configuration.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time that the resource configuration was created, in ISO-8601 format.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the resource configuration.
         */
        public var id: kotlin.String? = null
        /**
         * The most recent date and time that the resource configuration was updated, in ISO-8601 format.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the resource configuration.
         */
        public var name: kotlin.String? = null
        /**
         * The ID of the group resource configuration.
         */
        public var resourceConfigurationGroupId: kotlin.String? = null
        /**
         * The ID of the resource gateway.
         */
        public var resourceGatewayId: kotlin.String? = null
        /**
         * The status of the resource configuration.
         */
        public var status: aws.sdk.kotlin.services.vpclattice.model.ResourceConfigurationStatus? = null
        /**
         * The type of resource configuration.
         * + `SINGLE` - A single resource.
         * + `GROUP` - A group of resources.
         * + `CHILD` - A single resource that is part of a group resource configuration.
         * + `ARN` - An Amazon Web Services resource.
         */
        public var type: aws.sdk.kotlin.services.vpclattice.model.ResourceConfigurationType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.vpclattice.model.ResourceConfigurationSummary) : this() {
            this.amazonManaged = x.amazonManaged
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.id = x.id
            this.lastUpdatedAt = x.lastUpdatedAt
            this.name = x.name
            this.resourceConfigurationGroupId = x.resourceConfigurationGroupId
            this.resourceGatewayId = x.resourceGatewayId
            this.status = x.status
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.vpclattice.model.ResourceConfigurationSummary = ResourceConfigurationSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
