// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.vpclattice.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateServiceNetworkVpcAssociationRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a request that completed successfully using the same client token and parameters, the retry succeeds without performing any actions. If the parameters aren't identical, the retry fails.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The IDs of the security groups. Security groups aren't added by default. You can add a security group to apply network level controls to control which resources in a VPC are allowed to access the service network and its services. For more information, see [Control traffic to resources using security groups](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html) in the *Amazon VPC User Guide*.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The ID or ARN of the service network. You must use an ARN if the resources are in different accounts.
     */
    public val serviceNetworkIdentifier: kotlin.String = requireNotNull(builder.serviceNetworkIdentifier) { "A non-null value must be provided for serviceNetworkIdentifier" }
    /**
     * The tags for the association.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The ID of the VPC.
     */
    public val vpcIdentifier: kotlin.String = requireNotNull(builder.vpcIdentifier) { "A non-null value must be provided for vpcIdentifier" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.vpclattice.model.CreateServiceNetworkVpcAssociationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateServiceNetworkVpcAssociationRequest(")
        append("clientToken=$clientToken,")
        append("securityGroupIds=$securityGroupIds,")
        append("serviceNetworkIdentifier=$serviceNetworkIdentifier,")
        append("tags=$tags,")
        append("vpcIdentifier=$vpcIdentifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (serviceNetworkIdentifier.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcIdentifier.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateServiceNetworkVpcAssociationRequest

        if (clientToken != other.clientToken) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (serviceNetworkIdentifier != other.serviceNetworkIdentifier) return false
        if (tags != other.tags) return false
        if (vpcIdentifier != other.vpcIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.vpclattice.model.CreateServiceNetworkVpcAssociationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a request that completed successfully using the same client token and parameters, the retry succeeds without performing any actions. If the parameters aren't identical, the retry fails.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The IDs of the security groups. Security groups aren't added by default. You can add a security group to apply network level controls to control which resources in a VPC are allowed to access the service network and its services. For more information, see [Control traffic to resources using security groups](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html) in the *Amazon VPC User Guide*.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The ID or ARN of the service network. You must use an ARN if the resources are in different accounts.
         */
        public var serviceNetworkIdentifier: kotlin.String? = null
        /**
         * The tags for the association.
         */
        public var tags: Map<String, String>? = null
        /**
         * The ID of the VPC.
         */
        public var vpcIdentifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.vpclattice.model.CreateServiceNetworkVpcAssociationRequest) : this() {
            this.clientToken = x.clientToken
            this.securityGroupIds = x.securityGroupIds
            this.serviceNetworkIdentifier = x.serviceNetworkIdentifier
            this.tags = x.tags
            this.vpcIdentifier = x.vpcIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.vpclattice.model.CreateServiceNetworkVpcAssociationRequest = CreateServiceNetworkVpcAssociationRequest(this)

        internal fun correctErrors(): Builder {
            if (serviceNetworkIdentifier == null) serviceNetworkIdentifier = ""
            if (vpcIdentifier == null) vpcIdentifier = ""
            return this
        }
    }
}
