// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.vpclattice.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateServiceNetworkRequest private constructor(builder: Builder) {
    /**
     * The type of IAM policy.
     * + `NONE`: The resource does not use an IAM policy. This is the default.
     * + `AWS_IAM`: The resource uses an IAM policy. When this type is used, auth is enabled and an auth policy is required.
     */
    public val authType: aws.sdk.kotlin.services.vpclattice.model.AuthType? = builder.authType
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a request that completed successfully using the same client token and parameters, the retry succeeds without performing any actions. If the parameters aren't identical, the retry fails.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The name of the service network. The name must be unique to the account. The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Specify if the service network should be enabled for sharing.
     */
    public val sharingConfig: aws.sdk.kotlin.services.vpclattice.model.SharingConfig? = builder.sharingConfig
    /**
     * The tags for the service network.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.vpclattice.model.CreateServiceNetworkRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateServiceNetworkRequest(")
        append("authType=$authType,")
        append("clientToken=$clientToken,")
        append("name=$name,")
        append("sharingConfig=$sharingConfig,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authType?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (sharingConfig?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateServiceNetworkRequest

        if (authType != other.authType) return false
        if (clientToken != other.clientToken) return false
        if (name != other.name) return false
        if (sharingConfig != other.sharingConfig) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.vpclattice.model.CreateServiceNetworkRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The type of IAM policy.
         * + `NONE`: The resource does not use an IAM policy. This is the default.
         * + `AWS_IAM`: The resource uses an IAM policy. When this type is used, auth is enabled and an auth policy is required.
         */
        public var authType: aws.sdk.kotlin.services.vpclattice.model.AuthType? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a request that completed successfully using the same client token and parameters, the retry succeeds without performing any actions. If the parameters aren't identical, the retry fails.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The name of the service network. The name must be unique to the account. The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
         */
        public var name: kotlin.String? = null
        /**
         * Specify if the service network should be enabled for sharing.
         */
        public var sharingConfig: aws.sdk.kotlin.services.vpclattice.model.SharingConfig? = null
        /**
         * The tags for the service network.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.vpclattice.model.CreateServiceNetworkRequest) : this() {
            this.authType = x.authType
            this.clientToken = x.clientToken
            this.name = x.name
            this.sharingConfig = x.sharingConfig
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.vpclattice.model.CreateServiceNetworkRequest = CreateServiceNetworkRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.vpclattice.model.SharingConfig] inside the given [block]
         */
        public fun sharingConfig(block: aws.sdk.kotlin.services.vpclattice.model.SharingConfig.Builder.() -> kotlin.Unit) {
            this.sharingConfig = aws.sdk.kotlin.services.vpclattice.model.SharingConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            return this
        }
    }
}
