// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.vpclattice.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateResourceConfigurationRequest private constructor(builder: Builder) {
    /**
     * (SINGLE, GROUP, ARN) Specifies whether the resource configuration can be associated with a sharable service network. The default is false.
     */
    public val allowAssociationToShareableServiceNetwork: kotlin.Boolean? = builder.allowAssociationToShareableServiceNetwork
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a request that completed successfully using the same client token and parameters, the retry succeeds without performing any actions. If the parameters aren't identical, the retry fails.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The name of the resource configuration. The name must be unique within the account. The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
     */
    public val name: kotlin.String? = builder.name
    /**
     * (SINGLE, GROUP, CHILD) The TCP port ranges that a consumer can use to access a resource configuration (for example: 1-65535). You can separate port ranges using commas (for example: 1,2,22-30).
     */
    public val portRanges: List<String>? = builder.portRanges
    /**
     * (SINGLE, GROUP) The protocol accepted by the resource configuration.
     */
    public val protocol: aws.sdk.kotlin.services.vpclattice.model.ProtocolType? = builder.protocol
    /**
     * (SINGLE, CHILD, ARN) The resource configuration.
     */
    public val resourceConfigurationDefinition: aws.sdk.kotlin.services.vpclattice.model.ResourceConfigurationDefinition? = builder.resourceConfigurationDefinition
    /**
     * (CHILD) The ID or ARN of the parent resource configuration (type is `GROUP`). This is used to associate a child resource configuration with a group resource configuration.
     */
    public val resourceConfigurationGroupIdentifier: kotlin.String? = builder.resourceConfigurationGroupIdentifier
    /**
     * (SINGLE, GROUP, ARN) The ID or ARN of the resource gateway used to connect to the resource configuration. For a child resource configuration, this value is inherited from the parent resource configuration.
     */
    public val resourceGatewayIdentifier: kotlin.String? = builder.resourceGatewayIdentifier
    /**
     * The tags for the resource configuration.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The type of resource configuration.
     * + `SINGLE` - A single resource.
     * + `GROUP` - A group of resources. You must create a group resource configuration before you create a child resource configuration.
     * + `CHILD` - A single resource that is part of a group resource configuration.
     * + `ARN` - An Amazon Web Services resource.
     */
    public val type: aws.sdk.kotlin.services.vpclattice.model.ResourceConfigurationType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.vpclattice.model.CreateResourceConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateResourceConfigurationRequest(")
        append("allowAssociationToShareableServiceNetwork=$allowAssociationToShareableServiceNetwork,")
        append("clientToken=$clientToken,")
        append("name=$name,")
        append("portRanges=$portRanges,")
        append("protocol=$protocol,")
        append("resourceConfigurationDefinition=$resourceConfigurationDefinition,")
        append("resourceConfigurationGroupIdentifier=$resourceConfigurationGroupIdentifier,")
        append("resourceGatewayIdentifier=$resourceGatewayIdentifier,")
        append("tags=$tags,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowAssociationToShareableServiceNetwork?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (portRanges?.hashCode() ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (resourceConfigurationDefinition?.hashCode() ?: 0)
        result = 31 * result + (resourceConfigurationGroupIdentifier?.hashCode() ?: 0)
        result = 31 * result + (resourceGatewayIdentifier?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateResourceConfigurationRequest

        if (allowAssociationToShareableServiceNetwork != other.allowAssociationToShareableServiceNetwork) return false
        if (clientToken != other.clientToken) return false
        if (name != other.name) return false
        if (portRanges != other.portRanges) return false
        if (protocol != other.protocol) return false
        if (resourceConfigurationDefinition != other.resourceConfigurationDefinition) return false
        if (resourceConfigurationGroupIdentifier != other.resourceConfigurationGroupIdentifier) return false
        if (resourceGatewayIdentifier != other.resourceGatewayIdentifier) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.vpclattice.model.CreateResourceConfigurationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * (SINGLE, GROUP, ARN) Specifies whether the resource configuration can be associated with a sharable service network. The default is false.
         */
        public var allowAssociationToShareableServiceNetwork: kotlin.Boolean? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a request that completed successfully using the same client token and parameters, the retry succeeds without performing any actions. If the parameters aren't identical, the retry fails.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The name of the resource configuration. The name must be unique within the account. The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
         */
        public var name: kotlin.String? = null
        /**
         * (SINGLE, GROUP, CHILD) The TCP port ranges that a consumer can use to access a resource configuration (for example: 1-65535). You can separate port ranges using commas (for example: 1,2,22-30).
         */
        public var portRanges: List<String>? = null
        /**
         * (SINGLE, GROUP) The protocol accepted by the resource configuration.
         */
        public var protocol: aws.sdk.kotlin.services.vpclattice.model.ProtocolType? = null
        /**
         * (SINGLE, CHILD, ARN) The resource configuration.
         */
        public var resourceConfigurationDefinition: aws.sdk.kotlin.services.vpclattice.model.ResourceConfigurationDefinition? = null
        /**
         * (CHILD) The ID or ARN of the parent resource configuration (type is `GROUP`). This is used to associate a child resource configuration with a group resource configuration.
         */
        public var resourceConfigurationGroupIdentifier: kotlin.String? = null
        /**
         * (SINGLE, GROUP, ARN) The ID or ARN of the resource gateway used to connect to the resource configuration. For a child resource configuration, this value is inherited from the parent resource configuration.
         */
        public var resourceGatewayIdentifier: kotlin.String? = null
        /**
         * The tags for the resource configuration.
         */
        public var tags: Map<String, String>? = null
        /**
         * The type of resource configuration.
         * + `SINGLE` - A single resource.
         * + `GROUP` - A group of resources. You must create a group resource configuration before you create a child resource configuration.
         * + `CHILD` - A single resource that is part of a group resource configuration.
         * + `ARN` - An Amazon Web Services resource.
         */
        public var type: aws.sdk.kotlin.services.vpclattice.model.ResourceConfigurationType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.vpclattice.model.CreateResourceConfigurationRequest) : this() {
            this.allowAssociationToShareableServiceNetwork = x.allowAssociationToShareableServiceNetwork
            this.clientToken = x.clientToken
            this.name = x.name
            this.portRanges = x.portRanges
            this.protocol = x.protocol
            this.resourceConfigurationDefinition = x.resourceConfigurationDefinition
            this.resourceConfigurationGroupIdentifier = x.resourceConfigurationGroupIdentifier
            this.resourceGatewayIdentifier = x.resourceGatewayIdentifier
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.vpclattice.model.CreateResourceConfigurationRequest = CreateResourceConfigurationRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
