// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.vpclattice.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateListenerRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a request that completed successfully using the same client token and parameters, the retry succeeds without performing any actions. If the parameters aren't identical, the retry fails.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The action for the default rule. Each listener has a default rule. The default rule is used if no other rules match.
     */
    public val defaultAction: aws.sdk.kotlin.services.vpclattice.model.RuleAction? = builder.defaultAction
    /**
     * The name of the listener. A listener name must be unique within a service. The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The listener port. You can specify a value from 1 to 65535. For HTTP, the default is 80. For HTTPS, the default is 443.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The listener protocol.
     */
    public val protocol: aws.sdk.kotlin.services.vpclattice.model.ListenerProtocol = requireNotNull(builder.protocol) { "A non-null value must be provided for protocol" }
    /**
     * The ID or ARN of the service.
     */
    public val serviceIdentifier: kotlin.String = requireNotNull(builder.serviceIdentifier) { "A non-null value must be provided for serviceIdentifier" }
    /**
     * The tags for the listener.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.vpclattice.model.CreateListenerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateListenerRequest(")
        append("clientToken=$clientToken,")
        append("defaultAction=$defaultAction,")
        append("name=$name,")
        append("port=$port,")
        append("protocol=$protocol,")
        append("serviceIdentifier=$serviceIdentifier,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (defaultAction?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (port ?: 0)
        result = 31 * result + (protocol.hashCode())
        result = 31 * result + (serviceIdentifier.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateListenerRequest

        if (clientToken != other.clientToken) return false
        if (defaultAction != other.defaultAction) return false
        if (name != other.name) return false
        if (port != other.port) return false
        if (protocol != other.protocol) return false
        if (serviceIdentifier != other.serviceIdentifier) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.vpclattice.model.CreateListenerRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a request that completed successfully using the same client token and parameters, the retry succeeds without performing any actions. If the parameters aren't identical, the retry fails.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The action for the default rule. Each listener has a default rule. The default rule is used if no other rules match.
         */
        public var defaultAction: aws.sdk.kotlin.services.vpclattice.model.RuleAction? = null
        /**
         * The name of the listener. A listener name must be unique within a service. The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
         */
        public var name: kotlin.String? = null
        /**
         * The listener port. You can specify a value from 1 to 65535. For HTTP, the default is 80. For HTTPS, the default is 443.
         */
        public var port: kotlin.Int? = null
        /**
         * The listener protocol.
         */
        public var protocol: aws.sdk.kotlin.services.vpclattice.model.ListenerProtocol? = null
        /**
         * The ID or ARN of the service.
         */
        public var serviceIdentifier: kotlin.String? = null
        /**
         * The tags for the listener.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.vpclattice.model.CreateListenerRequest) : this() {
            this.clientToken = x.clientToken
            this.defaultAction = x.defaultAction
            this.name = x.name
            this.port = x.port
            this.protocol = x.protocol
            this.serviceIdentifier = x.serviceIdentifier
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.vpclattice.model.CreateListenerRequest = CreateListenerRequest(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (protocol == null) protocol = ListenerProtocol.SdkUnknown("no value provided")
            if (serviceIdentifier == null) serviceIdentifier = ""
            return this
        }
    }
}
