// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.vpclattice.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information about an access log subscription.
 */
public class AccessLogSubscriptionSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the access log subscription
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The date and time that the access log subscription was created, in ISO-8601 format.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The Amazon Resource Name (ARN) of the destination.
     */
    public val destinationArn: kotlin.String = requireNotNull(builder.destinationArn) { "A non-null value must be provided for destinationArn" }
    /**
     * The ID of the access log subscription.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The date and time that the access log subscription was last updated, in ISO-8601 format.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdatedAt) { "A non-null value must be provided for lastUpdatedAt" }
    /**
     * The Amazon Resource Name (ARN) of the service or service network.
     */
    public val resourceArn: kotlin.String = requireNotNull(builder.resourceArn) { "A non-null value must be provided for resourceArn" }
    /**
     * The ID of the service or service network.
     */
    public val resourceId: kotlin.String = requireNotNull(builder.resourceId) { "A non-null value must be provided for resourceId" }
    /**
     * Log type of the service network.
     */
    public val serviceNetworkLogType: aws.sdk.kotlin.services.vpclattice.model.ServiceNetworkLogType? = builder.serviceNetworkLogType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.vpclattice.model.AccessLogSubscriptionSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccessLogSubscriptionSummary(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("destinationArn=$destinationArn,")
        append("id=$id,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("resourceArn=$resourceArn,")
        append("resourceId=$resourceId,")
        append("serviceNetworkLogType=$serviceNetworkLogType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (destinationArn.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (lastUpdatedAt.hashCode())
        result = 31 * result + (resourceArn.hashCode())
        result = 31 * result + (resourceId.hashCode())
        result = 31 * result + (serviceNetworkLogType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccessLogSubscriptionSummary

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (destinationArn != other.destinationArn) return false
        if (id != other.id) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (resourceArn != other.resourceArn) return false
        if (resourceId != other.resourceId) return false
        if (serviceNetworkLogType != other.serviceNetworkLogType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.vpclattice.model.AccessLogSubscriptionSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the access log subscription
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time that the access log subscription was created, in ISO-8601 format.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the destination.
         */
        public var destinationArn: kotlin.String? = null
        /**
         * The ID of the access log subscription.
         */
        public var id: kotlin.String? = null
        /**
         * The date and time that the access log subscription was last updated, in ISO-8601 format.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the service or service network.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The ID of the service or service network.
         */
        public var resourceId: kotlin.String? = null
        /**
         * Log type of the service network.
         */
        public var serviceNetworkLogType: aws.sdk.kotlin.services.vpclattice.model.ServiceNetworkLogType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.vpclattice.model.AccessLogSubscriptionSummary) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.destinationArn = x.destinationArn
            this.id = x.id
            this.lastUpdatedAt = x.lastUpdatedAt
            this.resourceArn = x.resourceArn
            this.resourceId = x.resourceId
            this.serviceNetworkLogType = x.serviceNetworkLogType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.vpclattice.model.AccessLogSubscriptionSummary = AccessLogSubscriptionSummary(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (destinationArn == null) destinationArn = ""
            if (id == null) id = ""
            if (lastUpdatedAt == null) lastUpdatedAt = Instant.fromEpochSeconds(0)
            if (resourceArn == null) resourceArn = ""
            if (resourceId == null) resourceId = ""
            return this
        }
    }
}
