// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.vpclattice.serde

import aws.sdk.kotlin.services.vpclattice.model.GetListenerResponse
import aws.sdk.kotlin.services.vpclattice.model.ListenerProtocol
import aws.sdk.kotlin.services.vpclattice.model.RuleAction
import aws.sdk.kotlin.services.vpclattice.model.VpcLatticeException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetListenerOperationDeserializer: HttpDeserializer.NonStreaming<GetListenerResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetListenerResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetListenerError(context, call, payload)
        }
        val builder = GetListenerResponse.Builder()

        if (payload != null) {
            deserializeGetListenerOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetListenerError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw VpcLatticeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> VpcLatticeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetListenerOperationBody(builder: GetListenerResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val DEFAULTACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("defaultAction"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val LASTUPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedAt"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val PORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("port"))
    val PROTOCOL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("protocol"))
    val SERVICEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("serviceArn"))
    val SERVICEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("serviceId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DEFAULTACTION_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(LASTUPDATEDAT_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PORT_DESCRIPTOR)
        field(PROTOCOL_DESCRIPTOR)
        field(SERVICEARN_DESCRIPTOR)
        field(SERVICEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeInstant(TimestampFormat.ISO_8601)
                DEFAULTACTION_DESCRIPTOR.index -> builder.defaultAction = deserializeRuleActionDocument(deserializer)
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                LASTUPDATEDAT_DESCRIPTOR.index -> builder.lastUpdatedAt = deserializeInstant(TimestampFormat.ISO_8601)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PORT_DESCRIPTOR.index -> builder.port = deserializeInt()
                PROTOCOL_DESCRIPTOR.index -> builder.protocol = deserializeString().let { ListenerProtocol.fromValue(it) }
                SERVICEARN_DESCRIPTOR.index -> builder.serviceArn = deserializeString()
                SERVICEID_DESCRIPTOR.index -> builder.serviceId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
