// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.vpclattice.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the weight of a target group.
 */
public class WeightedTargetGroup private constructor(builder: Builder) {
    /**
     * The ID or Amazon Resource Name (ARN) of the target group.
     */
    public val targetGroupIdentifier: kotlin.String = requireNotNull(builder.targetGroupIdentifier) { "A non-null value must be provided for targetGroupIdentifier" }
    /**
     * Only required if you specify multiple target groups for a forward action. The weight determines how requests are distributed to the target group. For example, if you specify two target groups, each with a weight of 10, each target group receives half the requests. If you specify two target groups, one with a weight of 10 and the other with a weight of 20, the target group with a weight of 20 receives twice as many requests as the other target group. If there's only one target group specified, then the default value is 100.
     */
    public val weight: kotlin.Int? = builder.weight

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.vpclattice.model.WeightedTargetGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WeightedTargetGroup(")
        append("targetGroupIdentifier=$targetGroupIdentifier,")
        append("weight=$weight")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = targetGroupIdentifier.hashCode()
        result = 31 * result + (weight ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WeightedTargetGroup

        if (targetGroupIdentifier != other.targetGroupIdentifier) return false
        if (weight != other.weight) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.vpclattice.model.WeightedTargetGroup = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID or Amazon Resource Name (ARN) of the target group.
         */
        public var targetGroupIdentifier: kotlin.String? = null
        /**
         * Only required if you specify multiple target groups for a forward action. The weight determines how requests are distributed to the target group. For example, if you specify two target groups, each with a weight of 10, each target group receives half the requests. If you specify two target groups, one with a weight of 10 and the other with a weight of 20, the target group with a weight of 20 receives twice as many requests as the other target group. If there's only one target group specified, then the default value is 100.
         */
        public var weight: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.vpclattice.model.WeightedTargetGroup) : this() {
            this.targetGroupIdentifier = x.targetGroupIdentifier
            this.weight = x.weight
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.vpclattice.model.WeightedTargetGroup = WeightedTargetGroup(this)

        internal fun correctErrors(): Builder {
            if (targetGroupIdentifier == null) targetGroupIdentifier = ""
            return this
        }
    }
}
