// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.vpclattice.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information about a target group.
 */
public class TargetGroupSummary private constructor(builder: Builder) {
    /**
     * The ARN (Amazon Resource Name) of the target group.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date and time that the target group was created, specified in ISO-8601 format.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The ID of the target group.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The type of IP address used for the target group. The possible values are `ipv4` and `ipv6`. This is an optional parameter. If not specified, the IP address type defaults to `ipv4`.
     */
    public val ipAddressType: aws.sdk.kotlin.services.vpclattice.model.IpAddressType? = builder.ipAddressType
    /**
     * Lambda event structure version
     */
    public val lambdaEventStructureVersion: aws.sdk.kotlin.services.vpclattice.model.LambdaEventStructureVersion? = builder.lambdaEventStructureVersion
    /**
     * The date and time that the target group was last updated, specified in ISO-8601 format.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The name of the target group.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The port of the target group.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The protocol of the target group.
     */
    public val protocol: aws.sdk.kotlin.services.vpclattice.model.TargetGroupProtocol? = builder.protocol
    /**
     * The list of Amazon Resource Names (ARNs) of the service.
     */
    public val serviceArns: List<String>? = builder.serviceArns
    /**
     * The status.
     */
    public val status: aws.sdk.kotlin.services.vpclattice.model.TargetGroupStatus? = builder.status
    /**
     * The target group type.
     */
    public val type: aws.sdk.kotlin.services.vpclattice.model.TargetGroupType? = builder.type
    /**
     * The ID of the VPC of the target group.
     */
    public val vpcIdentifier: kotlin.String? = builder.vpcIdentifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.vpclattice.model.TargetGroupSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TargetGroupSummary(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("id=$id,")
        append("ipAddressType=$ipAddressType,")
        append("lambdaEventStructureVersion=$lambdaEventStructureVersion,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("name=$name,")
        append("port=$port,")
        append("protocol=$protocol,")
        append("serviceArns=$serviceArns,")
        append("status=$status,")
        append("type=$type,")
        append("vpcIdentifier=$vpcIdentifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (ipAddressType?.hashCode() ?: 0)
        result = 31 * result + (lambdaEventStructureVersion?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (serviceArns?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (vpcIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TargetGroupSummary

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (id != other.id) return false
        if (ipAddressType != other.ipAddressType) return false
        if (lambdaEventStructureVersion != other.lambdaEventStructureVersion) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (name != other.name) return false
        if (port != other.port) return false
        if (protocol != other.protocol) return false
        if (serviceArns != other.serviceArns) return false
        if (status != other.status) return false
        if (type != other.type) return false
        if (vpcIdentifier != other.vpcIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.vpclattice.model.TargetGroupSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN (Amazon Resource Name) of the target group.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time that the target group was created, specified in ISO-8601 format.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the target group.
         */
        public var id: kotlin.String? = null
        /**
         * The type of IP address used for the target group. The possible values are `ipv4` and `ipv6`. This is an optional parameter. If not specified, the IP address type defaults to `ipv4`.
         */
        public var ipAddressType: aws.sdk.kotlin.services.vpclattice.model.IpAddressType? = null
        /**
         * Lambda event structure version
         */
        public var lambdaEventStructureVersion: aws.sdk.kotlin.services.vpclattice.model.LambdaEventStructureVersion? = null
        /**
         * The date and time that the target group was last updated, specified in ISO-8601 format.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the target group.
         */
        public var name: kotlin.String? = null
        /**
         * The port of the target group.
         */
        public var port: kotlin.Int? = null
        /**
         * The protocol of the target group.
         */
        public var protocol: aws.sdk.kotlin.services.vpclattice.model.TargetGroupProtocol? = null
        /**
         * The list of Amazon Resource Names (ARNs) of the service.
         */
        public var serviceArns: List<String>? = null
        /**
         * The status.
         */
        public var status: aws.sdk.kotlin.services.vpclattice.model.TargetGroupStatus? = null
        /**
         * The target group type.
         */
        public var type: aws.sdk.kotlin.services.vpclattice.model.TargetGroupType? = null
        /**
         * The ID of the VPC of the target group.
         */
        public var vpcIdentifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.vpclattice.model.TargetGroupSummary) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.id = x.id
            this.ipAddressType = x.ipAddressType
            this.lambdaEventStructureVersion = x.lambdaEventStructureVersion
            this.lastUpdatedAt = x.lastUpdatedAt
            this.name = x.name
            this.port = x.port
            this.protocol = x.protocol
            this.serviceArns = x.serviceArns
            this.status = x.status
            this.type = x.type
            this.vpcIdentifier = x.vpcIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.vpclattice.model.TargetGroupSummary = TargetGroupSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
