// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.vpclattice.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateServiceRequest private constructor(builder: Builder) {
    /**
     * The type of IAM policy.
     * + `NONE`: The resource does not use an IAM policy. This is the default.
     * + `AWS_IAM`: The resource uses an IAM policy. When this type is used, auth is enabled and an auth policy is required.
     */
    public val authType: aws.sdk.kotlin.services.vpclattice.model.AuthType? = builder.authType
    /**
     * The Amazon Resource Name (ARN) of the certificate.
     */
    public val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a request that completed successfully using the same client token and parameters, the retry succeeds without performing any actions. If the parameters aren't identical, the retry fails.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The custom domain name of the service.
     */
    public val customDomainName: kotlin.String? = builder.customDomainName
    /**
     * The name of the service. The name must be unique within the account. The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The tags for the service.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.vpclattice.model.CreateServiceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateServiceRequest(")
        append("authType=$authType,")
        append("certificateArn=$certificateArn,")
        append("clientToken=$clientToken,")
        append("customDomainName=$customDomainName,")
        append("name=$name,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authType?.hashCode() ?: 0
        result = 31 * result + (certificateArn?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (customDomainName?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateServiceRequest

        if (authType != other.authType) return false
        if (certificateArn != other.certificateArn) return false
        if (clientToken != other.clientToken) return false
        if (customDomainName != other.customDomainName) return false
        if (name != other.name) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.vpclattice.model.CreateServiceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The type of IAM policy.
         * + `NONE`: The resource does not use an IAM policy. This is the default.
         * + `AWS_IAM`: The resource uses an IAM policy. When this type is used, auth is enabled and an auth policy is required.
         */
        public var authType: aws.sdk.kotlin.services.vpclattice.model.AuthType? = null
        /**
         * The Amazon Resource Name (ARN) of the certificate.
         */
        public var certificateArn: kotlin.String? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a request that completed successfully using the same client token and parameters, the retry succeeds without performing any actions. If the parameters aren't identical, the retry fails.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The custom domain name of the service.
         */
        public var customDomainName: kotlin.String? = null
        /**
         * The name of the service. The name must be unique within the account. The valid characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
         */
        public var name: kotlin.String? = null
        /**
         * The tags for the service.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.vpclattice.model.CreateServiceRequest) : this() {
            this.authType = x.authType
            this.certificateArn = x.certificateArn
            this.clientToken = x.clientToken
            this.customDomainName = x.customDomainName
            this.name = x.name
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.vpclattice.model.CreateServiceRequest = CreateServiceRequest(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            return this
        }
    }
}
