// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.vpclattice.serde

import aws.sdk.kotlin.services.vpclattice.model.RuleAction
import aws.sdk.kotlin.services.vpclattice.model.RuleMatch
import aws.sdk.kotlin.services.vpclattice.model.UpdateRuleRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateRuleOperationSerializer: HttpSerializer.NonStreaming<UpdateRuleRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateRuleRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            path.encodedSegments {
                add(PercentEncoding.Path.encode("services"))
                add(PercentEncoding.SmithyLabel.encode("${input.serviceIdentifier}"))
                add(PercentEncoding.Path.encode("listeners"))
                add(PercentEncoding.SmithyLabel.encode("${input.listenerIdentifier}"))
                add(PercentEncoding.Path.encode("rules"))
                add(PercentEncoding.SmithyLabel.encode("${input.ruleIdentifier}"))
            }
        }

        val payload = serializeUpdateRuleOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateRuleOperationBody(context: ExecutionContext, input: UpdateRuleRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("action"))
    val MATCH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("match"))
    val PRIORITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("priority"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTION_DESCRIPTOR)
        field(MATCH_DESCRIPTOR)
        field(PRIORITY_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.action?.let { field(ACTION_DESCRIPTOR, it, ::serializeRuleActionDocument) }
        input.match?.let { field(MATCH_DESCRIPTOR, it, ::serializeRuleMatchDocument) }
        input.priority?.let { field(PRIORITY_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
