// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.vpclattice.model



/**
 * Summary information about a target.
 */
public class TargetSummary private constructor(builder: Builder) {
    /**
     * The ID of the target. If the target type of the target group is `INSTANCE`, this is an instance ID. If the target type is `IP` , this is an IP address. If the target type is `LAMBDA`, this is the ARN of the Lambda function. If the target type is `ALB`, this is the ARN of the Application Load Balancer.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The port on which the target is listening.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The code for why the target status is what it is.
     */
    public val reasonCode: kotlin.String? = builder.reasonCode
    /**
     * The status of the target.
     * + `Draining`: The target is being deregistered. No new connections will be sent to this target while current connections are being drained. Default draining time is 5 minutes.
     * + `Unavailable`: Health checks are unavailable for the target group.
     * + `Healthy`: The target is healthy.
     * + `Unhealthy`: The target is unhealthy.
     * + `Initial`: Initial health checks on the target are being performed.
     * + `Unused`: Target group is not used in a service.
     */
    public val status: aws.sdk.kotlin.services.vpclattice.model.TargetStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.vpclattice.model.TargetSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TargetSummary(")
        append("id=$id,")
        append("port=$port,")
        append("reasonCode=$reasonCode,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (port ?: 0)
        result = 31 * result + (reasonCode?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TargetSummary

        if (id != other.id) return false
        if (port != other.port) return false
        if (reasonCode != other.reasonCode) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.vpclattice.model.TargetSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the target. If the target type of the target group is `INSTANCE`, this is an instance ID. If the target type is `IP` , this is an IP address. If the target type is `LAMBDA`, this is the ARN of the Lambda function. If the target type is `ALB`, this is the ARN of the Application Load Balancer.
         */
        public var id: kotlin.String? = null
        /**
         * The port on which the target is listening.
         */
        public var port: kotlin.Int? = null
        /**
         * The code for why the target status is what it is.
         */
        public var reasonCode: kotlin.String? = null
        /**
         * The status of the target.
         * + `Draining`: The target is being deregistered. No new connections will be sent to this target while current connections are being drained. Default draining time is 5 minutes.
         * + `Unavailable`: Health checks are unavailable for the target group.
         * + `Healthy`: The target is healthy.
         * + `Unhealthy`: The target is unhealthy.
         * + `Initial`: Initial health checks on the target are being performed.
         * + `Unused`: Target group is not used in a service.
         */
        public var status: aws.sdk.kotlin.services.vpclattice.model.TargetStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.vpclattice.model.TargetSummary) : this() {
            this.id = x.id
            this.port = x.port
            this.reasonCode = x.reasonCode
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.vpclattice.model.TargetSummary = TargetSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
