// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.vpclattice.serde

import aws.sdk.kotlin.services.vpclattice.model.AuthType
import aws.sdk.kotlin.services.vpclattice.model.DnsEntry
import aws.sdk.kotlin.services.vpclattice.model.GetServiceResponse
import aws.sdk.kotlin.services.vpclattice.model.ServiceStatus
import aws.sdk.kotlin.services.vpclattice.model.VpcLatticeException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetServiceOperationDeserializer: HttpDeserialize<GetServiceResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetServiceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetServiceError(context, call)
        }
        val builder = GetServiceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetServiceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetServiceError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw VpcLatticeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        else -> VpcLatticeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetServiceOperationBody(builder: GetServiceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val AUTHTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authType"))
    val CERTIFICATEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("certificateArn"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val CUSTOMDOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("customDomainName"))
    val DNSENTRY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("dnsEntry"))
    val FAILURECODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("failureCode"))
    val FAILUREMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("failureMessage"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val LASTUPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedAt"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(AUTHTYPE_DESCRIPTOR)
        field(CERTIFICATEARN_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(CUSTOMDOMAINNAME_DESCRIPTOR)
        field(DNSENTRY_DESCRIPTOR)
        field(FAILURECODE_DESCRIPTOR)
        field(FAILUREMESSAGE_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(LASTUPDATEDAT_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                AUTHTYPE_DESCRIPTOR.index -> builder.authType = deserializeString().let { AuthType.fromValue(it) }
                CERTIFICATEARN_DESCRIPTOR.index -> builder.certificateArn = deserializeString()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromIso8601(it) }
                CUSTOMDOMAINNAME_DESCRIPTOR.index -> builder.customDomainName = deserializeString()
                DNSENTRY_DESCRIPTOR.index -> builder.dnsEntry = deserializeDnsEntryDocument(deserializer)
                FAILURECODE_DESCRIPTOR.index -> builder.failureCode = deserializeString()
                FAILUREMESSAGE_DESCRIPTOR.index -> builder.failureMessage = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                LASTUPDATEDAT_DESCRIPTOR.index -> builder.lastUpdatedAt = deserializeString().let { Instant.fromIso8601(it) }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ServiceStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
