// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.vpclattice.serde

import aws.sdk.kotlin.services.vpclattice.model.CreateRuleRequest
import aws.sdk.kotlin.services.vpclattice.model.RuleAction
import aws.sdk.kotlin.services.vpclattice.model.RuleMatch
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateRuleOperationSerializer: HttpSerialize<CreateRuleRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateRuleRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "services",
                "${input.serviceIdentifier}".encodeLabel(),
                "listeners",
                "${input.listenerIdentifier}".encodeLabel(),
                "rules",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateRuleOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateRuleOperationBody(context: ExecutionContext, input: CreateRuleRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("action"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val MATCH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("match"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val PRIORITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("priority"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTION_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(MATCH_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PRIORITY_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.action?.let { field(ACTION_DESCRIPTOR, it, ::serializeRuleActionDocument) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.match?.let { field(MATCH_DESCRIPTOR, it, ::serializeRuleMatchDocument) }
        field(NAME_DESCRIPTOR, input.name)
        field(PRIORITY_DESCRIPTOR, input.priority)
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
    }
    return serializer.toByteArray()
}
