// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.vpclattice.model



/**
 * Describes the configuration of a target group. Lambda functions don't support target group configuration.
 */
public class TargetGroupConfig private constructor(builder: Builder) {
    /**
     * The health check configuration.
     */
    public val healthCheck: aws.sdk.kotlin.services.vpclattice.model.HealthCheckConfig? = builder.healthCheck
    /**
     * The type of IP address used for the target group. The possible values are `ipv4` and `ipv6`. This is an optional parameter. If not specified, the IP address type defaults to `ipv4`.
     */
    public val ipAddressType: aws.sdk.kotlin.services.vpclattice.model.IpAddressType? = builder.ipAddressType
    /**
     * Lambda event structure version
     */
    public val lambdaEventStructureVersion: aws.sdk.kotlin.services.vpclattice.model.LambdaEventStructureVersion? = builder.lambdaEventStructureVersion
    /**
     * The port on which the targets are listening. For HTTP, the default is `80`. For HTTPS, the default is `443`
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The protocol to use for routing traffic to the targets. Default is the protocol of a target group.
     */
    public val protocol: aws.sdk.kotlin.services.vpclattice.model.TargetGroupProtocol? = builder.protocol
    /**
     * The protocol version. Default value is `HTTP1`.
     */
    public val protocolVersion: aws.sdk.kotlin.services.vpclattice.model.TargetGroupProtocolVersion? = builder.protocolVersion
    /**
     * The ID of the VPC.
     */
    public val vpcIdentifier: kotlin.String? = builder.vpcIdentifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.vpclattice.model.TargetGroupConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TargetGroupConfig(")
        append("healthCheck=$healthCheck,")
        append("ipAddressType=$ipAddressType,")
        append("lambdaEventStructureVersion=$lambdaEventStructureVersion,")
        append("port=$port,")
        append("protocol=$protocol,")
        append("protocolVersion=$protocolVersion,")
        append("vpcIdentifier=$vpcIdentifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = healthCheck?.hashCode() ?: 0
        result = 31 * result + (ipAddressType?.hashCode() ?: 0)
        result = 31 * result + (lambdaEventStructureVersion?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (protocolVersion?.hashCode() ?: 0)
        result = 31 * result + (vpcIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TargetGroupConfig

        if (healthCheck != other.healthCheck) return false
        if (ipAddressType != other.ipAddressType) return false
        if (lambdaEventStructureVersion != other.lambdaEventStructureVersion) return false
        if (port != other.port) return false
        if (protocol != other.protocol) return false
        if (protocolVersion != other.protocolVersion) return false
        if (vpcIdentifier != other.vpcIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.vpclattice.model.TargetGroupConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The health check configuration.
         */
        public var healthCheck: aws.sdk.kotlin.services.vpclattice.model.HealthCheckConfig? = null
        /**
         * The type of IP address used for the target group. The possible values are `ipv4` and `ipv6`. This is an optional parameter. If not specified, the IP address type defaults to `ipv4`.
         */
        public var ipAddressType: aws.sdk.kotlin.services.vpclattice.model.IpAddressType? = null
        /**
         * Lambda event structure version
         */
        public var lambdaEventStructureVersion: aws.sdk.kotlin.services.vpclattice.model.LambdaEventStructureVersion? = null
        /**
         * The port on which the targets are listening. For HTTP, the default is `80`. For HTTPS, the default is `443`
         */
        public var port: kotlin.Int? = null
        /**
         * The protocol to use for routing traffic to the targets. Default is the protocol of a target group.
         */
        public var protocol: aws.sdk.kotlin.services.vpclattice.model.TargetGroupProtocol? = null
        /**
         * The protocol version. Default value is `HTTP1`.
         */
        public var protocolVersion: aws.sdk.kotlin.services.vpclattice.model.TargetGroupProtocolVersion? = null
        /**
         * The ID of the VPC.
         */
        public var vpcIdentifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.vpclattice.model.TargetGroupConfig) : this() {
            this.healthCheck = x.healthCheck
            this.ipAddressType = x.ipAddressType
            this.lambdaEventStructureVersion = x.lambdaEventStructureVersion
            this.port = x.port
            this.protocol = x.protocol
            this.protocolVersion = x.protocolVersion
            this.vpcIdentifier = x.vpcIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.vpclattice.model.TargetGroupConfig = TargetGroupConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.vpclattice.model.HealthCheckConfig] inside the given [block]
         */
        public fun healthCheck(block: aws.sdk.kotlin.services.vpclattice.model.HealthCheckConfig.Builder.() -> kotlin.Unit) {
            this.healthCheck = aws.sdk.kotlin.services.vpclattice.model.HealthCheckConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
