// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.vpclattice.model



/**
 * The health check configuration of a target group. Health check configurations aren't used for `LAMBDA` and `ALB` target groups.
 */
public class HealthCheckConfig private constructor(builder: Builder) {
    /**
     * Indicates whether health checking is enabled.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The approximate amount of time, in seconds, between health checks of an individual target. The range is 5–300 seconds. The default is 30 seconds.
     */
    public val healthCheckIntervalSeconds: kotlin.Int? = builder.healthCheckIntervalSeconds
    /**
     * The amount of time, in seconds, to wait before reporting a target as unhealthy. The range is 1–120 seconds. The default is 5 seconds.
     */
    public val healthCheckTimeoutSeconds: kotlin.Int? = builder.healthCheckTimeoutSeconds
    /**
     * The number of consecutive successful health checks required before considering an unhealthy target healthy. The range is 2–10. The default is 5.
     */
    public val healthyThresholdCount: kotlin.Int? = builder.healthyThresholdCount
    /**
     * The codes to use when checking for a successful response from a target. These are called *Success codes* in the console.
     */
    public val matcher: aws.sdk.kotlin.services.vpclattice.model.Matcher? = builder.matcher
    /**
     * The destination for health checks on the targets. If the protocol version is `HTTP/1.1` or `HTTP/2`, specify a valid URI (for example, `/path?query`). The default path is `/`. Health checks are not supported if the protocol version is `gRPC`, however, you can choose `HTTP/1.1` or `HTTP/2` and specify a valid URI.
     */
    public val path: kotlin.String? = builder.path
    /**
     * The port used when performing health checks on targets. The default setting is the port that a target receives traffic on.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The protocol used when performing health checks on targets. The possible protocols are `HTTP` and `HTTPS`. The default is `HTTP`.
     */
    public val protocol: aws.sdk.kotlin.services.vpclattice.model.TargetGroupProtocol? = builder.protocol
    /**
     * The protocol version used when performing health checks on targets. The possible protocol versions are `HTTP1` and `HTTP2`.
     */
    public val protocolVersion: aws.sdk.kotlin.services.vpclattice.model.HealthCheckProtocolVersion? = builder.protocolVersion
    /**
     * The number of consecutive failed health checks required before considering a target unhealthy. The range is 2–10. The default is 2.
     */
    public val unhealthyThresholdCount: kotlin.Int? = builder.unhealthyThresholdCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.vpclattice.model.HealthCheckConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HealthCheckConfig(")
        append("enabled=$enabled,")
        append("healthCheckIntervalSeconds=$healthCheckIntervalSeconds,")
        append("healthCheckTimeoutSeconds=$healthCheckTimeoutSeconds,")
        append("healthyThresholdCount=$healthyThresholdCount,")
        append("matcher=$matcher,")
        append("path=$path,")
        append("port=$port,")
        append("protocol=$protocol,")
        append("protocolVersion=$protocolVersion,")
        append("unhealthyThresholdCount=$unhealthyThresholdCount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (healthCheckIntervalSeconds ?: 0)
        result = 31 * result + (healthCheckTimeoutSeconds ?: 0)
        result = 31 * result + (healthyThresholdCount ?: 0)
        result = 31 * result + (matcher?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (protocolVersion?.hashCode() ?: 0)
        result = 31 * result + (unhealthyThresholdCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HealthCheckConfig

        if (enabled != other.enabled) return false
        if (healthCheckIntervalSeconds != other.healthCheckIntervalSeconds) return false
        if (healthCheckTimeoutSeconds != other.healthCheckTimeoutSeconds) return false
        if (healthyThresholdCount != other.healthyThresholdCount) return false
        if (matcher != other.matcher) return false
        if (path != other.path) return false
        if (port != other.port) return false
        if (protocol != other.protocol) return false
        if (protocolVersion != other.protocolVersion) return false
        if (unhealthyThresholdCount != other.unhealthyThresholdCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.vpclattice.model.HealthCheckConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether health checking is enabled.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The approximate amount of time, in seconds, between health checks of an individual target. The range is 5–300 seconds. The default is 30 seconds.
         */
        public var healthCheckIntervalSeconds: kotlin.Int? = null
        /**
         * The amount of time, in seconds, to wait before reporting a target as unhealthy. The range is 1–120 seconds. The default is 5 seconds.
         */
        public var healthCheckTimeoutSeconds: kotlin.Int? = null
        /**
         * The number of consecutive successful health checks required before considering an unhealthy target healthy. The range is 2–10. The default is 5.
         */
        public var healthyThresholdCount: kotlin.Int? = null
        /**
         * The codes to use when checking for a successful response from a target. These are called *Success codes* in the console.
         */
        public var matcher: aws.sdk.kotlin.services.vpclattice.model.Matcher? = null
        /**
         * The destination for health checks on the targets. If the protocol version is `HTTP/1.1` or `HTTP/2`, specify a valid URI (for example, `/path?query`). The default path is `/`. Health checks are not supported if the protocol version is `gRPC`, however, you can choose `HTTP/1.1` or `HTTP/2` and specify a valid URI.
         */
        public var path: kotlin.String? = null
        /**
         * The port used when performing health checks on targets. The default setting is the port that a target receives traffic on.
         */
        public var port: kotlin.Int? = null
        /**
         * The protocol used when performing health checks on targets. The possible protocols are `HTTP` and `HTTPS`. The default is `HTTP`.
         */
        public var protocol: aws.sdk.kotlin.services.vpclattice.model.TargetGroupProtocol? = null
        /**
         * The protocol version used when performing health checks on targets. The possible protocol versions are `HTTP1` and `HTTP2`.
         */
        public var protocolVersion: aws.sdk.kotlin.services.vpclattice.model.HealthCheckProtocolVersion? = null
        /**
         * The number of consecutive failed health checks required before considering a target unhealthy. The range is 2–10. The default is 2.
         */
        public var unhealthyThresholdCount: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.vpclattice.model.HealthCheckConfig) : this() {
            this.enabled = x.enabled
            this.healthCheckIntervalSeconds = x.healthCheckIntervalSeconds
            this.healthCheckTimeoutSeconds = x.healthCheckTimeoutSeconds
            this.healthyThresholdCount = x.healthyThresholdCount
            this.matcher = x.matcher
            this.path = x.path
            this.port = x.port
            this.protocol = x.protocol
            this.protocolVersion = x.protocolVersion
            this.unhealthyThresholdCount = x.unhealthyThresholdCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.vpclattice.model.HealthCheckConfig = HealthCheckConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
