// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.vpclattice

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.vpclattice.auth.DefaultVpcLatticeAuthSchemeProvider
import aws.sdk.kotlin.services.vpclattice.auth.VpcLatticeAuthSchemeProvider
import aws.sdk.kotlin.services.vpclattice.endpoints.DefaultVpcLatticeEndpointProvider
import aws.sdk.kotlin.services.vpclattice.endpoints.VpcLatticeEndpointParameters
import aws.sdk.kotlin.services.vpclattice.endpoints.VpcLatticeEndpointProvider
import aws.sdk.kotlin.services.vpclattice.model.BatchUpdateRuleRequest
import aws.sdk.kotlin.services.vpclattice.model.BatchUpdateRuleResponse
import aws.sdk.kotlin.services.vpclattice.model.CreateAccessLogSubscriptionRequest
import aws.sdk.kotlin.services.vpclattice.model.CreateAccessLogSubscriptionResponse
import aws.sdk.kotlin.services.vpclattice.model.CreateListenerRequest
import aws.sdk.kotlin.services.vpclattice.model.CreateListenerResponse
import aws.sdk.kotlin.services.vpclattice.model.CreateRuleRequest
import aws.sdk.kotlin.services.vpclattice.model.CreateRuleResponse
import aws.sdk.kotlin.services.vpclattice.model.CreateServiceNetworkRequest
import aws.sdk.kotlin.services.vpclattice.model.CreateServiceNetworkResponse
import aws.sdk.kotlin.services.vpclattice.model.CreateServiceNetworkServiceAssociationRequest
import aws.sdk.kotlin.services.vpclattice.model.CreateServiceNetworkServiceAssociationResponse
import aws.sdk.kotlin.services.vpclattice.model.CreateServiceNetworkVpcAssociationRequest
import aws.sdk.kotlin.services.vpclattice.model.CreateServiceNetworkVpcAssociationResponse
import aws.sdk.kotlin.services.vpclattice.model.CreateServiceRequest
import aws.sdk.kotlin.services.vpclattice.model.CreateServiceResponse
import aws.sdk.kotlin.services.vpclattice.model.CreateTargetGroupRequest
import aws.sdk.kotlin.services.vpclattice.model.CreateTargetGroupResponse
import aws.sdk.kotlin.services.vpclattice.model.DeleteAccessLogSubscriptionRequest
import aws.sdk.kotlin.services.vpclattice.model.DeleteAccessLogSubscriptionResponse
import aws.sdk.kotlin.services.vpclattice.model.DeleteAuthPolicyRequest
import aws.sdk.kotlin.services.vpclattice.model.DeleteAuthPolicyResponse
import aws.sdk.kotlin.services.vpclattice.model.DeleteListenerRequest
import aws.sdk.kotlin.services.vpclattice.model.DeleteListenerResponse
import aws.sdk.kotlin.services.vpclattice.model.DeleteResourcePolicyRequest
import aws.sdk.kotlin.services.vpclattice.model.DeleteResourcePolicyResponse
import aws.sdk.kotlin.services.vpclattice.model.DeleteRuleRequest
import aws.sdk.kotlin.services.vpclattice.model.DeleteRuleResponse
import aws.sdk.kotlin.services.vpclattice.model.DeleteServiceNetworkRequest
import aws.sdk.kotlin.services.vpclattice.model.DeleteServiceNetworkResponse
import aws.sdk.kotlin.services.vpclattice.model.DeleteServiceNetworkServiceAssociationRequest
import aws.sdk.kotlin.services.vpclattice.model.DeleteServiceNetworkServiceAssociationResponse
import aws.sdk.kotlin.services.vpclattice.model.DeleteServiceNetworkVpcAssociationRequest
import aws.sdk.kotlin.services.vpclattice.model.DeleteServiceNetworkVpcAssociationResponse
import aws.sdk.kotlin.services.vpclattice.model.DeleteServiceRequest
import aws.sdk.kotlin.services.vpclattice.model.DeleteServiceResponse
import aws.sdk.kotlin.services.vpclattice.model.DeleteTargetGroupRequest
import aws.sdk.kotlin.services.vpclattice.model.DeleteTargetGroupResponse
import aws.sdk.kotlin.services.vpclattice.model.DeregisterTargetsRequest
import aws.sdk.kotlin.services.vpclattice.model.DeregisterTargetsResponse
import aws.sdk.kotlin.services.vpclattice.model.GetAccessLogSubscriptionRequest
import aws.sdk.kotlin.services.vpclattice.model.GetAccessLogSubscriptionResponse
import aws.sdk.kotlin.services.vpclattice.model.GetAuthPolicyRequest
import aws.sdk.kotlin.services.vpclattice.model.GetAuthPolicyResponse
import aws.sdk.kotlin.services.vpclattice.model.GetListenerRequest
import aws.sdk.kotlin.services.vpclattice.model.GetListenerResponse
import aws.sdk.kotlin.services.vpclattice.model.GetResourcePolicyRequest
import aws.sdk.kotlin.services.vpclattice.model.GetResourcePolicyResponse
import aws.sdk.kotlin.services.vpclattice.model.GetRuleRequest
import aws.sdk.kotlin.services.vpclattice.model.GetRuleResponse
import aws.sdk.kotlin.services.vpclattice.model.GetServiceNetworkRequest
import aws.sdk.kotlin.services.vpclattice.model.GetServiceNetworkResponse
import aws.sdk.kotlin.services.vpclattice.model.GetServiceNetworkServiceAssociationRequest
import aws.sdk.kotlin.services.vpclattice.model.GetServiceNetworkServiceAssociationResponse
import aws.sdk.kotlin.services.vpclattice.model.GetServiceNetworkVpcAssociationRequest
import aws.sdk.kotlin.services.vpclattice.model.GetServiceNetworkVpcAssociationResponse
import aws.sdk.kotlin.services.vpclattice.model.GetServiceRequest
import aws.sdk.kotlin.services.vpclattice.model.GetServiceResponse
import aws.sdk.kotlin.services.vpclattice.model.GetTargetGroupRequest
import aws.sdk.kotlin.services.vpclattice.model.GetTargetGroupResponse
import aws.sdk.kotlin.services.vpclattice.model.ListAccessLogSubscriptionsRequest
import aws.sdk.kotlin.services.vpclattice.model.ListAccessLogSubscriptionsResponse
import aws.sdk.kotlin.services.vpclattice.model.ListListenersRequest
import aws.sdk.kotlin.services.vpclattice.model.ListListenersResponse
import aws.sdk.kotlin.services.vpclattice.model.ListRulesRequest
import aws.sdk.kotlin.services.vpclattice.model.ListRulesResponse
import aws.sdk.kotlin.services.vpclattice.model.ListServiceNetworkServiceAssociationsRequest
import aws.sdk.kotlin.services.vpclattice.model.ListServiceNetworkServiceAssociationsResponse
import aws.sdk.kotlin.services.vpclattice.model.ListServiceNetworkVpcAssociationsRequest
import aws.sdk.kotlin.services.vpclattice.model.ListServiceNetworkVpcAssociationsResponse
import aws.sdk.kotlin.services.vpclattice.model.ListServiceNetworksRequest
import aws.sdk.kotlin.services.vpclattice.model.ListServiceNetworksResponse
import aws.sdk.kotlin.services.vpclattice.model.ListServicesRequest
import aws.sdk.kotlin.services.vpclattice.model.ListServicesResponse
import aws.sdk.kotlin.services.vpclattice.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.vpclattice.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.vpclattice.model.ListTargetGroupsRequest
import aws.sdk.kotlin.services.vpclattice.model.ListTargetGroupsResponse
import aws.sdk.kotlin.services.vpclattice.model.ListTargetsRequest
import aws.sdk.kotlin.services.vpclattice.model.ListTargetsResponse
import aws.sdk.kotlin.services.vpclattice.model.PutAuthPolicyRequest
import aws.sdk.kotlin.services.vpclattice.model.PutAuthPolicyResponse
import aws.sdk.kotlin.services.vpclattice.model.PutResourcePolicyRequest
import aws.sdk.kotlin.services.vpclattice.model.PutResourcePolicyResponse
import aws.sdk.kotlin.services.vpclattice.model.RegisterTargetsRequest
import aws.sdk.kotlin.services.vpclattice.model.RegisterTargetsResponse
import aws.sdk.kotlin.services.vpclattice.model.TagResourceRequest
import aws.sdk.kotlin.services.vpclattice.model.TagResourceResponse
import aws.sdk.kotlin.services.vpclattice.model.UntagResourceRequest
import aws.sdk.kotlin.services.vpclattice.model.UntagResourceResponse
import aws.sdk.kotlin.services.vpclattice.model.UpdateAccessLogSubscriptionRequest
import aws.sdk.kotlin.services.vpclattice.model.UpdateAccessLogSubscriptionResponse
import aws.sdk.kotlin.services.vpclattice.model.UpdateListenerRequest
import aws.sdk.kotlin.services.vpclattice.model.UpdateListenerResponse
import aws.sdk.kotlin.services.vpclattice.model.UpdateRuleRequest
import aws.sdk.kotlin.services.vpclattice.model.UpdateRuleResponse
import aws.sdk.kotlin.services.vpclattice.model.UpdateServiceNetworkRequest
import aws.sdk.kotlin.services.vpclattice.model.UpdateServiceNetworkResponse
import aws.sdk.kotlin.services.vpclattice.model.UpdateServiceNetworkVpcAssociationRequest
import aws.sdk.kotlin.services.vpclattice.model.UpdateServiceNetworkVpcAssociationResponse
import aws.sdk.kotlin.services.vpclattice.model.UpdateServiceRequest
import aws.sdk.kotlin.services.vpclattice.model.UpdateServiceResponse
import aws.sdk.kotlin.services.vpclattice.model.UpdateTargetGroupRequest
import aws.sdk.kotlin.services.vpclattice.model.UpdateTargetGroupResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "VPC Lattice"
public const val SdkVersion: String = "0.33.1-beta"

/**
 * Amazon VPC Lattice is a fully managed application networking service that you use to connect, secure, and monitor all of your services across multiple accounts and virtual private clouds (VPCs). Amazon VPC Lattice interconnects your microservices and legacy services within a logical boundary, so that you can discover and manage them more efficiently. For more information, see the [Amazon VPC Lattice User Guide](https://docs.aws.amazon.com/vpc-lattice/latest/ug/)
 */
public interface VpcLatticeClient : SdkClient {
    /**
     * VpcLatticeClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, VpcLatticeClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>) {
            builder.config.interceptors.add(0, ClockSkewInterceptor())
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "VpcLattice",
                "VPC_LATTICE",
                "vpc_lattice",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, VpcLatticeClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): VpcLatticeClient = DefaultVpcLatticeClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        public val authSchemeProvider: VpcLatticeAuthSchemeProvider = builder.authSchemeProvider ?: DefaultVpcLatticeAuthSchemeProvider
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: VpcLatticeEndpointProvider = builder.endpointProvider ?: DefaultVpcLatticeEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemeProvider = this@Config.authSchemeProvider
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "VPC Lattice"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: VpcLatticeAuthSchemeProvider? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: VpcLatticeEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Updates the listener rules in a batch. You can use this operation to change the priority of listener rules. This can be useful when bulk updating or swapping rule priority.
     */
    public suspend fun batchUpdateRule(input: BatchUpdateRuleRequest): BatchUpdateRuleResponse

    /**
     * Enables access logs to be sent to Amazon CloudWatch, Amazon S3, and Amazon Kinesis Data Firehose. The service network owner can use the access logs to audit the services in the network. The service network owner will only see access logs from clients and services that are associated with their service network. Access log entries represent traffic originated from VPCs associated with that network. For more information, see [Access logs](https://docs.aws.amazon.com/vpc-lattice/latest/ug/monitoring-access-logs.html) in the *Amazon VPC Lattice User Guide*.
     */
    public suspend fun createAccessLogSubscription(input: CreateAccessLogSubscriptionRequest): CreateAccessLogSubscriptionResponse

    /**
     * Creates a listener for a service. Before you start using your Amazon VPC Lattice service, you must add one or more listeners. A listener is a process that checks for connection requests to your services. For more information, see [Listeners](https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html) in the *Amazon VPC Lattice User Guide*.
     */
    public suspend fun createListener(input: CreateListenerRequest): CreateListenerResponse

    /**
     * Creates a listener rule. Each listener has a default rule for checking connection requests, but you can define additional rules. Each rule consists of a priority, one or more actions, and one or more conditions. For more information, see [Listener rules](https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules) in the *Amazon VPC Lattice User Guide*.
     */
    public suspend fun createRule(input: CreateRuleRequest): CreateRuleResponse

    /**
     * Creates a service. A service is any software application that can run on instances containers, or serverless functions within an account or virtual private cloud (VPC).
     *
     * For more information, see [Services](https://docs.aws.amazon.com/vpc-lattice/latest/ug/services.html) in the *Amazon VPC Lattice User Guide*.
     */
    public suspend fun createService(input: CreateServiceRequest): CreateServiceResponse

    /**
     * Creates a service network. A service network is a logical boundary for a collection of services. You can associate services and VPCs with a service network.
     *
     * For more information, see [Service networks](https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html) in the *Amazon VPC Lattice User Guide*.
     */
    public suspend fun createServiceNetwork(input: CreateServiceNetworkRequest): CreateServiceNetworkResponse

    /**
     * Associates a service with a service network.
     *
     * You can't use this operation if the service and service network are already associated or if there is a disassociation or deletion in progress. If the association fails, you can retry the operation by deleting the association and recreating it.
     *
     * You cannot associate a service and service network that are shared with a caller. The caller must own either the service or the service network.
     *
     * As a result of this operation, the association is created in the service network account and the association owner account.
     */
    public suspend fun createServiceNetworkServiceAssociation(input: CreateServiceNetworkServiceAssociationRequest): CreateServiceNetworkServiceAssociationResponse

    /**
     * Associates a VPC with a service network. When you associate a VPC with the service network, it enables all the resources within that VPC to be clients and communicate with other services in the service network. For more information, see [Manage VPC associations](https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-network-associations.html#service-network-vpc-associations) in the *Amazon VPC Lattice User Guide*.
     *
     * You can't use this operation if there is a disassociation in progress. If the association fails, retry by deleting the association and recreating it.
     *
     * As a result of this operation, the association gets created in the service network account and the VPC owner account.
     *
     * Once a security group is added to the VPC association it cannot be removed. You can add or update the security groups being used for the VPC association once a security group is attached. To remove all security groups you must reassociate the VPC.
     */
    public suspend fun createServiceNetworkVpcAssociation(input: CreateServiceNetworkVpcAssociationRequest): CreateServiceNetworkVpcAssociationResponse

    /**
     * Creates a target group. A target group is a collection of targets, or compute resources, that run your application or service. A target group can only be used by a single service.
     *
     * For more information, see [Target groups](https://docs.aws.amazon.com/vpc-lattice/latest/ug/target-groups.html) in the *Amazon VPC Lattice User Guide*.
     */
    public suspend fun createTargetGroup(input: CreateTargetGroupRequest): CreateTargetGroupResponse

    /**
     * Deletes the specified access log subscription.
     */
    public suspend fun deleteAccessLogSubscription(input: DeleteAccessLogSubscriptionRequest): DeleteAccessLogSubscriptionResponse

    /**
     * Deletes the specified auth policy. If an auth is set to `Amazon Web Services_IAM` and the auth policy is deleted, all requests will be denied by default. If you are trying to remove the auth policy completely, you must set the auth_type to `NONE`. If auth is enabled on the resource, but no auth policy is set, all requests will be denied.
     */
    public suspend fun deleteAuthPolicy(input: DeleteAuthPolicyRequest): DeleteAuthPolicyResponse

    /**
     * Deletes the specified listener.
     */
    public suspend fun deleteListener(input: DeleteListenerRequest): DeleteListenerResponse

    /**
     * Deletes the specified resource policy.
     */
    public suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse

    /**
     * Deletes a listener rule. Each listener has a default rule for checking connection requests, but you can define additional rules. Each rule consists of a priority, one or more actions, and one or more conditions. You can delete additional listener rules, but you cannot delete the default rule.
     *
     * For more information, see [Listener rules](https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules) in the *Amazon VPC Lattice User Guide*.
     */
    public suspend fun deleteRule(input: DeleteRuleRequest): DeleteRuleResponse

    /**
     * Deletes a service. A service can't be deleted if it's associated with a service network. If you delete a service, all resources related to the service, such as the resource policy, auth policy, listeners, listener rules, and access log subscriptions, are also deleted. For more information, see [Delete a service](https://docs.aws.amazon.com/vpc-lattice/latest/ug/services.html#delete-service) in the *Amazon VPC Lattice User Guide*.
     */
    public suspend fun deleteService(input: DeleteServiceRequest): DeleteServiceResponse

    /**
     * Deletes a service network. You can only delete the service network if there is no service or VPC associated with it. If you delete a service network, all resources related to the service network, such as the resource policy, auth policy, and access log subscriptions, are also deleted. For more information, see [Delete a service network](https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html#delete-service-network) in the *Amazon VPC Lattice User Guide*.
     */
    public suspend fun deleteServiceNetwork(input: DeleteServiceNetworkRequest): DeleteServiceNetworkResponse

    /**
     * Deletes the association between a specified service and the specific service network. This request will fail if an association is still in progress.
     */
    public suspend fun deleteServiceNetworkServiceAssociation(input: DeleteServiceNetworkServiceAssociationRequest): DeleteServiceNetworkServiceAssociationResponse

    /**
     * Disassociates the VPC from the service network. You can't disassociate the VPC if there is a create or update association in progress.
     */
    public suspend fun deleteServiceNetworkVpcAssociation(input: DeleteServiceNetworkVpcAssociationRequest): DeleteServiceNetworkVpcAssociationResponse

    /**
     * Deletes a target group. You can't delete a target group if it is used in a listener rule or if the target group creation is in progress.
     */
    public suspend fun deleteTargetGroup(input: DeleteTargetGroupRequest): DeleteTargetGroupResponse

    /**
     * Deregisters the specified targets from the specified target group.
     */
    public suspend fun deregisterTargets(input: DeregisterTargetsRequest): DeregisterTargetsResponse

    /**
     * Retrieves information about the specified access log subscription.
     */
    public suspend fun getAccessLogSubscription(input: GetAccessLogSubscriptionRequest): GetAccessLogSubscriptionResponse

    /**
     * Retrieves information about the auth policy for the specified service or service network.
     */
    public suspend fun getAuthPolicy(input: GetAuthPolicyRequest): GetAuthPolicyResponse

    /**
     * Retrieves information about the specified listener for the specified service.
     */
    public suspend fun getListener(input: GetListenerRequest): GetListenerResponse

    /**
     * Retrieves information about the resource policy. The resource policy is an IAM policy created by AWS RAM on behalf of the resource owner when they share a resource.
     */
    public suspend fun getResourcePolicy(input: GetResourcePolicyRequest): GetResourcePolicyResponse

    /**
     * Retrieves information about listener rules. You can also retrieve information about the default listener rule. For more information, see [Listener rules](https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules) in the *Amazon VPC Lattice User Guide*.
     */
    public suspend fun getRule(input: GetRuleRequest): GetRuleResponse

    /**
     * Retrieves information about the specified service.
     */
    public suspend fun getService(input: GetServiceRequest): GetServiceResponse

    /**
     * Retrieves information about the specified service network.
     */
    public suspend fun getServiceNetwork(input: GetServiceNetworkRequest): GetServiceNetworkResponse

    /**
     * Retrieves information about the specified association between a service network and a service.
     */
    public suspend fun getServiceNetworkServiceAssociation(input: GetServiceNetworkServiceAssociationRequest): GetServiceNetworkServiceAssociationResponse

    /**
     * Retrieves information about the association between a service network and a VPC.
     */
    public suspend fun getServiceNetworkVpcAssociation(input: GetServiceNetworkVpcAssociationRequest): GetServiceNetworkVpcAssociationResponse

    /**
     * Retrieves information about the specified target group.
     */
    public suspend fun getTargetGroup(input: GetTargetGroupRequest): GetTargetGroupResponse

    /**
     * Lists all access log subscriptions for the specified service network or service.
     */
    public suspend fun listAccessLogSubscriptions(input: ListAccessLogSubscriptionsRequest): ListAccessLogSubscriptionsResponse

    /**
     * Lists the listeners for the specified service.
     */
    public suspend fun listListeners(input: ListListenersRequest): ListListenersResponse

    /**
     * Lists the rules for the listener.
     */
    public suspend fun listRules(input: ListRulesRequest): ListRulesResponse

    /**
     * Lists the associations between the service network and the service. You can filter the list either by service or service network. You must provide either the service network identifier or the service identifier.
     *
     * Every association in Amazon VPC Lattice is given a unique Amazon Resource Name (ARN), such as when a service network is associated with a VPC or when a service is associated with a service network. If the association is for a resource that is shared with another account, the association will include the local account ID as the prefix in the ARN for each account the resource is shared with.
     */
    public suspend fun listServiceNetworkServiceAssociations(input: ListServiceNetworkServiceAssociationsRequest = ListServiceNetworkServiceAssociationsRequest { }): ListServiceNetworkServiceAssociationsResponse

    /**
     * Lists the service network and VPC associations. You can filter the list either by VPC or service network. You must provide either the service network identifier or the VPC identifier.
     */
    public suspend fun listServiceNetworkVpcAssociations(input: ListServiceNetworkVpcAssociationsRequest = ListServiceNetworkVpcAssociationsRequest { }): ListServiceNetworkVpcAssociationsResponse

    /**
     * Lists the service networks owned by the caller account or shared with the caller account. Also includes the account ID in the ARN to show which account owns the service network.
     */
    public suspend fun listServiceNetworks(input: ListServiceNetworksRequest = ListServiceNetworksRequest { }): ListServiceNetworksResponse

    /**
     * Lists the services owned by the caller account or shared with the caller account.
     */
    public suspend fun listServices(input: ListServicesRequest = ListServicesRequest { }): ListServicesResponse

    /**
     * Lists the tags for the specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists your target groups. You can narrow your search by using the filters below in your request.
     */
    public suspend fun listTargetGroups(input: ListTargetGroupsRequest = ListTargetGroupsRequest { }): ListTargetGroupsResponse

    /**
     * Lists the targets for the target group. By default, all targets are included. You can use this API to check the health status of targets. You can also ﬁlter the results by target.
     */
    public suspend fun listTargets(input: ListTargetsRequest): ListTargetsResponse

    /**
     * Creates or updates the auth policy.
     */
    public suspend fun putAuthPolicy(input: PutAuthPolicyRequest): PutAuthPolicyResponse

    /**
     * Attaches a resource-based permission policy to a service or service network. The policy must contain the same actions and condition statements as the Amazon Web Services Resource Access Manager permission for sharing services and service networks.
     */
    public suspend fun putResourcePolicy(input: PutResourcePolicyRequest): PutResourcePolicyResponse

    /**
     * Registers the targets with the target group. If it's a Lambda target, you can only have one target in a target group.
     */
    public suspend fun registerTargets(input: RegisterTargetsRequest): RegisterTargetsResponse

    /**
     * Adds the specified tags to the specified resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the specified tags from the specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the specified access log subscription.
     */
    public suspend fun updateAccessLogSubscription(input: UpdateAccessLogSubscriptionRequest): UpdateAccessLogSubscriptionResponse

    /**
     * Updates the specified listener for the specified service.
     */
    public suspend fun updateListener(input: UpdateListenerRequest): UpdateListenerResponse

    /**
     * Updates a rule for the listener. You can't modify a default listener rule. To modify a default listener rule, use `UpdateListener`.
     */
    public suspend fun updateRule(input: UpdateRuleRequest): UpdateRuleResponse

    /**
     * Updates the specified service.
     */
    public suspend fun updateService(input: UpdateServiceRequest): UpdateServiceResponse

    /**
     * Updates the specified service network.
     */
    public suspend fun updateServiceNetwork(input: UpdateServiceNetworkRequest): UpdateServiceNetworkResponse

    /**
     * Updates the service network and VPC association. Once you add a security group, it cannot be removed.
     */
    public suspend fun updateServiceNetworkVpcAssociation(input: UpdateServiceNetworkVpcAssociationRequest): UpdateServiceNetworkVpcAssociationResponse

    /**
     * Updates the specified target group.
     */
    public suspend fun updateTargetGroup(input: UpdateTargetGroupRequest): UpdateTargetGroupResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun VpcLatticeClient.withConfig(block: VpcLatticeClient.Config.Builder.() -> Unit): VpcLatticeClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultVpcLatticeClient(newConfig)
}

/**
 * Updates the listener rules in a batch. You can use this operation to change the priority of listener rules. This can be useful when bulk updating or swapping rule priority.
 */
public suspend inline fun VpcLatticeClient.batchUpdateRule(crossinline block: BatchUpdateRuleRequest.Builder.() -> Unit): BatchUpdateRuleResponse = batchUpdateRule(BatchUpdateRuleRequest.Builder().apply(block).build())

/**
 * Enables access logs to be sent to Amazon CloudWatch, Amazon S3, and Amazon Kinesis Data Firehose. The service network owner can use the access logs to audit the services in the network. The service network owner will only see access logs from clients and services that are associated with their service network. Access log entries represent traffic originated from VPCs associated with that network. For more information, see [Access logs](https://docs.aws.amazon.com/vpc-lattice/latest/ug/monitoring-access-logs.html) in the *Amazon VPC Lattice User Guide*.
 */
public suspend inline fun VpcLatticeClient.createAccessLogSubscription(crossinline block: CreateAccessLogSubscriptionRequest.Builder.() -> Unit): CreateAccessLogSubscriptionResponse = createAccessLogSubscription(CreateAccessLogSubscriptionRequest.Builder().apply(block).build())

/**
 * Creates a listener for a service. Before you start using your Amazon VPC Lattice service, you must add one or more listeners. A listener is a process that checks for connection requests to your services. For more information, see [Listeners](https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html) in the *Amazon VPC Lattice User Guide*.
 */
public suspend inline fun VpcLatticeClient.createListener(crossinline block: CreateListenerRequest.Builder.() -> Unit): CreateListenerResponse = createListener(CreateListenerRequest.Builder().apply(block).build())

/**
 * Creates a listener rule. Each listener has a default rule for checking connection requests, but you can define additional rules. Each rule consists of a priority, one or more actions, and one or more conditions. For more information, see [Listener rules](https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules) in the *Amazon VPC Lattice User Guide*.
 */
public suspend inline fun VpcLatticeClient.createRule(crossinline block: CreateRuleRequest.Builder.() -> Unit): CreateRuleResponse = createRule(CreateRuleRequest.Builder().apply(block).build())

/**
 * Creates a service. A service is any software application that can run on instances containers, or serverless functions within an account or virtual private cloud (VPC).
 *
 * For more information, see [Services](https://docs.aws.amazon.com/vpc-lattice/latest/ug/services.html) in the *Amazon VPC Lattice User Guide*.
 */
public suspend inline fun VpcLatticeClient.createService(crossinline block: CreateServiceRequest.Builder.() -> Unit): CreateServiceResponse = createService(CreateServiceRequest.Builder().apply(block).build())

/**
 * Creates a service network. A service network is a logical boundary for a collection of services. You can associate services and VPCs with a service network.
 *
 * For more information, see [Service networks](https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html) in the *Amazon VPC Lattice User Guide*.
 */
public suspend inline fun VpcLatticeClient.createServiceNetwork(crossinline block: CreateServiceNetworkRequest.Builder.() -> Unit): CreateServiceNetworkResponse = createServiceNetwork(CreateServiceNetworkRequest.Builder().apply(block).build())

/**
 * Associates a service with a service network.
 *
 * You can't use this operation if the service and service network are already associated or if there is a disassociation or deletion in progress. If the association fails, you can retry the operation by deleting the association and recreating it.
 *
 * You cannot associate a service and service network that are shared with a caller. The caller must own either the service or the service network.
 *
 * As a result of this operation, the association is created in the service network account and the association owner account.
 */
public suspend inline fun VpcLatticeClient.createServiceNetworkServiceAssociation(crossinline block: CreateServiceNetworkServiceAssociationRequest.Builder.() -> Unit): CreateServiceNetworkServiceAssociationResponse = createServiceNetworkServiceAssociation(CreateServiceNetworkServiceAssociationRequest.Builder().apply(block).build())

/**
 * Associates a VPC with a service network. When you associate a VPC with the service network, it enables all the resources within that VPC to be clients and communicate with other services in the service network. For more information, see [Manage VPC associations](https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-network-associations.html#service-network-vpc-associations) in the *Amazon VPC Lattice User Guide*.
 *
 * You can't use this operation if there is a disassociation in progress. If the association fails, retry by deleting the association and recreating it.
 *
 * As a result of this operation, the association gets created in the service network account and the VPC owner account.
 *
 * Once a security group is added to the VPC association it cannot be removed. You can add or update the security groups being used for the VPC association once a security group is attached. To remove all security groups you must reassociate the VPC.
 */
public suspend inline fun VpcLatticeClient.createServiceNetworkVpcAssociation(crossinline block: CreateServiceNetworkVpcAssociationRequest.Builder.() -> Unit): CreateServiceNetworkVpcAssociationResponse = createServiceNetworkVpcAssociation(CreateServiceNetworkVpcAssociationRequest.Builder().apply(block).build())

/**
 * Creates a target group. A target group is a collection of targets, or compute resources, that run your application or service. A target group can only be used by a single service.
 *
 * For more information, see [Target groups](https://docs.aws.amazon.com/vpc-lattice/latest/ug/target-groups.html) in the *Amazon VPC Lattice User Guide*.
 */
public suspend inline fun VpcLatticeClient.createTargetGroup(crossinline block: CreateTargetGroupRequest.Builder.() -> Unit): CreateTargetGroupResponse = createTargetGroup(CreateTargetGroupRequest.Builder().apply(block).build())

/**
 * Deletes the specified access log subscription.
 */
public suspend inline fun VpcLatticeClient.deleteAccessLogSubscription(crossinline block: DeleteAccessLogSubscriptionRequest.Builder.() -> Unit): DeleteAccessLogSubscriptionResponse = deleteAccessLogSubscription(DeleteAccessLogSubscriptionRequest.Builder().apply(block).build())

/**
 * Deletes the specified auth policy. If an auth is set to `Amazon Web Services_IAM` and the auth policy is deleted, all requests will be denied by default. If you are trying to remove the auth policy completely, you must set the auth_type to `NONE`. If auth is enabled on the resource, but no auth policy is set, all requests will be denied.
 */
public suspend inline fun VpcLatticeClient.deleteAuthPolicy(crossinline block: DeleteAuthPolicyRequest.Builder.() -> Unit): DeleteAuthPolicyResponse = deleteAuthPolicy(DeleteAuthPolicyRequest.Builder().apply(block).build())

/**
 * Deletes the specified listener.
 */
public suspend inline fun VpcLatticeClient.deleteListener(crossinline block: DeleteListenerRequest.Builder.() -> Unit): DeleteListenerResponse = deleteListener(DeleteListenerRequest.Builder().apply(block).build())

/**
 * Deletes the specified resource policy.
 */
public suspend inline fun VpcLatticeClient.deleteResourcePolicy(crossinline block: DeleteResourcePolicyRequest.Builder.() -> Unit): DeleteResourcePolicyResponse = deleteResourcePolicy(DeleteResourcePolicyRequest.Builder().apply(block).build())

/**
 * Deletes a listener rule. Each listener has a default rule for checking connection requests, but you can define additional rules. Each rule consists of a priority, one or more actions, and one or more conditions. You can delete additional listener rules, but you cannot delete the default rule.
 *
 * For more information, see [Listener rules](https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules) in the *Amazon VPC Lattice User Guide*.
 */
public suspend inline fun VpcLatticeClient.deleteRule(crossinline block: DeleteRuleRequest.Builder.() -> Unit): DeleteRuleResponse = deleteRule(DeleteRuleRequest.Builder().apply(block).build())

/**
 * Deletes a service. A service can't be deleted if it's associated with a service network. If you delete a service, all resources related to the service, such as the resource policy, auth policy, listeners, listener rules, and access log subscriptions, are also deleted. For more information, see [Delete a service](https://docs.aws.amazon.com/vpc-lattice/latest/ug/services.html#delete-service) in the *Amazon VPC Lattice User Guide*.
 */
public suspend inline fun VpcLatticeClient.deleteService(crossinline block: DeleteServiceRequest.Builder.() -> Unit): DeleteServiceResponse = deleteService(DeleteServiceRequest.Builder().apply(block).build())

/**
 * Deletes a service network. You can only delete the service network if there is no service or VPC associated with it. If you delete a service network, all resources related to the service network, such as the resource policy, auth policy, and access log subscriptions, are also deleted. For more information, see [Delete a service network](https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html#delete-service-network) in the *Amazon VPC Lattice User Guide*.
 */
public suspend inline fun VpcLatticeClient.deleteServiceNetwork(crossinline block: DeleteServiceNetworkRequest.Builder.() -> Unit): DeleteServiceNetworkResponse = deleteServiceNetwork(DeleteServiceNetworkRequest.Builder().apply(block).build())

/**
 * Deletes the association between a specified service and the specific service network. This request will fail if an association is still in progress.
 */
public suspend inline fun VpcLatticeClient.deleteServiceNetworkServiceAssociation(crossinline block: DeleteServiceNetworkServiceAssociationRequest.Builder.() -> Unit): DeleteServiceNetworkServiceAssociationResponse = deleteServiceNetworkServiceAssociation(DeleteServiceNetworkServiceAssociationRequest.Builder().apply(block).build())

/**
 * Disassociates the VPC from the service network. You can't disassociate the VPC if there is a create or update association in progress.
 */
public suspend inline fun VpcLatticeClient.deleteServiceNetworkVpcAssociation(crossinline block: DeleteServiceNetworkVpcAssociationRequest.Builder.() -> Unit): DeleteServiceNetworkVpcAssociationResponse = deleteServiceNetworkVpcAssociation(DeleteServiceNetworkVpcAssociationRequest.Builder().apply(block).build())

/**
 * Deletes a target group. You can't delete a target group if it is used in a listener rule or if the target group creation is in progress.
 */
public suspend inline fun VpcLatticeClient.deleteTargetGroup(crossinline block: DeleteTargetGroupRequest.Builder.() -> Unit): DeleteTargetGroupResponse = deleteTargetGroup(DeleteTargetGroupRequest.Builder().apply(block).build())

/**
 * Deregisters the specified targets from the specified target group.
 */
public suspend inline fun VpcLatticeClient.deregisterTargets(crossinline block: DeregisterTargetsRequest.Builder.() -> Unit): DeregisterTargetsResponse = deregisterTargets(DeregisterTargetsRequest.Builder().apply(block).build())

/**
 * Retrieves information about the specified access log subscription.
 */
public suspend inline fun VpcLatticeClient.getAccessLogSubscription(crossinline block: GetAccessLogSubscriptionRequest.Builder.() -> Unit): GetAccessLogSubscriptionResponse = getAccessLogSubscription(GetAccessLogSubscriptionRequest.Builder().apply(block).build())

/**
 * Retrieves information about the auth policy for the specified service or service network.
 */
public suspend inline fun VpcLatticeClient.getAuthPolicy(crossinline block: GetAuthPolicyRequest.Builder.() -> Unit): GetAuthPolicyResponse = getAuthPolicy(GetAuthPolicyRequest.Builder().apply(block).build())

/**
 * Retrieves information about the specified listener for the specified service.
 */
public suspend inline fun VpcLatticeClient.getListener(crossinline block: GetListenerRequest.Builder.() -> Unit): GetListenerResponse = getListener(GetListenerRequest.Builder().apply(block).build())

/**
 * Retrieves information about the resource policy. The resource policy is an IAM policy created by AWS RAM on behalf of the resource owner when they share a resource.
 */
public suspend inline fun VpcLatticeClient.getResourcePolicy(crossinline block: GetResourcePolicyRequest.Builder.() -> Unit): GetResourcePolicyResponse = getResourcePolicy(GetResourcePolicyRequest.Builder().apply(block).build())

/**
 * Retrieves information about listener rules. You can also retrieve information about the default listener rule. For more information, see [Listener rules](https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules) in the *Amazon VPC Lattice User Guide*.
 */
public suspend inline fun VpcLatticeClient.getRule(crossinline block: GetRuleRequest.Builder.() -> Unit): GetRuleResponse = getRule(GetRuleRequest.Builder().apply(block).build())

/**
 * Retrieves information about the specified service.
 */
public suspend inline fun VpcLatticeClient.getService(crossinline block: GetServiceRequest.Builder.() -> Unit): GetServiceResponse = getService(GetServiceRequest.Builder().apply(block).build())

/**
 * Retrieves information about the specified service network.
 */
public suspend inline fun VpcLatticeClient.getServiceNetwork(crossinline block: GetServiceNetworkRequest.Builder.() -> Unit): GetServiceNetworkResponse = getServiceNetwork(GetServiceNetworkRequest.Builder().apply(block).build())

/**
 * Retrieves information about the specified association between a service network and a service.
 */
public suspend inline fun VpcLatticeClient.getServiceNetworkServiceAssociation(crossinline block: GetServiceNetworkServiceAssociationRequest.Builder.() -> Unit): GetServiceNetworkServiceAssociationResponse = getServiceNetworkServiceAssociation(GetServiceNetworkServiceAssociationRequest.Builder().apply(block).build())

/**
 * Retrieves information about the association between a service network and a VPC.
 */
public suspend inline fun VpcLatticeClient.getServiceNetworkVpcAssociation(crossinline block: GetServiceNetworkVpcAssociationRequest.Builder.() -> Unit): GetServiceNetworkVpcAssociationResponse = getServiceNetworkVpcAssociation(GetServiceNetworkVpcAssociationRequest.Builder().apply(block).build())

/**
 * Retrieves information about the specified target group.
 */
public suspend inline fun VpcLatticeClient.getTargetGroup(crossinline block: GetTargetGroupRequest.Builder.() -> Unit): GetTargetGroupResponse = getTargetGroup(GetTargetGroupRequest.Builder().apply(block).build())

/**
 * Lists all access log subscriptions for the specified service network or service.
 */
public suspend inline fun VpcLatticeClient.listAccessLogSubscriptions(crossinline block: ListAccessLogSubscriptionsRequest.Builder.() -> Unit): ListAccessLogSubscriptionsResponse = listAccessLogSubscriptions(ListAccessLogSubscriptionsRequest.Builder().apply(block).build())

/**
 * Lists the listeners for the specified service.
 */
public suspend inline fun VpcLatticeClient.listListeners(crossinline block: ListListenersRequest.Builder.() -> Unit): ListListenersResponse = listListeners(ListListenersRequest.Builder().apply(block).build())

/**
 * Lists the rules for the listener.
 */
public suspend inline fun VpcLatticeClient.listRules(crossinline block: ListRulesRequest.Builder.() -> Unit): ListRulesResponse = listRules(ListRulesRequest.Builder().apply(block).build())

/**
 * Lists the associations between the service network and the service. You can filter the list either by service or service network. You must provide either the service network identifier or the service identifier.
 *
 * Every association in Amazon VPC Lattice is given a unique Amazon Resource Name (ARN), such as when a service network is associated with a VPC or when a service is associated with a service network. If the association is for a resource that is shared with another account, the association will include the local account ID as the prefix in the ARN for each account the resource is shared with.
 */
public suspend inline fun VpcLatticeClient.listServiceNetworkServiceAssociations(crossinline block: ListServiceNetworkServiceAssociationsRequest.Builder.() -> Unit): ListServiceNetworkServiceAssociationsResponse = listServiceNetworkServiceAssociations(ListServiceNetworkServiceAssociationsRequest.Builder().apply(block).build())

/**
 * Lists the service network and VPC associations. You can filter the list either by VPC or service network. You must provide either the service network identifier or the VPC identifier.
 */
public suspend inline fun VpcLatticeClient.listServiceNetworkVpcAssociations(crossinline block: ListServiceNetworkVpcAssociationsRequest.Builder.() -> Unit): ListServiceNetworkVpcAssociationsResponse = listServiceNetworkVpcAssociations(ListServiceNetworkVpcAssociationsRequest.Builder().apply(block).build())

/**
 * Lists the service networks owned by the caller account or shared with the caller account. Also includes the account ID in the ARN to show which account owns the service network.
 */
public suspend inline fun VpcLatticeClient.listServiceNetworks(crossinline block: ListServiceNetworksRequest.Builder.() -> Unit): ListServiceNetworksResponse = listServiceNetworks(ListServiceNetworksRequest.Builder().apply(block).build())

/**
 * Lists the services owned by the caller account or shared with the caller account.
 */
public suspend inline fun VpcLatticeClient.listServices(crossinline block: ListServicesRequest.Builder.() -> Unit): ListServicesResponse = listServices(ListServicesRequest.Builder().apply(block).build())

/**
 * Lists the tags for the specified resource.
 */
public suspend inline fun VpcLatticeClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists your target groups. You can narrow your search by using the filters below in your request.
 */
public suspend inline fun VpcLatticeClient.listTargetGroups(crossinline block: ListTargetGroupsRequest.Builder.() -> Unit): ListTargetGroupsResponse = listTargetGroups(ListTargetGroupsRequest.Builder().apply(block).build())

/**
 * Lists the targets for the target group. By default, all targets are included. You can use this API to check the health status of targets. You can also ﬁlter the results by target.
 */
public suspend inline fun VpcLatticeClient.listTargets(crossinline block: ListTargetsRequest.Builder.() -> Unit): ListTargetsResponse = listTargets(ListTargetsRequest.Builder().apply(block).build())

/**
 * Creates or updates the auth policy.
 */
public suspend inline fun VpcLatticeClient.putAuthPolicy(crossinline block: PutAuthPolicyRequest.Builder.() -> Unit): PutAuthPolicyResponse = putAuthPolicy(PutAuthPolicyRequest.Builder().apply(block).build())

/**
 * Attaches a resource-based permission policy to a service or service network. The policy must contain the same actions and condition statements as the Amazon Web Services Resource Access Manager permission for sharing services and service networks.
 */
public suspend inline fun VpcLatticeClient.putResourcePolicy(crossinline block: PutResourcePolicyRequest.Builder.() -> Unit): PutResourcePolicyResponse = putResourcePolicy(PutResourcePolicyRequest.Builder().apply(block).build())

/**
 * Registers the targets with the target group. If it's a Lambda target, you can only have one target in a target group.
 */
public suspend inline fun VpcLatticeClient.registerTargets(crossinline block: RegisterTargetsRequest.Builder.() -> Unit): RegisterTargetsResponse = registerTargets(RegisterTargetsRequest.Builder().apply(block).build())

/**
 * Adds the specified tags to the specified resource.
 */
public suspend inline fun VpcLatticeClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the specified resource.
 */
public suspend inline fun VpcLatticeClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the specified access log subscription.
 */
public suspend inline fun VpcLatticeClient.updateAccessLogSubscription(crossinline block: UpdateAccessLogSubscriptionRequest.Builder.() -> Unit): UpdateAccessLogSubscriptionResponse = updateAccessLogSubscription(UpdateAccessLogSubscriptionRequest.Builder().apply(block).build())

/**
 * Updates the specified listener for the specified service.
 */
public suspend inline fun VpcLatticeClient.updateListener(crossinline block: UpdateListenerRequest.Builder.() -> Unit): UpdateListenerResponse = updateListener(UpdateListenerRequest.Builder().apply(block).build())

/**
 * Updates a rule for the listener. You can't modify a default listener rule. To modify a default listener rule, use `UpdateListener`.
 */
public suspend inline fun VpcLatticeClient.updateRule(crossinline block: UpdateRuleRequest.Builder.() -> Unit): UpdateRuleResponse = updateRule(UpdateRuleRequest.Builder().apply(block).build())

/**
 * Updates the specified service.
 */
public suspend inline fun VpcLatticeClient.updateService(crossinline block: UpdateServiceRequest.Builder.() -> Unit): UpdateServiceResponse = updateService(UpdateServiceRequest.Builder().apply(block).build())

/**
 * Updates the specified service network.
 */
public suspend inline fun VpcLatticeClient.updateServiceNetwork(crossinline block: UpdateServiceNetworkRequest.Builder.() -> Unit): UpdateServiceNetworkResponse = updateServiceNetwork(UpdateServiceNetworkRequest.Builder().apply(block).build())

/**
 * Updates the service network and VPC association. Once you add a security group, it cannot be removed.
 */
public suspend inline fun VpcLatticeClient.updateServiceNetworkVpcAssociation(crossinline block: UpdateServiceNetworkVpcAssociationRequest.Builder.() -> Unit): UpdateServiceNetworkVpcAssociationResponse = updateServiceNetworkVpcAssociation(UpdateServiceNetworkVpcAssociationRequest.Builder().apply(block).build())

/**
 * Updates the specified target group.
 */
public suspend inline fun VpcLatticeClient.updateTargetGroup(crossinline block: UpdateTargetGroupRequest.Builder.() -> Unit): UpdateTargetGroupResponse = updateTargetGroup(UpdateTargetGroupRequest.Builder().apply(block).build())
