// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.voiceid.serde

import aws.sdk.kotlin.services.voiceid.model.AuthenticationResult
import aws.sdk.kotlin.services.voiceid.model.EvaluateSessionResponse
import aws.sdk.kotlin.services.voiceid.model.FraudDetectionResult
import aws.sdk.kotlin.services.voiceid.model.StreamingStatus
import aws.sdk.kotlin.services.voiceid.model.VoiceIdException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class EvaluateSessionOperationDeserializer: HttpDeserializer.NonStreaming<EvaluateSessionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): EvaluateSessionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwEvaluateSessionError(context, call, payload)
        }
        val builder = EvaluateSessionResponse.Builder()

        if (payload != null) {
            deserializeEvaluateSessionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwEvaluateSessionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw VoiceIdException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> VoiceIdException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeEvaluateSessionOperationBody(builder: EvaluateSessionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTHENTICATIONRESULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AuthenticationResult"))
    val DOMAINID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DomainId"))
    val FRAUDDETECTIONRESULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FraudDetectionResult"))
    val SESSIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SessionId"))
    val SESSIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SessionName"))
    val STREAMINGSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StreamingStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHENTICATIONRESULT_DESCRIPTOR)
        field(DOMAINID_DESCRIPTOR)
        field(FRAUDDETECTIONRESULT_DESCRIPTOR)
        field(SESSIONID_DESCRIPTOR)
        field(SESSIONNAME_DESCRIPTOR)
        field(STREAMINGSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTHENTICATIONRESULT_DESCRIPTOR.index -> builder.authenticationResult = deserializeAuthenticationResultDocument(deserializer)
                DOMAINID_DESCRIPTOR.index -> builder.domainId = deserializeString()
                FRAUDDETECTIONRESULT_DESCRIPTOR.index -> builder.fraudDetectionResult = deserializeFraudDetectionResultDocument(deserializer)
                SESSIONID_DESCRIPTOR.index -> builder.sessionId = deserializeString()
                SESSIONNAME_DESCRIPTOR.index -> builder.sessionName = deserializeString()
                STREAMINGSTATUS_DESCRIPTOR.index -> builder.streamingStatus = deserializeString().let { StreamingStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
