// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.voiceid.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartFraudsterRegistrationJobRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets to read the input manifest file and write the Job output file. Refer to the [Create and edit a fraudster watchlist](https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-fraudster-watchlist.html) documentation for the permissions needed in this role.
     */
    public val dataAccessRoleArn: kotlin.String = requireNotNull(builder.dataAccessRoleArn) { "A non-null value must be provided for dataAccessRoleArn" }
    /**
     * The identifier of the domain that contains the fraudster registration job and in which the fraudsters are registered.
     */
    public val domainId: kotlin.String = requireNotNull(builder.domainId) { "A non-null value must be provided for domainId" }
    /**
     * The input data config containing an S3 URI for the input manifest file that contains the list of fraudster registration requests.
     */
    public val inputDataConfig: aws.sdk.kotlin.services.voiceid.model.InputDataConfig? = builder.inputDataConfig
    /**
     * The name of the new fraudster registration job.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * The output data config containing the S3 location where Voice ID writes the job output file; you must also include a KMS key ID to encrypt the file.
     */
    public val outputDataConfig: aws.sdk.kotlin.services.voiceid.model.OutputDataConfig? = builder.outputDataConfig
    /**
     * The registration config containing details such as the action to take when a duplicate fraudster is detected, and the similarity threshold to use for detecting a duplicate fraudster.
     */
    public val registrationConfig: aws.sdk.kotlin.services.voiceid.model.RegistrationConfig? = builder.registrationConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.voiceid.model.StartFraudsterRegistrationJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartFraudsterRegistrationJobRequest(")
        append("clientToken=$clientToken,")
        append("dataAccessRoleArn=$dataAccessRoleArn,")
        append("domainId=$domainId,")
        append("inputDataConfig=$inputDataConfig,")
        append("jobName=*** Sensitive Data Redacted ***,")
        append("outputDataConfig=$outputDataConfig,")
        append("registrationConfig=$registrationConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (dataAccessRoleArn.hashCode())
        result = 31 * result + (domainId.hashCode())
        result = 31 * result + (inputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (registrationConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartFraudsterRegistrationJobRequest

        if (clientToken != other.clientToken) return false
        if (dataAccessRoleArn != other.dataAccessRoleArn) return false
        if (domainId != other.domainId) return false
        if (inputDataConfig != other.inputDataConfig) return false
        if (jobName != other.jobName) return false
        if (outputDataConfig != other.outputDataConfig) return false
        if (registrationConfig != other.registrationConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.voiceid.model.StartFraudsterRegistrationJobRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see [Making retries safe with idempotent APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
         */
        public var clientToken: kotlin.String? = null
        /**
         * The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets to read the input manifest file and write the Job output file. Refer to the [Create and edit a fraudster watchlist](https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-fraudster-watchlist.html) documentation for the permissions needed in this role.
         */
        public var dataAccessRoleArn: kotlin.String? = null
        /**
         * The identifier of the domain that contains the fraudster registration job and in which the fraudsters are registered.
         */
        public var domainId: kotlin.String? = null
        /**
         * The input data config containing an S3 URI for the input manifest file that contains the list of fraudster registration requests.
         */
        public var inputDataConfig: aws.sdk.kotlin.services.voiceid.model.InputDataConfig? = null
        /**
         * The name of the new fraudster registration job.
         */
        public var jobName: kotlin.String? = null
        /**
         * The output data config containing the S3 location where Voice ID writes the job output file; you must also include a KMS key ID to encrypt the file.
         */
        public var outputDataConfig: aws.sdk.kotlin.services.voiceid.model.OutputDataConfig? = null
        /**
         * The registration config containing details such as the action to take when a duplicate fraudster is detected, and the similarity threshold to use for detecting a duplicate fraudster.
         */
        public var registrationConfig: aws.sdk.kotlin.services.voiceid.model.RegistrationConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.voiceid.model.StartFraudsterRegistrationJobRequest) : this() {
            this.clientToken = x.clientToken
            this.dataAccessRoleArn = x.dataAccessRoleArn
            this.domainId = x.domainId
            this.inputDataConfig = x.inputDataConfig
            this.jobName = x.jobName
            this.outputDataConfig = x.outputDataConfig
            this.registrationConfig = x.registrationConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.voiceid.model.StartFraudsterRegistrationJobRequest = StartFraudsterRegistrationJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.voiceid.model.InputDataConfig] inside the given [block]
         */
        public fun inputDataConfig(block: aws.sdk.kotlin.services.voiceid.model.InputDataConfig.Builder.() -> kotlin.Unit) {
            this.inputDataConfig = aws.sdk.kotlin.services.voiceid.model.InputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.voiceid.model.OutputDataConfig] inside the given [block]
         */
        public fun outputDataConfig(block: aws.sdk.kotlin.services.voiceid.model.OutputDataConfig.Builder.() -> kotlin.Unit) {
            this.outputDataConfig = aws.sdk.kotlin.services.voiceid.model.OutputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.voiceid.model.RegistrationConfig] inside the given [block]
         */
        public fun registrationConfig(block: aws.sdk.kotlin.services.voiceid.model.RegistrationConfig.Builder.() -> kotlin.Unit) {
            this.registrationConfig = aws.sdk.kotlin.services.voiceid.model.RegistrationConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (dataAccessRoleArn == null) dataAccessRoleArn = ""
            if (domainId == null) domainId = ""
            return this
        }
    }
}
