// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.voiceid.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The registration configuration to be used during the batch fraudster registration job.
 */
public class RegistrationConfig private constructor(builder: Builder) {
    /**
     * The action to take when a fraudster is identified as a duplicate. The default action is `SKIP`, which skips registering the duplicate fraudster. Setting the value to `REGISTER_AS_NEW` always registers a new fraudster into the specified domain.
     */
    public val duplicateRegistrationAction: aws.sdk.kotlin.services.voiceid.model.DuplicateRegistrationAction? = builder.duplicateRegistrationAction
    /**
     * The minimum similarity score between the new and old fraudsters in order to consider the new fraudster a duplicate.
     */
    public val fraudsterSimilarityThreshold: kotlin.Int? = builder.fraudsterSimilarityThreshold
    /**
     * The identifiers of watchlists that a fraudster is registered to. If a watchlist isn't provided, the fraudsters are registered to the default watchlist.
     */
    public val watchlistIds: List<String>? = builder.watchlistIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.voiceid.model.RegistrationConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegistrationConfig(")
        append("duplicateRegistrationAction=$duplicateRegistrationAction,")
        append("fraudsterSimilarityThreshold=$fraudsterSimilarityThreshold,")
        append("watchlistIds=$watchlistIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = duplicateRegistrationAction?.hashCode() ?: 0
        result = 31 * result + (fraudsterSimilarityThreshold ?: 0)
        result = 31 * result + (watchlistIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegistrationConfig

        if (duplicateRegistrationAction != other.duplicateRegistrationAction) return false
        if (fraudsterSimilarityThreshold != other.fraudsterSimilarityThreshold) return false
        if (watchlistIds != other.watchlistIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.voiceid.model.RegistrationConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The action to take when a fraudster is identified as a duplicate. The default action is `SKIP`, which skips registering the duplicate fraudster. Setting the value to `REGISTER_AS_NEW` always registers a new fraudster into the specified domain.
         */
        public var duplicateRegistrationAction: aws.sdk.kotlin.services.voiceid.model.DuplicateRegistrationAction? = null
        /**
         * The minimum similarity score between the new and old fraudsters in order to consider the new fraudster a duplicate.
         */
        public var fraudsterSimilarityThreshold: kotlin.Int? = null
        /**
         * The identifiers of watchlists that a fraudster is registered to. If a watchlist isn't provided, the fraudsters are registered to the default watchlist.
         */
        public var watchlistIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.voiceid.model.RegistrationConfig) : this() {
            this.duplicateRegistrationAction = x.duplicateRegistrationAction
            this.fraudsterSimilarityThreshold = x.fraudsterSimilarityThreshold
            this.watchlistIds = x.watchlistIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.voiceid.model.RegistrationConfig = RegistrationConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
