// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.voiceid.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration containing output file information for a batch job.
 */
public class OutputDataConfig private constructor(builder: Builder) {
    /**
     * The identifier of the KMS key you want Voice ID to use to encrypt the output file of a speaker enrollment job/fraudster registration job.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The S3 path of the folder where Voice ID writes the job output file. It has a `*.out` extension. For example, if the input file name is `input-file.json` and the output folder path is `s3://output-bucket/output-folder`, the full output file path is `s3://output-bucket/output-folder/job-Id/input-file.json.out`.
     */
    public val s3Uri: kotlin.String = requireNotNull(builder.s3Uri) { "A non-null value must be provided for s3Uri" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.voiceid.model.OutputDataConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OutputDataConfig(")
        append("kmsKeyId=$kmsKeyId,")
        append("s3Uri=$s3Uri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyId?.hashCode() ?: 0
        result = 31 * result + (s3Uri.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OutputDataConfig

        if (kmsKeyId != other.kmsKeyId) return false
        if (s3Uri != other.s3Uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.voiceid.model.OutputDataConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the KMS key you want Voice ID to use to encrypt the output file of a speaker enrollment job/fraudster registration job.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The S3 path of the folder where Voice ID writes the job output file. It has a `*.out` extension. For example, if the input file name is `input-file.json` and the output folder path is `s3://output-bucket/output-folder`, the full output file path is `s3://output-bucket/output-folder/job-Id/input-file.json.out`.
         */
        public var s3Uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.voiceid.model.OutputDataConfig) : this() {
            this.kmsKeyId = x.kmsKeyId
            this.s3Uri = x.s3Uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.voiceid.model.OutputDataConfig = OutputDataConfig(this)

        internal fun correctErrors(): Builder {
            if (s3Uri == null) s3Uri = ""
            return this
        }
    }
}
