// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.voiceid.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration used for performing fraud detection over a speaker during a session.
 */
public class FraudDetectionConfiguration private constructor(builder: Builder) {
    /**
     * Threshold value for determining whether the speaker is a fraudster. If the detected risk score calculated by Voice ID is higher than the threshold, the speaker is considered a fraudster.
     */
    public val riskThreshold: kotlin.Int? = builder.riskThreshold
    /**
     * The identifier of the watchlist against which fraud detection is performed.
     */
    public val watchlistId: kotlin.String? = builder.watchlistId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.voiceid.model.FraudDetectionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FraudDetectionConfiguration(")
        append("riskThreshold=$riskThreshold,")
        append("watchlistId=$watchlistId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = riskThreshold ?: 0
        result = 31 * result + (watchlistId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FraudDetectionConfiguration

        if (riskThreshold != other.riskThreshold) return false
        if (watchlistId != other.watchlistId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.voiceid.model.FraudDetectionConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Threshold value for determining whether the speaker is a fraudster. If the detected risk score calculated by Voice ID is higher than the threshold, the speaker is considered a fraudster.
         */
        public var riskThreshold: kotlin.Int? = null
        /**
         * The identifier of the watchlist against which fraud detection is performed.
         */
        public var watchlistId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.voiceid.model.FraudDetectionConfiguration) : this() {
            this.riskThreshold = x.riskThreshold
            this.watchlistId = x.watchlistId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.voiceid.model.FraudDetectionConfiguration = FraudDetectionConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
