// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.voiceid.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The fraud detection configuration to be used during the batch speaker enrollment job.
 */
public class EnrollmentJobFraudDetectionConfig private constructor(builder: Builder) {
    /**
     * The action to take when the given speaker is flagged by the fraud detection system. The default value is `FAIL`, which fails the speaker enrollment. Changing this value to `IGNORE` results in the speaker being enrolled even if they are flagged by the fraud detection system.
     */
    public val fraudDetectionAction: aws.sdk.kotlin.services.voiceid.model.FraudDetectionAction? = builder.fraudDetectionAction
    /**
     * Threshold value for determining whether the speaker is a high risk to be fraudulent. If the detected risk score calculated by Voice ID is greater than or equal to the threshold, the speaker is considered a fraudster.
     */
    public val riskThreshold: kotlin.Int? = builder.riskThreshold
    /**
     * The identifier of watchlists against which fraud detection is performed.
     */
    public val watchlistIds: List<String>? = builder.watchlistIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.voiceid.model.EnrollmentJobFraudDetectionConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EnrollmentJobFraudDetectionConfig(")
        append("fraudDetectionAction=$fraudDetectionAction,")
        append("riskThreshold=$riskThreshold,")
        append("watchlistIds=$watchlistIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fraudDetectionAction?.hashCode() ?: 0
        result = 31 * result + (riskThreshold ?: 0)
        result = 31 * result + (watchlistIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EnrollmentJobFraudDetectionConfig

        if (fraudDetectionAction != other.fraudDetectionAction) return false
        if (riskThreshold != other.riskThreshold) return false
        if (watchlistIds != other.watchlistIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.voiceid.model.EnrollmentJobFraudDetectionConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The action to take when the given speaker is flagged by the fraud detection system. The default value is `FAIL`, which fails the speaker enrollment. Changing this value to `IGNORE` results in the speaker being enrolled even if they are flagged by the fraud detection system.
         */
        public var fraudDetectionAction: aws.sdk.kotlin.services.voiceid.model.FraudDetectionAction? = null
        /**
         * Threshold value for determining whether the speaker is a high risk to be fraudulent. If the detected risk score calculated by Voice ID is greater than or equal to the threshold, the speaker is considered a fraudster.
         */
        public var riskThreshold: kotlin.Int? = null
        /**
         * The identifier of watchlists against which fraud detection is performed.
         */
        public var watchlistIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.voiceid.model.EnrollmentJobFraudDetectionConfig) : this() {
            this.fraudDetectionAction = x.fraudDetectionAction
            this.riskThreshold = x.riskThreshold
            this.watchlistIds = x.watchlistIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.voiceid.model.EnrollmentJobFraudDetectionConfig = EnrollmentJobFraudDetectionConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
