// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.voiceid.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains all the information about a fraudster registration job.
 */
public class FraudsterRegistrationJob private constructor(builder: Builder) {
    /**
     * A timestamp of when the fraudster registration job was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets to read the input manifest file and write the job output file.
     */
    public val dataAccessRoleArn: kotlin.String? = builder.dataAccessRoleArn
    /**
     * The identifier of the domain that contains the fraudster registration job.
     */
    public val domainId: kotlin.String? = builder.domainId
    /**
     * A timestamp of when the fraudster registration job ended.
     */
    public val endedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.endedAt
    /**
     * Contains details that are populated when an entire batch job fails. In cases of individual registration job failures, the batch job as a whole doesn't fail; it is completed with a `JobStatus` of `COMPLETED_WITH_ERRORS`. You can use the job output file to identify the individual registration requests that failed.
     */
    public val failureDetails: aws.sdk.kotlin.services.voiceid.model.FailureDetails? = builder.failureDetails
    /**
     * The input data config containing an S3 URI for the input manifest file that contains the list of fraudster registration job requests.
     */
    public val inputDataConfig: aws.sdk.kotlin.services.voiceid.model.InputDataConfig? = builder.inputDataConfig
    /**
     * The service-generated identifier for the fraudster registration job.
     */
    public val jobId: kotlin.String? = builder.jobId
    /**
     * The client-provided name for the fraudster registration job.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * Shows the completed percentage of registration requests listed in the input file.
     */
    public val jobProgress: aws.sdk.kotlin.services.voiceid.model.JobProgress? = builder.jobProgress
    /**
     * The current status of the fraudster registration job.
     */
    public val jobStatus: aws.sdk.kotlin.services.voiceid.model.FraudsterRegistrationJobStatus? = builder.jobStatus
    /**
     * The output data config containing the S3 location where you want Voice ID to write your job output file; you must also include a KMS key ID in order to encrypt the file.
     */
    public val outputDataConfig: aws.sdk.kotlin.services.voiceid.model.OutputDataConfig? = builder.outputDataConfig
    /**
     * The registration config containing details such as the action to take when a duplicate fraudster is detected, and the similarity threshold to use for detecting a duplicate fraudster.
     */
    public val registrationConfig: aws.sdk.kotlin.services.voiceid.model.RegistrationConfig? = builder.registrationConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.voiceid.model.FraudsterRegistrationJob = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FraudsterRegistrationJob(")
        append("createdAt=$createdAt,")
        append("dataAccessRoleArn=$dataAccessRoleArn,")
        append("domainId=$domainId,")
        append("endedAt=$endedAt,")
        append("failureDetails=$failureDetails,")
        append("inputDataConfig=$inputDataConfig,")
        append("jobId=$jobId,")
        append("jobName=*** Sensitive Data Redacted ***,")
        append("jobProgress=$jobProgress,")
        append("jobStatus=$jobStatus,")
        append("outputDataConfig=$outputDataConfig,")
        append("registrationConfig=$registrationConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (dataAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (domainId?.hashCode() ?: 0)
        result = 31 * result + (endedAt?.hashCode() ?: 0)
        result = 31 * result + (failureDetails?.hashCode() ?: 0)
        result = 31 * result + (inputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (jobProgress?.hashCode() ?: 0)
        result = 31 * result + (jobStatus?.hashCode() ?: 0)
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (registrationConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FraudsterRegistrationJob

        if (createdAt != other.createdAt) return false
        if (dataAccessRoleArn != other.dataAccessRoleArn) return false
        if (domainId != other.domainId) return false
        if (endedAt != other.endedAt) return false
        if (failureDetails != other.failureDetails) return false
        if (inputDataConfig != other.inputDataConfig) return false
        if (jobId != other.jobId) return false
        if (jobName != other.jobName) return false
        if (jobProgress != other.jobProgress) return false
        if (jobStatus != other.jobStatus) return false
        if (outputDataConfig != other.outputDataConfig) return false
        if (registrationConfig != other.registrationConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.voiceid.model.FraudsterRegistrationJob = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A timestamp of when the fraudster registration job was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets to read the input manifest file and write the job output file.
         */
        public var dataAccessRoleArn: kotlin.String? = null
        /**
         * The identifier of the domain that contains the fraudster registration job.
         */
        public var domainId: kotlin.String? = null
        /**
         * A timestamp of when the fraudster registration job ended.
         */
        public var endedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Contains details that are populated when an entire batch job fails. In cases of individual registration job failures, the batch job as a whole doesn't fail; it is completed with a `JobStatus` of `COMPLETED_WITH_ERRORS`. You can use the job output file to identify the individual registration requests that failed.
         */
        public var failureDetails: aws.sdk.kotlin.services.voiceid.model.FailureDetails? = null
        /**
         * The input data config containing an S3 URI for the input manifest file that contains the list of fraudster registration job requests.
         */
        public var inputDataConfig: aws.sdk.kotlin.services.voiceid.model.InputDataConfig? = null
        /**
         * The service-generated identifier for the fraudster registration job.
         */
        public var jobId: kotlin.String? = null
        /**
         * The client-provided name for the fraudster registration job.
         */
        public var jobName: kotlin.String? = null
        /**
         * Shows the completed percentage of registration requests listed in the input file.
         */
        public var jobProgress: aws.sdk.kotlin.services.voiceid.model.JobProgress? = null
        /**
         * The current status of the fraudster registration job.
         */
        public var jobStatus: aws.sdk.kotlin.services.voiceid.model.FraudsterRegistrationJobStatus? = null
        /**
         * The output data config containing the S3 location where you want Voice ID to write your job output file; you must also include a KMS key ID in order to encrypt the file.
         */
        public var outputDataConfig: aws.sdk.kotlin.services.voiceid.model.OutputDataConfig? = null
        /**
         * The registration config containing details such as the action to take when a duplicate fraudster is detected, and the similarity threshold to use for detecting a duplicate fraudster.
         */
        public var registrationConfig: aws.sdk.kotlin.services.voiceid.model.RegistrationConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.voiceid.model.FraudsterRegistrationJob) : this() {
            this.createdAt = x.createdAt
            this.dataAccessRoleArn = x.dataAccessRoleArn
            this.domainId = x.domainId
            this.endedAt = x.endedAt
            this.failureDetails = x.failureDetails
            this.inputDataConfig = x.inputDataConfig
            this.jobId = x.jobId
            this.jobName = x.jobName
            this.jobProgress = x.jobProgress
            this.jobStatus = x.jobStatus
            this.outputDataConfig = x.outputDataConfig
            this.registrationConfig = x.registrationConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.voiceid.model.FraudsterRegistrationJob = FraudsterRegistrationJob(this)

        /**
         * construct an [aws.sdk.kotlin.services.voiceid.model.FailureDetails] inside the given [block]
         */
        public fun failureDetails(block: aws.sdk.kotlin.services.voiceid.model.FailureDetails.Builder.() -> kotlin.Unit) {
            this.failureDetails = aws.sdk.kotlin.services.voiceid.model.FailureDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.voiceid.model.InputDataConfig] inside the given [block]
         */
        public fun inputDataConfig(block: aws.sdk.kotlin.services.voiceid.model.InputDataConfig.Builder.() -> kotlin.Unit) {
            this.inputDataConfig = aws.sdk.kotlin.services.voiceid.model.InputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.voiceid.model.JobProgress] inside the given [block]
         */
        public fun jobProgress(block: aws.sdk.kotlin.services.voiceid.model.JobProgress.Builder.() -> kotlin.Unit) {
            this.jobProgress = aws.sdk.kotlin.services.voiceid.model.JobProgress.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.voiceid.model.OutputDataConfig] inside the given [block]
         */
        public fun outputDataConfig(block: aws.sdk.kotlin.services.voiceid.model.OutputDataConfig.Builder.() -> kotlin.Unit) {
            this.outputDataConfig = aws.sdk.kotlin.services.voiceid.model.OutputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.voiceid.model.RegistrationConfig] inside the given [block]
         */
        public fun registrationConfig(block: aws.sdk.kotlin.services.voiceid.model.RegistrationConfig.Builder.() -> kotlin.Unit) {
            this.registrationConfig = aws.sdk.kotlin.services.voiceid.model.RegistrationConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
