// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.voiceid

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.voiceid.auth.DefaultVoiceIdAuthSchemeProvider
import aws.sdk.kotlin.services.voiceid.auth.VoiceIdAuthSchemeProvider
import aws.sdk.kotlin.services.voiceid.endpoints.DefaultVoiceIdEndpointProvider
import aws.sdk.kotlin.services.voiceid.endpoints.VoiceIdEndpointParameters
import aws.sdk.kotlin.services.voiceid.endpoints.VoiceIdEndpointProvider
import aws.sdk.kotlin.services.voiceid.model.AssociateFraudsterRequest
import aws.sdk.kotlin.services.voiceid.model.AssociateFraudsterResponse
import aws.sdk.kotlin.services.voiceid.model.CreateDomainRequest
import aws.sdk.kotlin.services.voiceid.model.CreateDomainResponse
import aws.sdk.kotlin.services.voiceid.model.CreateWatchlistRequest
import aws.sdk.kotlin.services.voiceid.model.CreateWatchlistResponse
import aws.sdk.kotlin.services.voiceid.model.DeleteDomainRequest
import aws.sdk.kotlin.services.voiceid.model.DeleteDomainResponse
import aws.sdk.kotlin.services.voiceid.model.DeleteFraudsterRequest
import aws.sdk.kotlin.services.voiceid.model.DeleteFraudsterResponse
import aws.sdk.kotlin.services.voiceid.model.DeleteSpeakerRequest
import aws.sdk.kotlin.services.voiceid.model.DeleteSpeakerResponse
import aws.sdk.kotlin.services.voiceid.model.DeleteWatchlistRequest
import aws.sdk.kotlin.services.voiceid.model.DeleteWatchlistResponse
import aws.sdk.kotlin.services.voiceid.model.DescribeDomainRequest
import aws.sdk.kotlin.services.voiceid.model.DescribeDomainResponse
import aws.sdk.kotlin.services.voiceid.model.DescribeFraudsterRegistrationJobRequest
import aws.sdk.kotlin.services.voiceid.model.DescribeFraudsterRegistrationJobResponse
import aws.sdk.kotlin.services.voiceid.model.DescribeFraudsterRequest
import aws.sdk.kotlin.services.voiceid.model.DescribeFraudsterResponse
import aws.sdk.kotlin.services.voiceid.model.DescribeSpeakerEnrollmentJobRequest
import aws.sdk.kotlin.services.voiceid.model.DescribeSpeakerEnrollmentJobResponse
import aws.sdk.kotlin.services.voiceid.model.DescribeSpeakerRequest
import aws.sdk.kotlin.services.voiceid.model.DescribeSpeakerResponse
import aws.sdk.kotlin.services.voiceid.model.DescribeWatchlistRequest
import aws.sdk.kotlin.services.voiceid.model.DescribeWatchlistResponse
import aws.sdk.kotlin.services.voiceid.model.DisassociateFraudsterRequest
import aws.sdk.kotlin.services.voiceid.model.DisassociateFraudsterResponse
import aws.sdk.kotlin.services.voiceid.model.EvaluateSessionRequest
import aws.sdk.kotlin.services.voiceid.model.EvaluateSessionResponse
import aws.sdk.kotlin.services.voiceid.model.ListDomainsRequest
import aws.sdk.kotlin.services.voiceid.model.ListDomainsResponse
import aws.sdk.kotlin.services.voiceid.model.ListFraudsterRegistrationJobsRequest
import aws.sdk.kotlin.services.voiceid.model.ListFraudsterRegistrationJobsResponse
import aws.sdk.kotlin.services.voiceid.model.ListFraudstersRequest
import aws.sdk.kotlin.services.voiceid.model.ListFraudstersResponse
import aws.sdk.kotlin.services.voiceid.model.ListSpeakerEnrollmentJobsRequest
import aws.sdk.kotlin.services.voiceid.model.ListSpeakerEnrollmentJobsResponse
import aws.sdk.kotlin.services.voiceid.model.ListSpeakersRequest
import aws.sdk.kotlin.services.voiceid.model.ListSpeakersResponse
import aws.sdk.kotlin.services.voiceid.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.voiceid.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.voiceid.model.ListWatchlistsRequest
import aws.sdk.kotlin.services.voiceid.model.ListWatchlistsResponse
import aws.sdk.kotlin.services.voiceid.model.OptOutSpeakerRequest
import aws.sdk.kotlin.services.voiceid.model.OptOutSpeakerResponse
import aws.sdk.kotlin.services.voiceid.model.StartFraudsterRegistrationJobRequest
import aws.sdk.kotlin.services.voiceid.model.StartFraudsterRegistrationJobResponse
import aws.sdk.kotlin.services.voiceid.model.StartSpeakerEnrollmentJobRequest
import aws.sdk.kotlin.services.voiceid.model.StartSpeakerEnrollmentJobResponse
import aws.sdk.kotlin.services.voiceid.model.TagResourceRequest
import aws.sdk.kotlin.services.voiceid.model.TagResourceResponse
import aws.sdk.kotlin.services.voiceid.model.UntagResourceRequest
import aws.sdk.kotlin.services.voiceid.model.UntagResourceResponse
import aws.sdk.kotlin.services.voiceid.model.UpdateDomainRequest
import aws.sdk.kotlin.services.voiceid.model.UpdateDomainResponse
import aws.sdk.kotlin.services.voiceid.model.UpdateWatchlistRequest
import aws.sdk.kotlin.services.voiceid.model.UpdateWatchlistResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Voice ID"
public const val SdkVersion: String = "0.33.0-beta"

/**
 * Amazon Connect Voice ID provides real-time caller authentication and fraud risk detection, which make voice interactions in contact centers more secure and efficient.
 */
public interface VoiceIdClient : SdkClient {
    /**
     * VoiceIdClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, VoiceIdClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>) {
            builder.config.interceptors.add(0, ClockSkewInterceptor())
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "VoiceId",
                "VOICE_ID",
                "voice_id",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, VoiceIdClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): VoiceIdClient = DefaultVoiceIdClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        public val authSchemeProvider: VoiceIdAuthSchemeProvider = builder.authSchemeProvider ?: DefaultVoiceIdAuthSchemeProvider
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: VoiceIdEndpointProvider = builder.endpointProvider ?: DefaultVoiceIdEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemeProvider = this@Config.authSchemeProvider
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Voice ID"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: VoiceIdAuthSchemeProvider? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: VoiceIdEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates the fraudsters with the watchlist specified in the same domain.
     */
    public suspend fun associateFraudster(input: AssociateFraudsterRequest): AssociateFraudsterResponse

    /**
     * Creates a domain that contains all Amazon Connect Voice ID data, such as speakers, fraudsters, customer audio, and voiceprints. Every domain is created with a default watchlist that fraudsters can be a part of.
     */
    public suspend fun createDomain(input: CreateDomainRequest): CreateDomainResponse

    /**
     * Creates a watchlist that fraudsters can be a part of.
     */
    public suspend fun createWatchlist(input: CreateWatchlistRequest): CreateWatchlistResponse

    /**
     * Deletes the specified domain from Voice ID.
     */
    public suspend fun deleteDomain(input: DeleteDomainRequest): DeleteDomainResponse

    /**
     * Deletes the specified fraudster from Voice ID. This action disassociates the fraudster from any watchlists it is a part of.
     */
    public suspend fun deleteFraudster(input: DeleteFraudsterRequest): DeleteFraudsterResponse

    /**
     * Deletes the specified speaker from Voice ID.
     */
    public suspend fun deleteSpeaker(input: DeleteSpeakerRequest): DeleteSpeakerResponse

    /**
     * Deletes the specified watchlist from Voice ID. This API throws an exception when there are fraudsters in the watchlist that you are trying to delete. You must delete the fraudsters, and then delete the watchlist. Every domain has a default watchlist which cannot be deleted.
     */
    public suspend fun deleteWatchlist(input: DeleteWatchlistRequest): DeleteWatchlistResponse

    /**
     * Describes the specified domain.
     */
    public suspend fun describeDomain(input: DescribeDomainRequest): DescribeDomainResponse

    /**
     * Describes the specified fraudster.
     */
    public suspend fun describeFraudster(input: DescribeFraudsterRequest): DescribeFraudsterResponse

    /**
     * Describes the specified fraudster registration job.
     */
    public suspend fun describeFraudsterRegistrationJob(input: DescribeFraudsterRegistrationJobRequest): DescribeFraudsterRegistrationJobResponse

    /**
     * Describes the specified speaker.
     */
    public suspend fun describeSpeaker(input: DescribeSpeakerRequest): DescribeSpeakerResponse

    /**
     * Describes the specified speaker enrollment job.
     */
    public suspend fun describeSpeakerEnrollmentJob(input: DescribeSpeakerEnrollmentJobRequest): DescribeSpeakerEnrollmentJobResponse

    /**
     * Describes the specified watchlist.
     */
    public suspend fun describeWatchlist(input: DescribeWatchlistRequest): DescribeWatchlistResponse

    /**
     * Disassociates the fraudsters from the watchlist specified. Voice ID always expects a fraudster to be a part of at least one watchlist. If you try to disassociate a fraudster from its only watchlist, a `ValidationException` is thrown.
     */
    public suspend fun disassociateFraudster(input: DisassociateFraudsterRequest): DisassociateFraudsterResponse

    /**
     * Evaluates a specified session based on audio data accumulated during a streaming Amazon Connect Voice ID call.
     */
    public suspend fun evaluateSession(input: EvaluateSessionRequest): EvaluateSessionResponse

    /**
     * Lists all the domains in the Amazon Web Services account.
     */
    public suspend fun listDomains(input: ListDomainsRequest = ListDomainsRequest { }): ListDomainsResponse

    /**
     * Lists all the fraudster registration jobs in the domain with the given `JobStatus`. If `JobStatus` is not provided, this lists all fraudster registration jobs in the given domain.
     */
    public suspend fun listFraudsterRegistrationJobs(input: ListFraudsterRegistrationJobsRequest): ListFraudsterRegistrationJobsResponse

    /**
     * Lists all fraudsters in a specified watchlist or domain.
     */
    public suspend fun listFraudsters(input: ListFraudstersRequest): ListFraudstersResponse

    /**
     * Lists all the speaker enrollment jobs in the domain with the specified `JobStatus`. If `JobStatus` is not provided, this lists all jobs with all possible speaker enrollment job statuses.
     */
    public suspend fun listSpeakerEnrollmentJobs(input: ListSpeakerEnrollmentJobsRequest): ListSpeakerEnrollmentJobsResponse

    /**
     * Lists all speakers in a specified domain.
     */
    public suspend fun listSpeakers(input: ListSpeakersRequest): ListSpeakersResponse

    /**
     * Lists all tags associated with a specified Voice ID resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists all watchlists in a specified domain.
     */
    public suspend fun listWatchlists(input: ListWatchlistsRequest): ListWatchlistsResponse

    /**
     * Opts out a speaker from Voice ID. A speaker can be opted out regardless of whether or not they already exist in Voice ID. If they don't yet exist, a new speaker is created in an opted out state. If they already exist, their existing status is overridden and they are opted out. Enrollment and evaluation authentication requests are rejected for opted out speakers, and opted out speakers have no voice embeddings stored in Voice ID.
     */
    public suspend fun optOutSpeaker(input: OptOutSpeakerRequest): OptOutSpeakerResponse

    /**
     * Starts a new batch fraudster registration job using provided details.
     */
    public suspend fun startFraudsterRegistrationJob(input: StartFraudsterRegistrationJobRequest): StartFraudsterRegistrationJobResponse

    /**
     * Starts a new batch speaker enrollment job using specified details.
     */
    public suspend fun startSpeakerEnrollmentJob(input: StartSpeakerEnrollmentJobRequest): StartSpeakerEnrollmentJobResponse

    /**
     * Tags a Voice ID resource with the provided list of tags.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes specified tags from a specified Amazon Connect Voice ID resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the specified domain. This API has clobber behavior, and clears and replaces all attributes. If an optional field, such as 'Description' is not provided, it is removed from the domain.
     */
    public suspend fun updateDomain(input: UpdateDomainRequest): UpdateDomainResponse

    /**
     * Updates the specified watchlist. Every domain has a default watchlist which cannot be updated.
     */
    public suspend fun updateWatchlist(input: UpdateWatchlistRequest): UpdateWatchlistResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun VoiceIdClient.withConfig(block: VoiceIdClient.Config.Builder.() -> Unit): VoiceIdClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultVoiceIdClient(newConfig)
}

/**
 * Associates the fraudsters with the watchlist specified in the same domain.
 */
public suspend inline fun VoiceIdClient.associateFraudster(crossinline block: AssociateFraudsterRequest.Builder.() -> Unit): AssociateFraudsterResponse = associateFraudster(AssociateFraudsterRequest.Builder().apply(block).build())

/**
 * Creates a domain that contains all Amazon Connect Voice ID data, such as speakers, fraudsters, customer audio, and voiceprints. Every domain is created with a default watchlist that fraudsters can be a part of.
 */
public suspend inline fun VoiceIdClient.createDomain(crossinline block: CreateDomainRequest.Builder.() -> Unit): CreateDomainResponse = createDomain(CreateDomainRequest.Builder().apply(block).build())

/**
 * Creates a watchlist that fraudsters can be a part of.
 */
public suspend inline fun VoiceIdClient.createWatchlist(crossinline block: CreateWatchlistRequest.Builder.() -> Unit): CreateWatchlistResponse = createWatchlist(CreateWatchlistRequest.Builder().apply(block).build())

/**
 * Deletes the specified domain from Voice ID.
 */
public suspend inline fun VoiceIdClient.deleteDomain(crossinline block: DeleteDomainRequest.Builder.() -> Unit): DeleteDomainResponse = deleteDomain(DeleteDomainRequest.Builder().apply(block).build())

/**
 * Deletes the specified fraudster from Voice ID. This action disassociates the fraudster from any watchlists it is a part of.
 */
public suspend inline fun VoiceIdClient.deleteFraudster(crossinline block: DeleteFraudsterRequest.Builder.() -> Unit): DeleteFraudsterResponse = deleteFraudster(DeleteFraudsterRequest.Builder().apply(block).build())

/**
 * Deletes the specified speaker from Voice ID.
 */
public suspend inline fun VoiceIdClient.deleteSpeaker(crossinline block: DeleteSpeakerRequest.Builder.() -> Unit): DeleteSpeakerResponse = deleteSpeaker(DeleteSpeakerRequest.Builder().apply(block).build())

/**
 * Deletes the specified watchlist from Voice ID. This API throws an exception when there are fraudsters in the watchlist that you are trying to delete. You must delete the fraudsters, and then delete the watchlist. Every domain has a default watchlist which cannot be deleted.
 */
public suspend inline fun VoiceIdClient.deleteWatchlist(crossinline block: DeleteWatchlistRequest.Builder.() -> Unit): DeleteWatchlistResponse = deleteWatchlist(DeleteWatchlistRequest.Builder().apply(block).build())

/**
 * Describes the specified domain.
 */
public suspend inline fun VoiceIdClient.describeDomain(crossinline block: DescribeDomainRequest.Builder.() -> Unit): DescribeDomainResponse = describeDomain(DescribeDomainRequest.Builder().apply(block).build())

/**
 * Describes the specified fraudster.
 */
public suspend inline fun VoiceIdClient.describeFraudster(crossinline block: DescribeFraudsterRequest.Builder.() -> Unit): DescribeFraudsterResponse = describeFraudster(DescribeFraudsterRequest.Builder().apply(block).build())

/**
 * Describes the specified fraudster registration job.
 */
public suspend inline fun VoiceIdClient.describeFraudsterRegistrationJob(crossinline block: DescribeFraudsterRegistrationJobRequest.Builder.() -> Unit): DescribeFraudsterRegistrationJobResponse = describeFraudsterRegistrationJob(DescribeFraudsterRegistrationJobRequest.Builder().apply(block).build())

/**
 * Describes the specified speaker.
 */
public suspend inline fun VoiceIdClient.describeSpeaker(crossinline block: DescribeSpeakerRequest.Builder.() -> Unit): DescribeSpeakerResponse = describeSpeaker(DescribeSpeakerRequest.Builder().apply(block).build())

/**
 * Describes the specified speaker enrollment job.
 */
public suspend inline fun VoiceIdClient.describeSpeakerEnrollmentJob(crossinline block: DescribeSpeakerEnrollmentJobRequest.Builder.() -> Unit): DescribeSpeakerEnrollmentJobResponse = describeSpeakerEnrollmentJob(DescribeSpeakerEnrollmentJobRequest.Builder().apply(block).build())

/**
 * Describes the specified watchlist.
 */
public suspend inline fun VoiceIdClient.describeWatchlist(crossinline block: DescribeWatchlistRequest.Builder.() -> Unit): DescribeWatchlistResponse = describeWatchlist(DescribeWatchlistRequest.Builder().apply(block).build())

/**
 * Disassociates the fraudsters from the watchlist specified. Voice ID always expects a fraudster to be a part of at least one watchlist. If you try to disassociate a fraudster from its only watchlist, a `ValidationException` is thrown.
 */
public suspend inline fun VoiceIdClient.disassociateFraudster(crossinline block: DisassociateFraudsterRequest.Builder.() -> Unit): DisassociateFraudsterResponse = disassociateFraudster(DisassociateFraudsterRequest.Builder().apply(block).build())

/**
 * Evaluates a specified session based on audio data accumulated during a streaming Amazon Connect Voice ID call.
 */
public suspend inline fun VoiceIdClient.evaluateSession(crossinline block: EvaluateSessionRequest.Builder.() -> Unit): EvaluateSessionResponse = evaluateSession(EvaluateSessionRequest.Builder().apply(block).build())

/**
 * Lists all the domains in the Amazon Web Services account.
 */
public suspend inline fun VoiceIdClient.listDomains(crossinline block: ListDomainsRequest.Builder.() -> Unit): ListDomainsResponse = listDomains(ListDomainsRequest.Builder().apply(block).build())

/**
 * Lists all the fraudster registration jobs in the domain with the given `JobStatus`. If `JobStatus` is not provided, this lists all fraudster registration jobs in the given domain.
 */
public suspend inline fun VoiceIdClient.listFraudsterRegistrationJobs(crossinline block: ListFraudsterRegistrationJobsRequest.Builder.() -> Unit): ListFraudsterRegistrationJobsResponse = listFraudsterRegistrationJobs(ListFraudsterRegistrationJobsRequest.Builder().apply(block).build())

/**
 * Lists all fraudsters in a specified watchlist or domain.
 */
public suspend inline fun VoiceIdClient.listFraudsters(crossinline block: ListFraudstersRequest.Builder.() -> Unit): ListFraudstersResponse = listFraudsters(ListFraudstersRequest.Builder().apply(block).build())

/**
 * Lists all the speaker enrollment jobs in the domain with the specified `JobStatus`. If `JobStatus` is not provided, this lists all jobs with all possible speaker enrollment job statuses.
 */
public suspend inline fun VoiceIdClient.listSpeakerEnrollmentJobs(crossinline block: ListSpeakerEnrollmentJobsRequest.Builder.() -> Unit): ListSpeakerEnrollmentJobsResponse = listSpeakerEnrollmentJobs(ListSpeakerEnrollmentJobsRequest.Builder().apply(block).build())

/**
 * Lists all speakers in a specified domain.
 */
public suspend inline fun VoiceIdClient.listSpeakers(crossinline block: ListSpeakersRequest.Builder.() -> Unit): ListSpeakersResponse = listSpeakers(ListSpeakersRequest.Builder().apply(block).build())

/**
 * Lists all tags associated with a specified Voice ID resource.
 */
public suspend inline fun VoiceIdClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists all watchlists in a specified domain.
 */
public suspend inline fun VoiceIdClient.listWatchlists(crossinline block: ListWatchlistsRequest.Builder.() -> Unit): ListWatchlistsResponse = listWatchlists(ListWatchlistsRequest.Builder().apply(block).build())

/**
 * Opts out a speaker from Voice ID. A speaker can be opted out regardless of whether or not they already exist in Voice ID. If they don't yet exist, a new speaker is created in an opted out state. If they already exist, their existing status is overridden and they are opted out. Enrollment and evaluation authentication requests are rejected for opted out speakers, and opted out speakers have no voice embeddings stored in Voice ID.
 */
public suspend inline fun VoiceIdClient.optOutSpeaker(crossinline block: OptOutSpeakerRequest.Builder.() -> Unit): OptOutSpeakerResponse = optOutSpeaker(OptOutSpeakerRequest.Builder().apply(block).build())

/**
 * Starts a new batch fraudster registration job using provided details.
 */
public suspend inline fun VoiceIdClient.startFraudsterRegistrationJob(crossinline block: StartFraudsterRegistrationJobRequest.Builder.() -> Unit): StartFraudsterRegistrationJobResponse = startFraudsterRegistrationJob(StartFraudsterRegistrationJobRequest.Builder().apply(block).build())

/**
 * Starts a new batch speaker enrollment job using specified details.
 */
public suspend inline fun VoiceIdClient.startSpeakerEnrollmentJob(crossinline block: StartSpeakerEnrollmentJobRequest.Builder.() -> Unit): StartSpeakerEnrollmentJobResponse = startSpeakerEnrollmentJob(StartSpeakerEnrollmentJobRequest.Builder().apply(block).build())

/**
 * Tags a Voice ID resource with the provided list of tags.
 */
public suspend inline fun VoiceIdClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes specified tags from a specified Amazon Connect Voice ID resource.
 */
public suspend inline fun VoiceIdClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the specified domain. This API has clobber behavior, and clears and replaces all attributes. If an optional field, such as 'Description' is not provided, it is removed from the domain.
 */
public suspend inline fun VoiceIdClient.updateDomain(crossinline block: UpdateDomainRequest.Builder.() -> Unit): UpdateDomainResponse = updateDomain(UpdateDomainRequest.Builder().apply(block).build())

/**
 * Updates the specified watchlist. Every domain has a default watchlist which cannot be updated.
 */
public suspend inline fun VoiceIdClient.updateWatchlist(crossinline block: UpdateWatchlistRequest.Builder.() -> Unit): UpdateWatchlistResponse = updateWatchlist(UpdateWatchlistRequest.Builder().apply(block).build())
