// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.voiceid.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.voiceid.model.DescribeSpeakerEnrollmentJobResponse
import aws.sdk.kotlin.services.voiceid.model.SpeakerEnrollmentJob
import aws.sdk.kotlin.services.voiceid.model.VoiceIdException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeSpeakerEnrollmentJobOperationDeserializer: HttpDeserialize<DescribeSpeakerEnrollmentJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeSpeakerEnrollmentJobResponse {
        if (!response.status.isSuccess()) {
            throwDescribeSpeakerEnrollmentJobError(context, response)
        }
        val builder = DescribeSpeakerEnrollmentJobResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeSpeakerEnrollmentJobOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeSpeakerEnrollmentJobError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw VoiceIdException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> VoiceIdException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeSpeakerEnrollmentJobOperationBody(builder: DescribeSpeakerEnrollmentJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val JOB_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Job"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(JOB_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                JOB_DESCRIPTOR.index -> builder.job = deserializeSpeakerEnrollmentJobDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
