// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.voiceid.paginators

import aws.sdk.kotlin.services.voiceid.VoiceIdClient
import aws.sdk.kotlin.services.voiceid.model.FraudsterRegistrationJobSummary
import aws.sdk.kotlin.services.voiceid.model.ListFraudsterRegistrationJobsRequest
import aws.sdk.kotlin.services.voiceid.model.ListFraudsterRegistrationJobsResponse
import aws.sdk.kotlin.services.voiceid.model.ListSpeakerEnrollmentJobsRequest
import aws.sdk.kotlin.services.voiceid.model.ListSpeakerEnrollmentJobsResponse
import aws.sdk.kotlin.services.voiceid.model.ListSpeakersRequest
import aws.sdk.kotlin.services.voiceid.model.ListSpeakersResponse
import aws.sdk.kotlin.services.voiceid.model.SpeakerEnrollmentJobSummary
import aws.sdk.kotlin.services.voiceid.model.SpeakerSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListFraudsterRegistrationJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFraudsterRegistrationJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFraudsterRegistrationJobsResponse]
 */
public fun VoiceIdClient.listFraudsterRegistrationJobsPaginated(initialRequest: ListFraudsterRegistrationJobsRequest): Flow<ListFraudsterRegistrationJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFraudsterRegistrationJobsPaginated.listFraudsterRegistrationJobs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFraudsterRegistrationJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFraudsterRegistrationJobsResponse]
 */
public fun VoiceIdClient.listFraudsterRegistrationJobsPaginated(block: ListFraudsterRegistrationJobsRequest.Builder.() -> Unit): Flow<ListFraudsterRegistrationJobsResponse> =
    listFraudsterRegistrationJobsPaginated(ListFraudsterRegistrationJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFraudsterRegistrationJobsPaginated]
 * to access the nested member [FraudsterRegistrationJobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FraudsterRegistrationJobSummary]
 */
@JvmName("listFraudsterRegistrationJobsResponseFraudsterRegistrationJobSummary")
public fun Flow<ListFraudsterRegistrationJobsResponse>.jobSummaries(): Flow<FraudsterRegistrationJobSummary> =
    transform() { response ->
        response.jobSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSpeakerEnrollmentJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSpeakerEnrollmentJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSpeakerEnrollmentJobsResponse]
 */
public fun VoiceIdClient.listSpeakerEnrollmentJobsPaginated(initialRequest: ListSpeakerEnrollmentJobsRequest): Flow<ListSpeakerEnrollmentJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSpeakerEnrollmentJobsPaginated.listSpeakerEnrollmentJobs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListSpeakerEnrollmentJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSpeakerEnrollmentJobsResponse]
 */
public fun VoiceIdClient.listSpeakerEnrollmentJobsPaginated(block: ListSpeakerEnrollmentJobsRequest.Builder.() -> Unit): Flow<ListSpeakerEnrollmentJobsResponse> =
    listSpeakerEnrollmentJobsPaginated(ListSpeakerEnrollmentJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSpeakerEnrollmentJobsPaginated]
 * to access the nested member [SpeakerEnrollmentJobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SpeakerEnrollmentJobSummary]
 */
@JvmName("listSpeakerEnrollmentJobsResponseSpeakerEnrollmentJobSummary")
public fun Flow<ListSpeakerEnrollmentJobsResponse>.jobSummaries(): Flow<SpeakerEnrollmentJobSummary> =
    transform() { response ->
        response.jobSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSpeakersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSpeakersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSpeakersResponse]
 */
public fun VoiceIdClient.listSpeakersPaginated(initialRequest: ListSpeakersRequest): Flow<ListSpeakersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSpeakersPaginated.listSpeakers(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListSpeakersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSpeakersResponse]
 */
public fun VoiceIdClient.listSpeakersPaginated(block: ListSpeakersRequest.Builder.() -> Unit): Flow<ListSpeakersResponse> =
    listSpeakersPaginated(ListSpeakersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSpeakersPaginated]
 * to access the nested member [SpeakerSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SpeakerSummary]
 */
@JvmName("listSpeakersResponseSpeakerSummary")
public fun Flow<ListSpeakersResponse>.speakerSummaries(): Flow<SpeakerSummary> =
    transform() { response ->
        response.speakerSummaries?.forEach {
            emit(it)
        }
    }
