// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.voiceid.model



public class StartSpeakerEnrollmentJobRequest private constructor(builder: Builder) {
    /**
     * The idempotency token for starting a new speaker enrollment Job. If not provided, Amazon Web Services SDK populates this field.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets to read the input manifest file and write the job output file. Refer to [Batch enrollment using audio data from prior calls](https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-batch-enrollment.html) for the permissions needed in this role.
     */
    public val dataAccessRoleArn: kotlin.String? = builder.dataAccessRoleArn
    /**
     * The identifier of the domain that contains the speaker enrollment job and in which the speakers are enrolled.
     */
    public val domainId: kotlin.String? = builder.domainId
    /**
     * The enrollment config that contains details such as the action to take when a speaker is already enrolled in Voice ID or when a speaker is identified as a fraudster.
     */
    public val enrollmentConfig: aws.sdk.kotlin.services.voiceid.model.EnrollmentConfig? = builder.enrollmentConfig
    /**
     * The input data config containing the S3 location for the input manifest file that contains the list of speaker enrollment requests.
     */
    public val inputDataConfig: aws.sdk.kotlin.services.voiceid.model.InputDataConfig? = builder.inputDataConfig
    /**
     * A name for your speaker enrollment job.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * The output data config containing the S3 location where Voice ID writes the job output file; you must also include a KMS key ID to encrypt the file.
     */
    public val outputDataConfig: aws.sdk.kotlin.services.voiceid.model.OutputDataConfig? = builder.outputDataConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.voiceid.model.StartSpeakerEnrollmentJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartSpeakerEnrollmentJobRequest(")
        append("clientToken=$clientToken,")
        append("dataAccessRoleArn=$dataAccessRoleArn,")
        append("domainId=$domainId,")
        append("enrollmentConfig=$enrollmentConfig,")
        append("inputDataConfig=$inputDataConfig,")
        append("jobName=*** Sensitive Data Redacted ***,")
        append("outputDataConfig=$outputDataConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (dataAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (domainId?.hashCode() ?: 0)
        result = 31 * result + (enrollmentConfig?.hashCode() ?: 0)
        result = 31 * result + (inputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartSpeakerEnrollmentJobRequest

        if (clientToken != other.clientToken) return false
        if (dataAccessRoleArn != other.dataAccessRoleArn) return false
        if (domainId != other.domainId) return false
        if (enrollmentConfig != other.enrollmentConfig) return false
        if (inputDataConfig != other.inputDataConfig) return false
        if (jobName != other.jobName) return false
        if (outputDataConfig != other.outputDataConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.voiceid.model.StartSpeakerEnrollmentJobRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The idempotency token for starting a new speaker enrollment Job. If not provided, Amazon Web Services SDK populates this field.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions to access customer's buckets to read the input manifest file and write the job output file. Refer to [Batch enrollment using audio data from prior calls](https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-batch-enrollment.html) for the permissions needed in this role.
         */
        public var dataAccessRoleArn: kotlin.String? = null
        /**
         * The identifier of the domain that contains the speaker enrollment job and in which the speakers are enrolled.
         */
        public var domainId: kotlin.String? = null
        /**
         * The enrollment config that contains details such as the action to take when a speaker is already enrolled in Voice ID or when a speaker is identified as a fraudster.
         */
        public var enrollmentConfig: aws.sdk.kotlin.services.voiceid.model.EnrollmentConfig? = null
        /**
         * The input data config containing the S3 location for the input manifest file that contains the list of speaker enrollment requests.
         */
        public var inputDataConfig: aws.sdk.kotlin.services.voiceid.model.InputDataConfig? = null
        /**
         * A name for your speaker enrollment job.
         */
        public var jobName: kotlin.String? = null
        /**
         * The output data config containing the S3 location where Voice ID writes the job output file; you must also include a KMS key ID to encrypt the file.
         */
        public var outputDataConfig: aws.sdk.kotlin.services.voiceid.model.OutputDataConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.voiceid.model.StartSpeakerEnrollmentJobRequest) : this() {
            this.clientToken = x.clientToken
            this.dataAccessRoleArn = x.dataAccessRoleArn
            this.domainId = x.domainId
            this.enrollmentConfig = x.enrollmentConfig
            this.inputDataConfig = x.inputDataConfig
            this.jobName = x.jobName
            this.outputDataConfig = x.outputDataConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.voiceid.model.StartSpeakerEnrollmentJobRequest = StartSpeakerEnrollmentJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.voiceid.model.EnrollmentConfig] inside the given [block]
         */
        public fun enrollmentConfig(block: aws.sdk.kotlin.services.voiceid.model.EnrollmentConfig.Builder.() -> kotlin.Unit) {
            this.enrollmentConfig = aws.sdk.kotlin.services.voiceid.model.EnrollmentConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.voiceid.model.InputDataConfig] inside the given [block]
         */
        public fun inputDataConfig(block: aws.sdk.kotlin.services.voiceid.model.InputDataConfig.Builder.() -> kotlin.Unit) {
            this.inputDataConfig = aws.sdk.kotlin.services.voiceid.model.InputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.voiceid.model.OutputDataConfig] inside the given [block]
         */
        public fun outputDataConfig(block: aws.sdk.kotlin.services.voiceid.model.OutputDataConfig.Builder.() -> kotlin.Unit) {
            this.outputDataConfig = aws.sdk.kotlin.services.voiceid.model.OutputDataConfig.invoke(block)
        }
    }
}
