// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.voiceid.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains a summary of information about a speaker.
 */
public class SpeakerSummary private constructor(builder: Builder) {
    /**
     * A timestamp showing the speaker's creation time.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The client-provided identifier for the speaker.
     */
    public val customerSpeakerId: kotlin.String? = builder.customerSpeakerId
    /**
     * The identifier of the domain that contains the speaker.
     */
    public val domainId: kotlin.String? = builder.domainId
    /**
     * The service-generated identifier for the speaker.
     */
    public val generatedSpeakerId: kotlin.String? = builder.generatedSpeakerId
    /**
     * The timestamp when the speaker was last accessed for enrollment, re-enrollment or a successful authentication. This timestamp is accurate to one hour.
     */
    public val lastAccessedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastAccessedAt
    /**
     * The current status of the speaker.
     */
    public val status: aws.sdk.kotlin.services.voiceid.model.SpeakerStatus? = builder.status
    /**
     * A timestamp showing the speaker's last update.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.voiceid.model.SpeakerSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SpeakerSummary(")
        append("createdAt=$createdAt,")
        append("customerSpeakerId=*** Sensitive Data Redacted ***,")
        append("domainId=$domainId,")
        append("generatedSpeakerId=$generatedSpeakerId,")
        append("lastAccessedAt=$lastAccessedAt,")
        append("status=$status,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (customerSpeakerId?.hashCode() ?: 0)
        result = 31 * result + (domainId?.hashCode() ?: 0)
        result = 31 * result + (generatedSpeakerId?.hashCode() ?: 0)
        result = 31 * result + (lastAccessedAt?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SpeakerSummary

        if (createdAt != other.createdAt) return false
        if (customerSpeakerId != other.customerSpeakerId) return false
        if (domainId != other.domainId) return false
        if (generatedSpeakerId != other.generatedSpeakerId) return false
        if (lastAccessedAt != other.lastAccessedAt) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.voiceid.model.SpeakerSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A timestamp showing the speaker's creation time.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The client-provided identifier for the speaker.
         */
        public var customerSpeakerId: kotlin.String? = null
        /**
         * The identifier of the domain that contains the speaker.
         */
        public var domainId: kotlin.String? = null
        /**
         * The service-generated identifier for the speaker.
         */
        public var generatedSpeakerId: kotlin.String? = null
        /**
         * The timestamp when the speaker was last accessed for enrollment, re-enrollment or a successful authentication. This timestamp is accurate to one hour.
         */
        public var lastAccessedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current status of the speaker.
         */
        public var status: aws.sdk.kotlin.services.voiceid.model.SpeakerStatus? = null
        /**
         * A timestamp showing the speaker's last update.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.voiceid.model.SpeakerSummary) : this() {
            this.createdAt = x.createdAt
            this.customerSpeakerId = x.customerSpeakerId
            this.domainId = x.domainId
            this.generatedSpeakerId = x.generatedSpeakerId
            this.lastAccessedAt = x.lastAccessedAt
            this.status = x.status
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.voiceid.model.SpeakerSummary = SpeakerSummary(this)
    }
}
