// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.voiceid.model



/**
 * Details about the most recent server-side encryption configuration update. When the server-side encryption configuration is changed, dependency on the old KMS key is removed through an asynchronous process. When this update is complete, the domain’s data can only be accessed using the new KMS key.
 */
public class ServerSideEncryptionUpdateDetails private constructor(builder: Builder) {
    /**
     * Message explaining the current UpdateStatus. When the UpdateStatus is FAILED, this message explains the cause of the failure.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The previous KMS key ID the domain was encrypted with, before ServerSideEncryptionConfiguration was updated to a new KMS key ID.
     */
    public val oldKmsKeyId: kotlin.String? = builder.oldKmsKeyId
    /**
     * Status of the server-side encryption update. During an update, if there is an issue with the domain's current or old KMS key ID, such as an inaccessible or disabled key, then the status is FAILED. In order to resolve this, the key needs to be made accessible, and then an UpdateDomain call with the existing server-side encryption configuration will re-attempt this update process.
     */
    public val updateStatus: aws.sdk.kotlin.services.voiceid.model.ServerSideEncryptionUpdateStatus? = builder.updateStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.voiceid.model.ServerSideEncryptionUpdateDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServerSideEncryptionUpdateDetails(")
        append("message=$message,")
        append("oldKmsKeyId=$oldKmsKeyId,")
        append("updateStatus=$updateStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        result = 31 * result + (oldKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (updateStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServerSideEncryptionUpdateDetails

        if (message != other.message) return false
        if (oldKmsKeyId != other.oldKmsKeyId) return false
        if (updateStatus != other.updateStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.voiceid.model.ServerSideEncryptionUpdateDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Message explaining the current UpdateStatus. When the UpdateStatus is FAILED, this message explains the cause of the failure.
         */
        public var message: kotlin.String? = null
        /**
         * The previous KMS key ID the domain was encrypted with, before ServerSideEncryptionConfiguration was updated to a new KMS key ID.
         */
        public var oldKmsKeyId: kotlin.String? = null
        /**
         * Status of the server-side encryption update. During an update, if there is an issue with the domain's current or old KMS key ID, such as an inaccessible or disabled key, then the status is FAILED. In order to resolve this, the key needs to be made accessible, and then an UpdateDomain call with the existing server-side encryption configuration will re-attempt this update process.
         */
        public var updateStatus: aws.sdk.kotlin.services.voiceid.model.ServerSideEncryptionUpdateStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.voiceid.model.ServerSideEncryptionUpdateDetails) : this() {
            this.message = x.message
            this.oldKmsKeyId = x.oldKmsKeyId
            this.updateStatus = x.updateStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.voiceid.model.ServerSideEncryptionUpdateDetails = ServerSideEncryptionUpdateDetails(this)
    }
}
