// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.voiceid.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The fraud detection result produced by Voice ID, processed against the current session state and streamed audio of the speaker.
 */
public class FraudDetectionResult private constructor(builder: Builder) {
    /**
     * A timestamp indicating when audio aggregation ended for this fraud detection result.
     */
    public val audioAggregationEndedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.audioAggregationEndedAt
    /**
     * A timestamp indicating when audio aggregation started for this fraud detection result.
     */
    public val audioAggregationStartedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.audioAggregationStartedAt
    /**
     * The `FraudDetectionConfiguration` used to generate this fraud detection result.
     */
    public val configuration: aws.sdk.kotlin.services.voiceid.model.FraudDetectionConfiguration? = builder.configuration
    /**
     * The fraud detection decision produced by Voice ID, processed against the current session state and streamed audio of the speaker.
     */
    public val decision: aws.sdk.kotlin.services.voiceid.model.FraudDetectionDecision? = builder.decision
    /**
     * The unique identifier for this fraud detection result. Given there can be multiple fraud detections for a given session, this field helps in identifying if the returned result is from previous streaming activity or a new result. Note that in the absence of any new streaming activity or risk threshold changes, Voice ID always returns cached Fraud Detection result for this API.
     */
    public val fraudDetectionResultId: kotlin.String? = builder.fraudDetectionResultId
    /**
     * The reason speaker was flagged by the fraud detection system. This is only be populated if fraud detection Decision is `HIGH_RISK`, and the following possible values: `KNOWN_FRAUDSTER` and `VOICE_SPOOFING`.
     */
    public val reasons: List<FraudDetectionReason>? = builder.reasons
    /**
     * Details about each risk analyzed for this speaker. Currently, this contains KnownFraudsterRisk and VoiceSpoofingRisk details.
     */
    public val riskDetails: aws.sdk.kotlin.services.voiceid.model.FraudRiskDetails? = builder.riskDetails

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.voiceid.model.FraudDetectionResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FraudDetectionResult(")
        append("audioAggregationEndedAt=$audioAggregationEndedAt,")
        append("audioAggregationStartedAt=$audioAggregationStartedAt,")
        append("configuration=$configuration,")
        append("decision=$decision,")
        append("fraudDetectionResultId=$fraudDetectionResultId,")
        append("reasons=$reasons,")
        append("riskDetails=$riskDetails)")
    }

    override fun hashCode(): kotlin.Int {
        var result = audioAggregationEndedAt?.hashCode() ?: 0
        result = 31 * result + (audioAggregationStartedAt?.hashCode() ?: 0)
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (decision?.hashCode() ?: 0)
        result = 31 * result + (fraudDetectionResultId?.hashCode() ?: 0)
        result = 31 * result + (reasons?.hashCode() ?: 0)
        result = 31 * result + (riskDetails?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FraudDetectionResult

        if (audioAggregationEndedAt != other.audioAggregationEndedAt) return false
        if (audioAggregationStartedAt != other.audioAggregationStartedAt) return false
        if (configuration != other.configuration) return false
        if (decision != other.decision) return false
        if (fraudDetectionResultId != other.fraudDetectionResultId) return false
        if (reasons != other.reasons) return false
        if (riskDetails != other.riskDetails) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.voiceid.model.FraudDetectionResult = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A timestamp indicating when audio aggregation ended for this fraud detection result.
         */
        public var audioAggregationEndedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A timestamp indicating when audio aggregation started for this fraud detection result.
         */
        public var audioAggregationStartedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The `FraudDetectionConfiguration` used to generate this fraud detection result.
         */
        public var configuration: aws.sdk.kotlin.services.voiceid.model.FraudDetectionConfiguration? = null
        /**
         * The fraud detection decision produced by Voice ID, processed against the current session state and streamed audio of the speaker.
         */
        public var decision: aws.sdk.kotlin.services.voiceid.model.FraudDetectionDecision? = null
        /**
         * The unique identifier for this fraud detection result. Given there can be multiple fraud detections for a given session, this field helps in identifying if the returned result is from previous streaming activity or a new result. Note that in the absence of any new streaming activity or risk threshold changes, Voice ID always returns cached Fraud Detection result for this API.
         */
        public var fraudDetectionResultId: kotlin.String? = null
        /**
         * The reason speaker was flagged by the fraud detection system. This is only be populated if fraud detection Decision is `HIGH_RISK`, and the following possible values: `KNOWN_FRAUDSTER` and `VOICE_SPOOFING`.
         */
        public var reasons: List<FraudDetectionReason>? = null
        /**
         * Details about each risk analyzed for this speaker. Currently, this contains KnownFraudsterRisk and VoiceSpoofingRisk details.
         */
        public var riskDetails: aws.sdk.kotlin.services.voiceid.model.FraudRiskDetails? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.voiceid.model.FraudDetectionResult) : this() {
            this.audioAggregationEndedAt = x.audioAggregationEndedAt
            this.audioAggregationStartedAt = x.audioAggregationStartedAt
            this.configuration = x.configuration
            this.decision = x.decision
            this.fraudDetectionResultId = x.fraudDetectionResultId
            this.reasons = x.reasons
            this.riskDetails = x.riskDetails
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.voiceid.model.FraudDetectionResult = FraudDetectionResult(this)

        /**
         * construct an [aws.sdk.kotlin.services.voiceid.model.FraudDetectionConfiguration] inside the given [block]
         */
        public fun configuration(block: aws.sdk.kotlin.services.voiceid.model.FraudDetectionConfiguration.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.voiceid.model.FraudDetectionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.voiceid.model.FraudRiskDetails] inside the given [block]
         */
        public fun riskDetails(block: aws.sdk.kotlin.services.voiceid.model.FraudRiskDetails.Builder.() -> kotlin.Unit) {
            this.riskDetails = aws.sdk.kotlin.services.voiceid.model.FraudRiskDetails.invoke(block)
        }
    }
}
